/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.api;

import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.impl.EasingMethod;
import me.shedaniel.math.Rectangle;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;

@Deprecated
public abstract class ScrollingContainer {
    public double scrollAmount;
    public double scrollTarget;
    public long start;
    public long duration;
    public boolean draggingScrollBar = false;

    public abstract Rectangle getBounds();

    public Rectangle getScissorBounds() {
        Rectangle bounds = this.getBounds();
        if (this.hasScrollBar()) {
            return new Rectangle(bounds.x, bounds.y, bounds.width - 6, bounds.height);
        }
        return bounds;
    }

    public int getScrollBarX() {
        return this.hasScrollBar() ? this.getBounds().getMaxX() - 6 : this.getBounds().getMaxX();
    }

    public boolean hasScrollBar() {
        return this.getMaxScrollHeight() > this.getBounds().height;
    }

    public abstract int getMaxScrollHeight();

    public final int getMaxScroll() {
        return Math.max(0, this.getMaxScrollHeight() - this.getBounds().height);
    }

    public final double clamp(double v) {
        return this.clamp(v, 200.0);
    }

    public final double clamp(double v, double clampExtension) {
        return Mth.clamp((double)v, (double)(-clampExtension), (double)((double)this.getMaxScroll() + clampExtension));
    }

    public final void offset(double value, boolean animated) {
        this.scrollTo(this.scrollTarget + value, animated);
    }

    public final void scrollTo(double value, boolean animated) {
        this.scrollTo(value, animated, ClothConfigInitializer.getScrollDuration());
    }

    public final void scrollTo(double value, boolean animated, long duration) {
        this.scrollTarget = this.clamp(value);
        if (animated) {
            this.start = System.currentTimeMillis();
            this.duration = duration;
        } else {
            this.scrollAmount = this.scrollTarget;
        }
    }

    public void updatePosition(float delta) {
        double[] target = new double[]{this.scrollTarget};
        this.scrollAmount = ScrollingContainer.handleScrollingPosition(target, this.scrollAmount, this.getMaxScroll(), delta, this.start, this.duration);
        this.scrollTarget = target[0];
    }

    public static double handleScrollingPosition(double[] target, double scroll, double maxScroll, float delta, double start, double duration) {
        return ScrollingContainer.handleScrollingPosition(target, scroll, maxScroll, delta, start, duration, ClothConfigInitializer.getBounceBackMultiplier(), ClothConfigInitializer.getEasingMethod());
    }

    public static double handleScrollingPosition(double[] target, double scroll, double maxScroll, float delta, double start, double duration, double bounceBackMultiplier, EasingMethod easingMethod) {
        if (bounceBackMultiplier >= 0.0) {
            target[0] = ScrollingContainer.clampExtension(target[0], maxScroll);
            if (target[0] < 0.0) {
                target[0] = target[0] - target[0] * (1.0 - bounceBackMultiplier) * (double)delta / 3.0;
            } else if (target[0] > maxScroll) {
                target[0] = (target[0] - maxScroll) * (1.0 - (1.0 - bounceBackMultiplier) * (double)delta / 3.0) + maxScroll;
            }
        } else {
            target[0] = ScrollingContainer.clampExtension(target[0], maxScroll, 0.0);
        }
        return ScrollingContainer.ease(scroll, target[0], Math.min(((double)System.currentTimeMillis() - start) / duration * (double)delta * 3.0, 1.0), easingMethod);
    }

    public static double ease(double start, double end, double amount, EasingMethod easingMethod) {
        return start + (end - start) * easingMethod.apply(amount);
    }

    public static double clampExtension(double value, double maxScroll) {
        return ScrollingContainer.clampExtension(value, maxScroll, 200.0);
    }

    public static double clampExtension(double v, double maxScroll, double clampExtension) {
        return Mth.clamp((double)v, (double)(-clampExtension), (double)(maxScroll + clampExtension));
    }

    public void renderScrollBar(GuiGraphics graphics) {
        this.renderScrollBar(graphics, 0, 1.0f, 1.0f);
    }

    public void renderScrollBar(GuiGraphics graphics, int background, float alpha, float scrollBarAlphaOffset) {
        if (this.hasScrollBar()) {
            Rectangle bounds = this.getBounds();
            int maxScroll = this.getMaxScroll();
            int height = bounds.height * bounds.height / this.getMaxScrollHeight();
            height = Mth.clamp((int)height, (int)32, (int)bounds.height);
            height = (int)((double)height - Math.min((double)(this.scrollAmount < 0.0 ? (int)(-this.scrollAmount) : (this.scrollAmount > (double)maxScroll ? (int)this.scrollAmount - maxScroll : 0)), (double)height * 0.95));
            height = Math.max(10, height);
            int minY = Math.min(Math.max((int)this.scrollAmount * (bounds.height - height) / maxScroll + bounds.y, bounds.y), bounds.getMaxY() - height);
            int scrollbarPositionMinX = this.getScrollBarX();
            graphics.blitSprite(RenderPipelines.GUI_TEXTURED, me.shedaniel.clothconfig2.api.scroll.ScrollingContainer.SCROLLER_BACKGROUND_SPRITE, scrollbarPositionMinX, bounds.y, 6, bounds.height, background);
            graphics.blitSprite(RenderPipelines.GUI_TEXTURED, me.shedaniel.clothconfig2.api.scroll.ScrollingContainer.SCROLLER_SPRITE, scrollbarPositionMinX, minY, 6, height, ARGB.white((float)alpha));
        }
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dx, double dy) {
        return this.mouseDragged(mouseX, mouseY, button, dx, dy, false, 0.0);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dx, double dy, boolean snapToRows, double rowSize) {
        if (button == 0 && this.draggingScrollBar) {
            float height = this.getMaxScrollHeight();
            Rectangle bounds = this.getBounds();
            int actualHeight = bounds.height;
            if (mouseY >= (double)bounds.y && mouseY <= (double)bounds.getMaxY()) {
                double maxScroll = Math.max(1, this.getMaxScroll());
                double int_3 = Mth.clamp((double)((double)(actualHeight * actualHeight) / (double)height), (double)32.0, (double)(actualHeight - 8));
                double double_6 = Math.max(1.0, maxScroll / ((double)actualHeight - int_3));
                float to = Mth.clamp((float)((float)(this.scrollAmount + dy * double_6)), (float)0.0f, (float)this.getMaxScroll());
                if (snapToRows) {
                    double nearestRow = (double)Math.round((double)to / rowSize) * rowSize;
                    this.scrollTo(nearestRow, false);
                } else {
                    this.scrollTo(to, false);
                }
            }
            return true;
        }
        return false;
    }

    public boolean updateDraggingState(double mouseX, double mouseY, int button) {
        double scrollbarPositionMinX;
        if (!this.hasScrollBar()) {
            return false;
        }
        double height = this.getMaxScroll();
        Rectangle bounds = this.getBounds();
        int actualHeight = bounds.height;
        if (height > (double)actualHeight && mouseY >= (double)bounds.y && mouseY <= (double)bounds.getMaxY() && mouseX >= (scrollbarPositionMinX = (double)this.getScrollBarX()) - 1.0 & mouseX <= scrollbarPositionMinX + 8.0) {
            this.draggingScrollBar = true;
            return true;
        }
        this.draggingScrollBar = false;
        return false;
    }
}

