/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.impl.builders;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.entries.LongListEntry;
import me.shedaniel.clothconfig2.impl.builders.AbstractRangeFieldBuilder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class LongFieldBuilder
extends AbstractRangeFieldBuilder<Long, LongListEntry, LongFieldBuilder> {
    public LongFieldBuilder(Component resetButtonKey, Component fieldNameKey, long value) {
        super(resetButtonKey, fieldNameKey);
        this.value = value;
    }

    @Override
    public LongFieldBuilder setErrorSupplier(Function<Long, Optional<Component>> errorSupplier) {
        return (LongFieldBuilder)super.setErrorSupplier(errorSupplier);
    }

    @Override
    public LongFieldBuilder requireRestart() {
        return (LongFieldBuilder)super.requireRestart();
    }

    @Override
    public LongFieldBuilder setSaveConsumer(Consumer<Long> saveConsumer) {
        return (LongFieldBuilder)super.setSaveConsumer(saveConsumer);
    }

    @Override
    public LongFieldBuilder setDefaultValue(Supplier<Long> defaultValue) {
        return (LongFieldBuilder)super.setDefaultValue(defaultValue);
    }

    @Override
    public LongFieldBuilder setDefaultValue(long defaultValue) {
        this.defaultValue = () -> defaultValue;
        return this;
    }

    @Override
    public LongFieldBuilder setTooltipSupplier(Supplier<Optional<Component[]>> tooltipSupplier) {
        return (LongFieldBuilder)super.setTooltipSupplier(tooltipSupplier);
    }

    @Override
    public LongFieldBuilder setTooltipSupplier(Function<Long, Optional<Component[]>> tooltipSupplier) {
        return (LongFieldBuilder)super.setTooltipSupplier(tooltipSupplier);
    }

    @Override
    public LongFieldBuilder setTooltip(Optional<Component[]> tooltip) {
        return (LongFieldBuilder)super.setTooltip(tooltip);
    }

    @Override
    public LongFieldBuilder setTooltip(Component ... tooltip) {
        return (LongFieldBuilder)super.setTooltip(tooltip);
    }

    @Override
    public LongFieldBuilder setMin(long min) {
        this.min = min;
        return this;
    }

    @Override
    public LongFieldBuilder setMax(long max) {
        this.max = max;
        return this;
    }

    @Override
    public LongFieldBuilder removeMin() {
        return (LongFieldBuilder)super.removeMin();
    }

    @Override
    public LongFieldBuilder removeMax() {
        return (LongFieldBuilder)super.removeMax();
    }

    @Override
    @NotNull
    public LongListEntry build() {
        LongListEntry entry = new LongListEntry(this.getFieldNameKey(), (Long)this.value, this.getResetButtonKey(), this.defaultValue, this.getSaveConsumer(), null, this.isRequireRestart());
        if (this.min != null) {
            entry.setMinimum((Long)this.min);
        }
        if (this.max != null) {
            entry.setMaximum((Long)this.max);
        }
        entry.setTooltipSupplier(() -> this.getTooltipSupplier().apply(entry.getValue()));
        if (this.errorSupplier != null) {
            entry.setErrorSupplier(() -> (Optional)this.errorSupplier.apply(entry.getValue()));
        }
        return this.finishBuilding(entry);
    }
}

