/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.api;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import me.shedaniel.clothconfig2.api.Modifier;
import me.shedaniel.clothconfig2.impl.ModifierKeyCodeImpl;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import org.lwjgl.glfw.GLFW;

@Environment(value=EnvType.CLIENT)
public interface ModifierKeyCode {
    public static ModifierKeyCode of(InputConstants.Key keyCode, Modifier modifier) {
        return new ModifierKeyCodeImpl().setKeyCodeAndModifier(keyCode, modifier);
    }

    public static ModifierKeyCode copyOf(ModifierKeyCode code) {
        return ModifierKeyCode.of(code.getKeyCode(), code.getModifier());
    }

    public static ModifierKeyCode unknown() {
        return ModifierKeyCode.of(InputConstants.UNKNOWN, Modifier.none());
    }

    public InputConstants.Key getKeyCode();

    public ModifierKeyCode setKeyCode(InputConstants.Key var1);

    default public InputConstants.Type getType() {
        return this.getKeyCode().getType();
    }

    public Modifier getModifier();

    public ModifierKeyCode setModifier(Modifier var1);

    default public ModifierKeyCode copy() {
        return ModifierKeyCode.copyOf(this);
    }

    default public boolean matchesMouse(int button) {
        return !this.isUnknown() && this.getType() == InputConstants.Type.MOUSE && this.getKeyCode().getValue() == button && this.getModifier().matchesCurrent();
    }

    default public boolean matchesKey(int keyCode, int scanCode) {
        if (this.isUnknown()) {
            return false;
        }
        if (keyCode == InputConstants.UNKNOWN.getValue()) {
            return this.getType() == InputConstants.Type.SCANCODE && this.getKeyCode().getValue() == scanCode && this.getModifier().matchesCurrent();
        }
        return this.getType() == InputConstants.Type.KEYSYM && this.getKeyCode().getValue() == keyCode && this.getModifier().matchesCurrent();
    }

    default public boolean matchesCurrentMouse() {
        if (!this.isUnknown() && this.getType() == InputConstants.Type.MOUSE && this.getModifier().matchesCurrent()) {
            return GLFW.glfwGetMouseButton((long)Minecraft.getInstance().getWindow().handle(), (int)this.getKeyCode().getValue()) == 1;
        }
        return false;
    }

    default public boolean matchesCurrentKey() {
        return !this.isUnknown() && this.getType() == InputConstants.Type.KEYSYM && this.getModifier().matchesCurrent() && InputConstants.isKeyDown((Window)Minecraft.getInstance().getWindow(), (int)this.getKeyCode().getValue());
    }

    default public ModifierKeyCode setKeyCodeAndModifier(InputConstants.Key keyCode, Modifier modifier) {
        this.setKeyCode(keyCode);
        this.setModifier(modifier);
        return this;
    }

    default public ModifierKeyCode clearModifier() {
        return this.setModifier(Modifier.none());
    }

    public String toString();

    public Component getLocalizedName();

    default public boolean isUnknown() {
        return this.getKeyCode().equals((Object)InputConstants.UNKNOWN);
    }
}

