/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.impl.builders;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.entries.IntegerListEntry;
import me.shedaniel.clothconfig2.impl.builders.AbstractRangeFieldBuilder;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class IntFieldBuilder
extends AbstractRangeFieldBuilder<Integer, IntegerListEntry, IntFieldBuilder> {
    public IntFieldBuilder(Component resetButtonKey, Component fieldNameKey, int value) {
        super(resetButtonKey, fieldNameKey);
        this.value = value;
    }

    @Override
    public IntFieldBuilder requireRestart() {
        return (IntFieldBuilder)super.requireRestart();
    }

    @Override
    public IntFieldBuilder setErrorSupplier(Function<Integer, Optional<Component>> errorSupplier) {
        return (IntFieldBuilder)super.setErrorSupplier(errorSupplier);
    }

    @Override
    public IntFieldBuilder setSaveConsumer(Consumer<Integer> saveConsumer) {
        return (IntFieldBuilder)super.setSaveConsumer(saveConsumer);
    }

    @Override
    public IntFieldBuilder setDefaultValue(Supplier<Integer> defaultValue) {
        return (IntFieldBuilder)super.setDefaultValue(defaultValue);
    }

    @Override
    public IntFieldBuilder setDefaultValue(int defaultValue) {
        return (IntFieldBuilder)super.setDefaultValue(defaultValue);
    }

    @Override
    public IntFieldBuilder setTooltipSupplier(Function<Integer, Optional<Component[]>> tooltipSupplier) {
        return (IntFieldBuilder)super.setTooltipSupplier(tooltipSupplier);
    }

    @Override
    public IntFieldBuilder setTooltipSupplier(Supplier<Optional<Component[]>> tooltipSupplier) {
        return (IntFieldBuilder)super.setTooltipSupplier(tooltipSupplier);
    }

    @Override
    public IntFieldBuilder setTooltip(Optional<Component[]> tooltip) {
        return (IntFieldBuilder)super.setTooltip(tooltip);
    }

    @Override
    public IntFieldBuilder setTooltip(Component ... tooltip) {
        return (IntFieldBuilder)super.setTooltip(tooltip);
    }

    @Override
    public IntFieldBuilder setMin(int min) {
        return (IntFieldBuilder)super.setMin(min);
    }

    @Override
    public IntFieldBuilder setMax(int max) {
        return (IntFieldBuilder)super.setMax(max);
    }

    @Override
    public IntFieldBuilder removeMin() {
        return (IntFieldBuilder)super.removeMin();
    }

    @Override
    public IntFieldBuilder removeMax() {
        return (IntFieldBuilder)super.removeMax();
    }

    @Override
    @NotNull
    public IntegerListEntry build() {
        IntegerListEntry entry = new IntegerListEntry(this.getFieldNameKey(), (Integer)this.value, this.getResetButtonKey(), this.defaultValue, this.getSaveConsumer(), null, this.isRequireRestart());
        if (this.min != null) {
            entry.setMinimum((Integer)this.min);
        }
        if (this.max != null) {
            entry.setMaximum((Integer)this.max);
        }
        entry.setTooltipSupplier(() -> this.getTooltipSupplier().apply(entry.getValue()));
        if (this.errorSupplier != null) {
            entry.setErrorSupplier(() -> (Optional)this.errorSupplier.apply(entry.getValue()));
        }
        return this.finishBuilding(entry);
    }
}

