/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.api;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.input.InputQuirks;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class Modifier {
    private final short value;

    private Modifier(short value) {
        this.value = value;
    }

    public static Modifier none() {
        return Modifier.of((short)0);
    }

    public static Modifier of(boolean alt, boolean control, boolean shift) {
        short value = Modifier.setFlag((short)0, (short)1, alt);
        value = Modifier.setFlag(value, (short)2, control);
        value = Modifier.setFlag(value, (short)4, shift);
        return Modifier.of(value);
    }

    public static Modifier of(short value) {
        return new Modifier(value);
    }

    public static Modifier current() {
        boolean altDown;
        Window window = Minecraft.getInstance().getWindow();
        boolean bl = altDown = InputConstants.isKeyDown((Window)window, (int)342) || InputConstants.isKeyDown((Window)window, (int)346);
        boolean controlDown = InputQuirks.REPLACE_CTRL_KEY_WITH_CMD_KEY ? InputConstants.isKeyDown((Window)window, (int)343) || InputConstants.isKeyDown((Window)window, (int)347) : InputConstants.isKeyDown((Window)window, (int)341) || InputConstants.isKeyDown((Window)window, (int)345);
        boolean shiftDown = InputConstants.isKeyDown((Window)window, (int)340) || InputConstants.isKeyDown((Window)window, (int)344);
        return Modifier.of(altDown, controlDown, shiftDown);
    }

    private static short setFlag(short base, short flag, boolean val) {
        return val ? Modifier.setFlag(base, flag) : Modifier.removeFlag(base, flag);
    }

    private static short setFlag(short base, short flag) {
        return (short)(base | flag);
    }

    private static short removeFlag(short base, short flag) {
        return (short)(base & ~flag);
    }

    private static boolean getFlag(short base, short flag) {
        return (base & flag) != 0;
    }

    public boolean matchesCurrent() {
        return this.equals(Modifier.current());
    }

    public short getValue() {
        return this.value;
    }

    public boolean hasAlt() {
        return Modifier.getFlag(this.value, (short)1);
    }

    public boolean hasControl() {
        return Modifier.getFlag(this.value, (short)2);
    }

    public boolean hasShift() {
        return Modifier.getFlag(this.value, (short)4);
    }

    public boolean isEmpty() {
        return this.value == 0;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof Modifier)) {
            return false;
        }
        return this.value == ((Modifier)other).value;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

