/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.BufferBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import me.shedaniel.clothconfig2.api.AbstractConfigEntry;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.Tooltip;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.clothconfig2.api.scroll.ScrollingContainer;
import me.shedaniel.clothconfig2.gui.AbstractConfigScreen;
import me.shedaniel.clothconfig2.gui.AbstractTabbedConfigScreen;
import me.shedaniel.clothconfig2.gui.ClothConfigTabButton;
import me.shedaniel.clothconfig2.gui.entries.EmptyEntry;
import me.shedaniel.clothconfig2.gui.widget.DynamicElementListWidget;
import me.shedaniel.clothconfig2.gui.widget.SearchFieldEntry;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.Identifier;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class ClothConfigScreen
extends AbstractTabbedConfigScreen {
    private final ScrollingContainer tabsScroller = new ScrollingContainer(){

        @Override
        public Rectangle getBounds() {
            return new Rectangle(0, 0, 1, ClothConfigScreen.this.width - 40);
        }

        @Override
        public int getMaxScrollHeight() {
            return (int)ClothConfigScreen.this.getTabsMaximumScrolled();
        }

        @Override
        public void updatePosition(float delta) {
            super.updatePosition(delta);
            this.setScrollTarget(this.clamp(this.scrollTarget(), 0.0));
        }
    };
    public ListWidget<AbstractConfigEntry<AbstractConfigEntry<?>>> listWidget;
    private final LinkedHashMap<Component, List<AbstractConfigEntry<?>>> categorizedEntries = Maps.newLinkedHashMap();
    private final List<Tuple<Component, Integer>> tabs;
    private SearchFieldEntry searchFieldEntry;
    private AbstractWidget buttonLeftTab;
    private AbstractWidget buttonRightTab;
    private Rectangle tabsBounds;
    private Rectangle tabsLeftBounds;
    private Rectangle tabsRightBounds;
    private double tabsMaximumScrolled = -1.0;
    private final List<ClothConfigTabButton> tabButtons = Lists.newArrayList();
    private final Map<String, ConfigCategory> categoryMap;

    @ApiStatus.Internal
    public ClothConfigScreen(Screen parent, Component title, Map<String, ConfigCategory> categoryMap, Identifier backgroundLocation) {
        super(parent, title, backgroundLocation);
        categoryMap.forEach((categoryName, category) -> {
            ArrayList entries = Lists.newArrayList();
            for (Object object : category.getEntries()) {
                AbstractConfigListEntry entry = object instanceof Tuple ? (AbstractConfigListEntry)((Tuple)object).getB() : (AbstractConfigListEntry)object;
                entry.setScreen(this);
                entries.add(entry);
            }
            this.categorizedEntries.put(category.getCategoryKey(), entries);
            if (category.getBackground() != null) {
                this.registerCategoryBackground(category.getCategoryKey().getString(), category.getBackground());
                this.registerCategoryTransparency(category.getCategoryKey().getString(), false);
            }
        });
        this.tabs = this.categorizedEntries.keySet().stream().map(s -> new Tuple(s, (Object)(Minecraft.getInstance().font.width((FormattedText)s) + 8))).collect(Collectors.toList());
        this.categoryMap = categoryMap;
    }

    @Override
    public Component getSelectedCategory() {
        return (Component)this.tabs.get(this.selectedCategoryIndex).getA();
    }

    @Override
    public Map<Component, List<AbstractConfigEntry<?>>> getCategorizedEntries() {
        return this.categorizedEntries;
    }

    protected void init() {
        super.init();
        this.tabButtons.clear();
        this.listWidget = new ListWidget(this, this.minecraft, this.width, this.height, this.isShowingTabs() ? 70 : 30, this.height - 32, this.getBackgroundLocation());
        this.childrenL().add((GuiEventListener)this.listWidget);
        this.listWidget.children().add(new EmptyEntry(5));
        this.searchFieldEntry = new SearchFieldEntry(this, this.listWidget);
        this.listWidget.children().add(this.searchFieldEntry);
        this.listWidget.children().add(new EmptyEntry(5));
        if (this.categorizedEntries.size() > this.selectedCategoryIndex) {
            this.listWidget.children().addAll((List)Lists.newArrayList(this.categorizedEntries.values()).get(this.selectedCategoryIndex));
        }
        int buttonWidths = Math.min(200, (this.width - 50 - 12) / 3);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)(this.isEdited() ? Component.translatable((String)"text.cloth-config.cancel_discard") : Component.translatable((String)"gui.cancel")), widget -> this.quit()).bounds(this.width / 2 - buttonWidths - 3, this.height - 26, buttonWidths, 20).build());
        this.addRenderableWidget((GuiEventListener)new Button(this.width / 2 + 3, this.height - 26, buttonWidths, 20, (Component)Component.empty(), button -> this.saveAll(true), Supplier::get){

            public void renderContents(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
                boolean hasErrors = false;
                for (List entries : Lists.newArrayList(ClothConfigScreen.this.categorizedEntries.values())) {
                    for (AbstractConfigEntry entry : entries) {
                        if (!entry.getConfigError().isPresent()) continue;
                        hasErrors = true;
                        break;
                    }
                    if (!hasErrors) continue;
                    break;
                }
                this.active = ClothConfigScreen.this.isEdited() && !hasErrors;
                this.setMessage((Component)(hasErrors ? Component.translatable((String)"text.cloth-config.error_cannot_save") : Component.translatable((String)"text.cloth-config.save_and_done")));
                this.renderDefaultSprite(graphics);
                this.renderDefaultLabel(graphics.textRendererForWidget((AbstractWidget)this, GuiGraphics.HoveredTextEffects.NONE));
            }
        });
        if (this.isShowingTabs()) {
            this.tabsBounds = new Rectangle(0, 41, this.width, 24);
            this.tabsLeftBounds = new Rectangle(0, 41, 18, 24);
            this.tabsRightBounds = new Rectangle(this.width - 18, 41, 18, 24);
            this.buttonLeftTab = new Button(this, 4, 44, 12, 18, (Component)Component.empty(), button -> this.tabsScroller.scrollTo(0.0, true), Supplier::get){

                public void renderContents(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
                    graphics.blit(RenderPipelines.GUI_TEXTURED, AbstractConfigScreen.CONFIG_TEX, this.getX(), this.getY(), 12.0f, (float)(18 * (!this.isActive() ? 0 : (this.isHoveredOrFocused() ? 2 : 1))), this.width, this.height, 256, 256, ARGB.white((float)this.alpha));
                }
            };
            this.childrenL().add((GuiEventListener)this.buttonLeftTab);
            int j = 0;
            for (Tuple<Component, Integer> tab : this.tabs) {
                this.tabButtons.add(new ClothConfigTabButton(this, j, -100, 43, (Integer)tab.getB(), 20, (Component)tab.getA(), this.categoryMap.get(((Component)tab.getA()).getString()).getDescription()));
                ++j;
            }
            this.childrenL().addAll(this.tabButtons);
            this.buttonRightTab = new Button(this, this.width - 16, 44, 12, 18, (Component)Component.empty(), button -> this.tabsScroller.scrollTo(this.tabsScroller.getMaxScroll(), true), Supplier::get){

                public void renderContents(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
                    graphics.blit(RenderPipelines.GUI_TEXTURED, AbstractConfigScreen.CONFIG_TEX, this.getX(), this.getY(), 0.0f, (float)(18 * (!this.isActive() ? 0 : (this.isHoveredOrFocused() ? 2 : 1))), this.width, this.height, 256, 256, ARGB.white((float)this.alpha));
                }
            };
            this.childrenL().add((GuiEventListener)this.buttonRightTab);
        } else {
            this.tabsLeftBounds = this.tabsRightBounds = new Rectangle();
            this.tabsBounds = this.tabsRightBounds;
        }
        Optional.ofNullable(this.afterInitConsumer).ifPresent(consumer -> consumer.accept(this));
    }

    @Override
    public boolean matchesSearch(Iterator<String> tags) {
        return this.searchFieldEntry.matchesSearch(tags);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double amountX, double amountY) {
        if (this.tabsBounds.contains(mouseX, mouseY) && !this.tabsLeftBounds.contains(mouseX, mouseY) && !this.tabsRightBounds.contains(mouseX, mouseY) && amountY != 0.0) {
            this.tabsScroller.offset(-amountY * 16.0, true);
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, amountX, amountY);
    }

    public double getTabsMaximumScrolled() {
        if (this.tabsMaximumScrolled == -1.0) {
            int[] i = new int[]{0};
            for (Tuple<Component, Integer> pair : this.tabs) {
                i[0] = i[0] + ((Integer)pair.getB() + 2);
            }
            this.tabsMaximumScrolled = i[0];
        }
        return this.tabsMaximumScrolled + 6.0;
    }

    public void resetTabsMaximumScrolled() {
        this.tabsMaximumScrolled = -1.0;
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        if (this.isShowingTabs()) {
            this.tabsScroller.updatePosition(delta * 3.0f);
            int xx = 24 - this.tabsScroller.scrollAmountInt();
            for (ClothConfigTabButton tabButton : this.tabButtons) {
                tabButton.setX(xx);
                xx += tabButton.getWidth() + 2;
            }
            this.buttonLeftTab.active = this.tabsScroller.scrollAmount() > 0.0;
            boolean bl = this.buttonRightTab.active = this.tabsScroller.scrollAmount() < this.getTabsMaximumScrolled() - (double)this.width + 40.0;
        }
        if (!this.isTransparentBackground()) {
            this.renderMenuBackground(graphics);
        } else {
            if (this.minecraft.level == null) {
                this.renderPanorama(graphics, delta);
            }
            this.renderBlurredBackground(graphics);
            this.renderMenuBackground(graphics);
        }
        this.listWidget.render(graphics, mouseX, mouseY, delta);
        graphics.enableScissor(this.listWidget.left, this.listWidget.top, this.listWidget.left + this.listWidget.width, this.listWidget.bottom);
        for (AbstractConfigEntry<AbstractConfigEntry<?>> abstractConfigEntry : this.listWidget.children()) {
            abstractConfigEntry.lateRender(graphics, mouseX, mouseY, delta);
        }
        graphics.disableScissor();
        if (this.isShowingTabs()) {
            graphics.drawCenteredString(this.minecraft.font, this.title, this.width / 2, 18, -1);
            Rectangle onlyInnerTabBounds = new Rectangle(this.tabsBounds.x + 20, this.tabsBounds.y, this.tabsBounds.width - 40, this.tabsBounds.height);
            graphics.enableScissor(onlyInnerTabBounds.x, onlyInnerTabBounds.y, onlyInnerTabBounds.getMaxX(), onlyInnerTabBounds.getMaxY());
            if (this.isTransparentBackground()) {
                graphics.fillGradient(onlyInnerTabBounds.x, onlyInnerTabBounds.y, onlyInnerTabBounds.getMaxX(), onlyInnerTabBounds.getMaxY(), 0x68000000, 0x68000000);
            } else {
                this.overlayBackground(graphics, onlyInnerTabBounds, 32, 32, 32, 255);
            }
            this.tabButtons.forEach(widget -> widget.render(graphics, mouseX, mouseY, delta));
            this.drawTabsShades(graphics, 0, this.isTransparentBackground() ? 120 : 255);
            graphics.disableScissor();
            this.buttonLeftTab.render(graphics, mouseX, mouseY, delta);
            this.buttonRightTab.render(graphics, mouseX, mouseY, delta);
        } else {
            graphics.drawCenteredString(this.minecraft.font, this.title, this.width / 2, 12, -1);
        }
        if (this.isEditable()) {
            ArrayList errors = Lists.newArrayList();
            for (List entries : Lists.newArrayList(this.categorizedEntries.values())) {
                for (AbstractConfigEntry entry : entries) {
                    if (!entry.getConfigError().isPresent()) continue;
                    errors.add(entry.getConfigError().get());
                }
            }
            if (errors.size() > 0) {
                String string = "\u00a7c" + (errors.size() == 1 ? ((Component)errors.get(0)).plainCopy().getString() : I18n.get((String)"text.cloth-config.multi_error", (Object[])new Object[0]));
                if (this.isTransparentBackground()) {
                    int stringWidth = this.minecraft.font.width(string);
                    Objects.requireNonNull(this.minecraft.font);
                    graphics.fillGradient(8, 9, 20 + stringWidth, 14 + 9, 0x68000000, 0x68000000);
                }
                graphics.blit(RenderPipelines.GUI_TEXTURED, CONFIG_TEX, 10, 10, 0.0f, 54.0f, 3, 11, 256, 256);
                graphics.drawString(this.minecraft.font, string, 18, 12, -1);
                if (errors.size() > 1) {
                    int stringWidth = this.minecraft.font.width(string);
                    if (mouseX >= 10 && mouseY >= 10 && mouseX <= 18 + stringWidth) {
                        Objects.requireNonNull(this.minecraft.font);
                        if (mouseY <= 14 + 9) {
                            this.addTooltip(Tooltip.of(new Point(mouseX, mouseY), errors.toArray(new Component[0])));
                        }
                    }
                }
            }
        } else if (!this.isEditable()) {
            String text = "\u00a7c" + I18n.get((String)"text.cloth-config.not_editable", (Object[])new Object[0]);
            if (this.isTransparentBackground()) {
                int n = this.minecraft.font.width(text);
                Objects.requireNonNull(this.minecraft.font);
                graphics.fillGradient(8, 9, 20 + n, 14 + 9, 0x68000000, 0x68000000);
            }
            graphics.blit(RenderPipelines.GUI_TEXTURED, CONFIG_TEX, 10, 10, 0.0f, 54.0f, 3, 11, 256, 256);
            graphics.drawString(this.minecraft.font, text, 18, 12, -1);
        }
        super.render(graphics, mouseX, mouseY, delta);
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
    }

    private void drawTabsShades(GuiGraphics graphics, int lightColor, int darkColor) {
        graphics.blit(RenderPipelines.GUI_TEXTURED, Screen.HEADER_SEPARATOR, this.tabsBounds.getMinX() - 20, this.tabsBounds.getMinY() - 2, 0.0f, 0.0f, this.tabsBounds.getWidth() + 40, 2, 32, 2);
        graphics.blit(RenderPipelines.GUI_TEXTURED, Screen.FOOTER_SEPARATOR, this.tabsBounds.getMinX() - 20, this.tabsBounds.getMaxY(), 0.0f, 0.0f, this.tabsBounds.getWidth() + 40, 2, 32, 2);
    }

    @Override
    public void save() {
        super.save();
    }

    @Override
    public boolean isEditable() {
        return super.isEditable();
    }

    public static class ListWidget<R extends DynamicElementListWidget.ElementEntry<R>>
    extends DynamicElementListWidget<R> {
        private final AbstractConfigScreen screen;
        private final ValueAnimator<Rectangle> currentBounds = ValueAnimator.ofRectangle();
        public UnaryOperator<List<R>> entriesTransformer = UnaryOperator.identity();
        public Rectangle thisTimeTarget;
        public long lastTouch;

        public ListWidget(AbstractConfigScreen screen, Minecraft client, int width, int height, int top, int bottom, Identifier backgroundLocation) {
            super(client, width, height, top, bottom, screen.isTransparentBackground() ? null : backgroundLocation);
            this.setRenderSelection(false);
            this.screen = screen;
        }

        @Override
        public int getItemWidth() {
            return this.width - 80;
        }

        @Override
        protected int getScrollbarPosition() {
            return this.left + this.width - 36;
        }

        @Override
        protected void renderItem(GuiGraphics graphics, R item, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            if (item instanceof AbstractConfigEntry) {
                ((AbstractConfigEntry)item).updateSelected(this.getFocused() == item);
            }
            super.renderItem(graphics, item, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isSelected, delta);
        }

        @Override
        protected void renderList(GuiGraphics graphics, int startX, int startY, int mouseX, int mouseY, float delta) {
            this.thisTimeTarget = null;
            Rectangle hoverBounds = (Rectangle)this.currentBounds.value();
            if (!hoverBounds.isEmpty()) {
                long timePast = System.currentTimeMillis() - this.lastTouch;
                int alpha = timePast <= 200L ? 255 : Mth.ceil((double)(255.0 - (double)(Math.min((float)(timePast - 200L), 500.0f) / 500.0f) * 255.0));
                alpha = alpha * 36 / 255 << 24;
                graphics.fillGradient(hoverBounds.x, hoverBounds.y - (int)this.scroll, hoverBounds.getMaxX(), hoverBounds.getMaxY() - (int)this.scroll, 0xFFFFFF | alpha, 0xFFFFFF | alpha);
            }
            super.renderList(graphics, startX, startY, mouseX, mouseY, delta);
            if (this.thisTimeTarget != null && this.isMouseOver(mouseX, mouseY)) {
                this.lastTouch = System.currentTimeMillis();
            }
            if (this.thisTimeTarget != null && !this.thisTimeTarget.equals(this.currentBounds.target())) {
                this.currentBounds.setTo(this.thisTimeTarget, 100L);
            } else if (!((Rectangle)this.currentBounds.target()).isEmpty()) {
                this.currentBounds.update(delta);
            }
        }

        protected static void fillGradient(Matrix4f matrix, BufferBuilder bufferBuilder, double xStart, double yStart, double xEnd, double yEnd, int i, int j, int k) {
            float f = (float)(j >> 24 & 0xFF) / 255.0f;
            float g = (float)(j >> 16 & 0xFF) / 255.0f;
            float h = (float)(j >> 8 & 0xFF) / 255.0f;
            float l = (float)(j & 0xFF) / 255.0f;
            float m = (float)(k >> 24 & 0xFF) / 255.0f;
            float n = (float)(k >> 16 & 0xFF) / 255.0f;
            float o = (float)(k >> 8 & 0xFF) / 255.0f;
            float p = (float)(k & 0xFF) / 255.0f;
            bufferBuilder.addVertex((Matrix4fc)matrix, (float)xEnd, (float)yStart, (float)i).setColor(g, h, l, f);
            bufferBuilder.addVertex((Matrix4fc)matrix, (float)xStart, (float)yStart, (float)i).setColor(g, h, l, f);
            bufferBuilder.addVertex((Matrix4fc)matrix, (float)xStart, (float)yEnd, (float)i).setColor(n, o, p, m);
            bufferBuilder.addVertex((Matrix4fc)matrix, (float)xEnd, (float)yEnd, (float)i).setColor(n, o, p, m);
        }

        @Override
        public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
            this.updateScrollingState(event.x(), event.y(), event.buttonInfo().button());
            if (!this.isMouseOver(event.x(), event.y())) {
                return false;
            }
            for (DynamicElementListWidget.ElementEntry entry : this.children()) {
                if (!entry.mouseClicked(event, doubleClick)) continue;
                this.setFocused(entry);
                this.setDragging(true);
                return true;
            }
            if (event.button() == 0) {
                this.clickedHeader((int)(event.x() - (double)(this.left + this.width / 2 - this.getItemWidth() / 2)), (int)(event.y() - (double)this.top) + (int)this.getScroll() - 4);
                return true;
            }
            return this.scrolling;
        }

        @Override
        public List<R> children() {
            return (List)this.entriesTransformer.apply(super.children());
        }
    }
}

