/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui;

import java.util.Optional;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.api.Tooltip;
import me.shedaniel.clothconfig2.gui.ClothConfigScreen;
import me.shedaniel.math.Point;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.client.input.MouseButtonInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class ClothConfigTabButton
extends AbstractButton {
    private final int index;
    private final ClothConfigScreen screen;
    @Nullable
    private final Supplier<Optional<FormattedText[]>> descriptionSupplier;

    public ClothConfigTabButton(ClothConfigScreen screen, int index, int int_1, int int_2, int int_3, int int_4, Component string_1, Supplier<Optional<FormattedText[]>> descriptionSupplier) {
        super(int_1, int_2, int_3, int_4, string_1);
        this.index = index;
        this.screen = screen;
        this.descriptionSupplier = descriptionSupplier;
    }

    public ClothConfigTabButton(ClothConfigScreen screen, int index, int int_1, int int_2, int int_3, int int_4, Component string_1) {
        this(screen, index, int_1, int_2, int_3, int_4, string_1, null);
    }

    public void onPress(InputWithModifiers input) {
        if (this.index != -1) {
            this.screen.selectedCategoryIndex = this.index;
        }
        this.screen.init(Minecraft.getInstance(), this.screen.width, this.screen.height);
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        Optional<FormattedText[]> tooltip;
        this.active = this.index != this.screen.selectedCategoryIndex;
        super.renderWidget(graphics, mouseX, mouseY, delta);
        if (this.isMouseOver(mouseX, mouseY) && (tooltip = this.getDescription()).isPresent() && tooltip.get().length > 0) {
            this.screen.addTooltip(Tooltip.of(new Point(mouseX, mouseY), tooltip.get()));
        }
    }

    protected boolean isValidClickButton(MouseButtonInfo mouseButtonInfo) {
        return this.visible && this.active && super.isValidClickButton(mouseButtonInfo);
    }

    public boolean isMouseOver(double double_1, double double_2) {
        return this.visible && double_1 >= (double)this.getX() && double_2 >= (double)this.getY() && double_1 < (double)(this.getX() + this.width) && double_2 < (double)(this.getY() + this.height) && double_1 >= 20.0 && double_1 < (double)(this.screen.width - 20);
    }

    public Optional<FormattedText[]> getDescription() {
        if (this.descriptionSupplier != null) {
            return this.descriptionSupplier.get();
        }
        return Optional.empty();
    }

    public void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }
}

