/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.plugin.utils;

import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0001H\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\r"}, d2={"Ldev/architectury/plugin/utils/GradleSupport;", "", "()V", "getFileProperty", "Lorg/gradle/api/file/RegularFileProperty;", "project", "Lorg/gradle/api/Project;", "getFilePropertyLegacy", "getFilePropertyLegacyFromObject", "object", "getFilePropertyModern", "isGradle8", "", "architectury-plugin"})
public final class GradleSupport {
    @NotNull
    public static final GradleSupport INSTANCE = new GradleSupport();

    private GradleSupport() {
    }

    @NotNull
    public final RegularFileProperty getFileProperty(@NotNull Project project) {
        RegularFileProperty regularFileProperty;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        try {
            regularFileProperty = this.getFilePropertyModern(project);
        }
        catch (Exception var3) {
            RegularFileProperty regularFileProperty2;
            try {
                regularFileProperty2 = this.getFilePropertyLegacy(project);
            }
            catch (Exception var2) {
                throw new RuntimeException("Failed to find file property", var2);
            }
            regularFileProperty = regularFileProperty2;
        }
        return regularFileProperty;
    }

    private final RegularFileProperty getFilePropertyModern(Project project) {
        ObjectFactory objectFactory = project.getObjects();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory, (String)"project.objects");
        return this.getFilePropertyLegacyFromObject(objectFactory);
    }

    private final RegularFileProperty getFilePropertyLegacy(Project project) {
        ProjectLayout projectLayout = project.getLayout();
        Intrinsics.checkNotNullExpressionValue((Object)projectLayout, (String)"project.layout");
        return this.getFilePropertyLegacyFromObject(projectLayout);
    }

    private final RegularFileProperty getFilePropertyLegacyFromObject(Object object) {
        Method method = object.getClass().getDeclaredMethod("fileProperty", new Class[0]);
        method.setAccessible(true);
        Object object2 = method.invoke(object, new Object[0]);
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.gradle.api.file.RegularFileProperty");
        }
        return (RegularFileProperty)object2;
    }

    public final boolean isGradle8(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return GradleVersion.current().getBaseVersion().compareTo(GradleVersion.version((String)"8.0")) >= 0;
    }
}

