/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.plugin.transformers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.architectury.transformer.Transform;
import dev.architectury.transformer.input.FileAccess;
import dev.architectury.transformer.transformers.base.AssetEditTransformer;
import dev.architectury.transformer.transformers.base.edit.TransformerContext;
import dev.architectury.transformer.util.Logger;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\u000e\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0013\u0010\u0015\u001a\u00020\u00042\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0019\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001c"}, d2={"Ldev/architectury/plugin/transformers/AddRefmapName;", "Ldev/architectury/transformer/transformers/base/AssetEditTransformer;", "enabled", "Lkotlin/Function0;", "", "(Lkotlin/jvm/functions/Function0;)V", "getEnabled", "()Lkotlin/jvm/functions/Function0;", "gson", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "getGson", "()Lcom/google/gson/Gson;", "component1", "copy", "doEdit", "", "context", "Ldev/architectury/transformer/transformers/base/edit/TransformerContext;", "output", "Ldev/architectury/transformer/input/FileAccess;", "equals", "other", "", "hashCode", "", "toString", "", "architectury-plugin"})
public final class AddRefmapName
implements AssetEditTransformer {
    @NotNull
    private final Function0<Boolean> enabled;
    private final Gson gson;

    public AddRefmapName(@NotNull Function0<Boolean> enabled) {
        Intrinsics.checkNotNullParameter(enabled, (String)"enabled");
        this.enabled = enabled;
        this.gson = new GsonBuilder().setPrettyPrinting().create();
    }

    public /* synthetic */ AddRefmapName(Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function0 = 1.INSTANCE;
        }
        this((Function0<Boolean>)function0);
    }

    @NotNull
    public final Function0<Boolean> getEnabled() {
        return this.enabled;
    }

    public final Gson getGson() {
        return this.gson;
    }

    public void doEdit(@NotNull TransformerContext context, @NotNull FileAccess output) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        if (!((Boolean)this.enabled.invoke()).booleanValue()) {
            return;
        }
        String string = System.getProperty("architectury.refmap.name");
        if (string == null) {
            return;
        }
        String refmap = string;
        Set mixins = new LinkedHashSet();
        output.handle((arg_0, arg_1) -> AddRefmapName.doEdit$lambda-0(this, mixins, arg_0, arg_1));
        if (!((Collection)mixins).isEmpty()) {
            Logger.debug((String)Intrinsics.stringPlus((String)"Found mixin config(s): ", (Object)String.join((CharSequence)",", mixins)));
        }
        Iterable $this$forEach$iv = mixins;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String path = (String)element$iv;
            boolean bl = false;
            output.modifyFile(path, arg_0 -> AddRefmapName.doEdit$lambda-2$lambda-1(this, refmap, path, arg_0));
        }
    }

    @NotNull
    public final Function0<Boolean> component1() {
        return this.enabled;
    }

    @NotNull
    public final AddRefmapName copy(@NotNull Function0<Boolean> enabled) {
        Intrinsics.checkNotNullParameter(enabled, (String)"enabled");
        return new AddRefmapName(enabled);
    }

    public static /* synthetic */ AddRefmapName copy$default(AddRefmapName addRefmapName, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            function0 = addRefmapName.enabled;
        }
        return addRefmapName.copy(function0);
    }

    @NotNull
    public String toString() {
        return "AddRefmapName(enabled=" + this.enabled + ')';
    }

    public int hashCode() {
        return this.enabled.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AddRefmapName)) {
            return false;
        }
        AddRefmapName addRefmapName = (AddRefmapName)other;
        return Intrinsics.areEqual(this.enabled, addRefmapName.enabled);
    }

    private static final void doEdit$lambda-0(AddRefmapName this$0, Set $mixins, String path, byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$mixins, (String)"$mixins");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
        if (StringsKt.endsWith$default((String)path, (String)".json", (boolean)false, (int)2, null)) {
            String string = Transform.trimLeadingSlash((String)path);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"trimLeadingSlash(path)");
            if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"/", (boolean)false, (int)2, null)) {
                string = Transform.trimLeadingSlash((String)path);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"trimLeadingSlash(path)");
                if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"\\", (boolean)false, (int)2, null)) {
                    Logger.debug((String)("Checking whether " + path + " is a mixin config."));
                    try {
                        InputStream inputStream = new ByteArrayInputStream(bytes);
                        Charset charset = Charsets.UTF_8;
                        JsonObject json = (JsonObject)this$0.gson.fromJson((Reader)new InputStreamReader(inputStream, charset), JsonObject.class);
                        if (json != null) {
                            boolean hasServer;
                            boolean hasMixins = json.has("mixins") && json.get("mixins").isJsonArray();
                            boolean hasClient = json.has("client") && json.get("client").isJsonArray();
                            boolean bl = hasServer = json.has("server") && json.get("server").isJsonArray();
                            if (json.has("package") && (hasMixins || hasClient || hasServer) && (!json.has("refmap") || !json.has("minVersion"))) {
                                $mixins.add(path);
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private static final byte[] doEdit$lambda-2$lambda-1(AddRefmapName this$0, String $refmap, String $path, byte[] it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$refmap, (String)"$refmap");
        Intrinsics.checkNotNullParameter((Object)$path, (String)"$path");
        Object object = new ByteArrayInputStream(it);
        Charset charset = Charsets.UTF_8;
        Object object2 = this$0.gson.fromJson((Reader)new InputStreamReader((InputStream)object, charset), JsonObject.class);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"gson.fromJson<JsonObject\u2026ss.java\n                )");
        JsonObject json = (JsonObject)object2;
        if (!json.has("refmap")) {
            Logger.debug((String)("Injecting " + $refmap + " to " + $path));
            json.addProperty("refmap", $refmap);
        }
        object2 = this$0.gson.toJson((JsonElement)json);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"gson.toJson(json)");
        object = Charsets.UTF_8;
        byte[] byArray = ((String)object2).getBytes((Charset)object);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return byArray;
    }

    public AddRefmapName() {
        this(null, 1, null);
    }
}

