/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.entry;

import com.google.common.collect.Iterators;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.StreamSupport;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.settings.EntryIngredientSetting;
import me.shedaniel.rei.impl.Internals;
import org.jetbrains.annotations.Nullable;

public enum EntryIngredientImpl implements Internals.EntryIngredientProvider
{
    INSTANCE;


    public EntryIngredient empty() {
        return EmptyEntryIngredient.EMPTY;
    }

    public EntryIngredient of(EntryStack<?> stack) {
        return new SingletonEntryIngredient(stack);
    }

    public EntryIngredient of(EntryStack<?> ... stacks) {
        if (stacks.length == 0) {
            return this.empty();
        }
        if (stacks.length == 1) {
            return this.of(stacks[0]);
        }
        return this._of(stacks);
    }

    public EntryIngredient of(Iterable<EntryStack<?>> stacks) {
        if (stacks instanceof EntryIngredient) {
            return (EntryIngredient)stacks;
        }
        if (stacks instanceof Collection) {
            Collection collection = (Collection)stacks;
            int size = collection.size();
            if (size == 0) {
                return this.empty();
            }
            if (size == 1) {
                return this.of(stacks.iterator().next());
            }
            return this._of(collection.toArray(new EntryStack[0]));
        }
        return this._of((EntryStack[])StreamSupport.stream(stacks.spliterator(), false).toArray(EntryStack[]::new));
    }

    private EntryIngredient _of(EntryStack<?> ... stacks) {
        return new ArrayIngredient(stacks);
    }

    public EntryIngredient.Builder builder() {
        return new EntryIngredientBuilder(0);
    }

    public EntryIngredient.Builder builder(int initialCapacity) {
        return new EntryIngredientBuilder(initialCapacity);
    }

    private static class EmptyEntryIngredient
    extends AbstractList<EntryStack<?>>
    implements EntryIngredient,
    RandomAccess {
        private static final EmptyEntryIngredient EMPTY = new EmptyEntryIngredient();

        private EmptyEntryIngredient() {
        }

        @Override
        public Iterator<EntryStack<?>> iterator() {
            return Collections.emptyIterator();
        }

        @Override
        public ListIterator<EntryStack<?>> listIterator() {
            return Collections.emptyListIterator();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean contains(Object obj) {
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return c.isEmpty();
        }

        @Override
        public Object[] toArray() {
            return new Object[0];
        }

        @Override
        public <T> T[] toArray(T[] a) {
            if (a.length > 0) {
                a[0] = null;
            }
            return a;
        }

        @Override
        public EntryStack<?> get(int index) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof List && ((List)o).isEmpty();
        }

        @Override
        public int hashCode() {
            return 1;
        }

        @Override
        public boolean removeIf(Predicate<? super EntryStack<?>> filter) {
            Objects.requireNonNull(filter);
            return false;
        }

        @Override
        public void replaceAll(UnaryOperator<EntryStack<?>> operator) {
            Objects.requireNonNull(operator);
        }

        @Override
        public void sort(Comparator<? super EntryStack<?>> c) {
        }

        @Override
        public void forEach(Consumer<? super EntryStack<?>> action) {
            Objects.requireNonNull(action);
        }

        @Override
        public Spliterator<EntryStack<?>> spliterator() {
            return Spliterators.emptySpliterator();
        }

        public EntryIngredient filter(Predicate<EntryStack<?>> filter) {
            return this;
        }

        public EntryIngredient map(UnaryOperator<EntryStack<?>> transformer) {
            return this;
        }

        @Nullable
        public <T> T getSetting(EntryIngredientSetting<T> setting) {
            return null;
        }

        public <T> EntryIngredient setting(EntryIngredientSetting<T> setting, T value) {
            return this;
        }
    }

    private static class SingletonEntryIngredient
    extends AbstractEntryIngredient
    implements EntryIngredient,
    RandomAccess {
        private EntryStack<?> stack;

        public SingletonEntryIngredient(EntryStack<?> stack) {
            this.stack = stack;
        }

        @Override
        public Iterator<EntryStack<?>> iterator() {
            return Iterators.singletonIterator(this.stack);
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean contains(Object obj) {
            return Objects.equals(obj, this.stack);
        }

        @Override
        public Object[] toArray() {
            return new Object[]{this.stack};
        }

        @Override
        public EntryStack<?> get(int index) {
            if (index != 0) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: 1");
            }
            return this.stack;
        }

        @Override
        public boolean removeIf(Predicate<? super EntryStack<?>> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void replaceAll(UnaryOperator<EntryStack<?>> operator) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void sort(Comparator<? super EntryStack<?>> c) {
        }

        @Override
        public void forEach(Consumer<? super EntryStack<?>> action) {
            action.accept(this.stack);
        }

        @Override
        public Spliterator<EntryStack<?>> spliterator() {
            return SingletonEntryIngredient.singletonSpliterator(this.stack);
        }

        static <T> Spliterator<T> singletonSpliterator(final T element) {
            return new Spliterator<T>(){
                long est = 1L;

                @Override
                public Spliterator<T> trySplit() {
                    return null;
                }

                @Override
                public boolean tryAdvance(Consumer<? super T> consumer) {
                    Objects.requireNonNull(consumer);
                    if (this.est > 0L) {
                        --this.est;
                        consumer.accept(element);
                        return true;
                    }
                    return false;
                }

                @Override
                public void forEachRemaining(Consumer<? super T> consumer) {
                    this.tryAdvance(consumer);
                }

                @Override
                public long estimateSize() {
                    return this.est;
                }

                @Override
                public int characteristics() {
                    int value = element != null ? 256 : 0;
                    return value | 0x40 | 0x4000 | 0x400 | 1 | 0x10;
                }
            };
        }

        public EntryIngredient filter(Predicate<EntryStack<?>> filter) {
            if (filter.test(this.stack)) {
                return this;
            }
            return EmptyEntryIngredient.EMPTY;
        }

        public EntryIngredient map(UnaryOperator<EntryStack<?>> transformer) {
            return new SingletonEntryIngredient((EntryStack)transformer.apply(this.stack));
        }
    }

    private static class ArrayIngredient
    extends AbstractEntryIngredient
    implements EntryIngredient,
    RandomAccess {
        private static final long serialVersionUID = -2764017481108945198L;
        private final EntryStack<?>[] array;

        ArrayIngredient(EntryStack<?>[] array) {
            this.array = Objects.requireNonNull(array);
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public Object[] toArray() {
            return this.toArray(new Object[0]);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            int size = this.size();
            if (a.length < size) {
                return Arrays.copyOf(this.array, size, a.getClass());
            }
            System.arraycopy(this.array, 0, a, 0, size);
            if (a.length > size) {
                a[size] = null;
            }
            return a;
        }

        @Override
        public EntryStack<?> get(int index) {
            return this.array[index];
        }

        @Override
        public EntryStack<?> set(int index, EntryStack<?> element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int indexOf(Object o) {
            EntryStack<?>[] a = this.array;
            if (o == null) {
                for (int i = 0; i < a.length; ++i) {
                    if (a[i] != null) continue;
                    return i;
                }
            } else {
                for (int i = 0; i < a.length; ++i) {
                    if (!o.equals(a[i])) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public boolean contains(Object o) {
            return this.indexOf(o) != -1;
        }

        @Override
        public Spliterator<EntryStack<?>> spliterator() {
            return Spliterators.spliterator(this.array, 1040);
        }

        @Override
        public void forEach(Consumer<? super EntryStack<?>> action) {
            Objects.requireNonNull(action);
            for (EntryStack<?> stack : this.array) {
                action.accept(stack);
            }
        }

        @Override
        public void replaceAll(UnaryOperator<EntryStack<?>> operator) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void sort(Comparator<? super EntryStack<?>> c) {
            throw new UnsupportedOperationException();
        }

        public EntryIngredient filter(Predicate<EntryStack<?>> filter) {
            return EntryIngredient.of((EntryStack[])((EntryStack[])this.stream().filter(filter).toArray(EntryStack[]::new)));
        }

        public EntryIngredient map(UnaryOperator<EntryStack<?>> transformer) {
            EntryStack[] out = new EntryStack[this.array.length];
            for (int i = 0; i < this.array.length; ++i) {
                out[i] = (EntryStack)transformer.apply(this.array[i]);
            }
            return new ArrayIngredient(out);
        }
    }

    private static class EntryIngredientBuilder
    implements EntryIngredient.Builder {
        private EntryStack<?>[] contents;
        private int size = 0;

        public EntryIngredientBuilder(int initialCapacity) {
            this.contents = new EntryStack[initialCapacity];
        }

        private void ensureCapacity(int minCapacity) {
            if (this.contents.length < minCapacity) {
                this.contents = Arrays.copyOf(this.contents, EntryIngredientBuilder.expandedCapacity(this.contents.length, minCapacity));
            }
        }

        static int expandedCapacity(int oldCapacity, int minCapacity) {
            int newCapacity = oldCapacity + (oldCapacity >> 1) + 1;
            if (newCapacity < minCapacity) {
                newCapacity = Integer.highestOneBit(minCapacity - 1) << 1;
            }
            if (newCapacity < 0) {
                newCapacity = Integer.MAX_VALUE;
            }
            return newCapacity;
        }

        public EntryIngredient.Builder add(EntryStack<?> stack) {
            this.ensureCapacity(this.size + 1);
            this.contents[this.size++] = stack;
            return this;
        }

        public EntryIngredient.Builder add(EntryStack<?> ... stacks) {
            this.ensureCapacity(this.size + stacks.length);
            System.arraycopy(stacks, 0, this.contents, this.size, stacks.length);
            this.size += stacks.length;
            return this;
        }

        public EntryIngredient.Builder addAll(Iterable<? extends EntryStack<?>> stacks) {
            if (stacks instanceof Collection) {
                Collection collection = (Collection)stacks;
                this.ensureCapacity(this.size + collection.size());
            }
            for (EntryStack<?> stack : stacks) {
                this.add(stack);
            }
            return this;
        }

        public EntryIngredient build() {
            if (this.contents.length > this.size) {
                return EntryIngredient.of(Arrays.copyOf(this.contents, this.size));
            }
            return EntryIngredient.of(this.contents);
        }
    }

    private static class SettingsHandler {
        private SettingsHandler() {
        }

        private static Map<EntryIngredientSetting<?>, Object> set(Map<EntryIngredientSetting<?>, Object> map, EntryIngredientSetting<?> setting, Object value) {
            if (map == null) {
                map = new Reference2ObjectOpenHashMap();
            }
            map.put(setting, value);
            return map;
        }

        private static <T> T get(Map<EntryIngredientSetting<?>, Object> map, EntryIngredientSetting<T> setting) {
            if (map == null) {
                return null;
            }
            Object o = map.get(setting);
            return (T)(o == null ? null : o);
        }

        private static Map<EntryIngredientSetting<?>, Object> remove(Map<EntryIngredientSetting<?>, Object> map, EntryIngredientSetting<?> setting) {
            if (map == null) {
                return null;
            }
            map.remove(setting);
            if (map.isEmpty()) {
                return null;
            }
            return map;
        }
    }

    private static abstract class AbstractEntryIngredient
    extends AbstractList<EntryStack<?>>
    implements EntryIngredient {
        private Map<EntryIngredientSetting<?>, Object> settings = null;

        private AbstractEntryIngredient() {
        }

        @Nullable
        public <T> T getSetting(EntryIngredientSetting<T> setting) {
            return SettingsHandler.get(this.settings, setting);
        }

        public <T> EntryIngredient setting(EntryIngredientSetting<T> setting, T value) {
            this.settings = value == null ? SettingsHandler.remove(this.settings, setting) : SettingsHandler.set(this.settings, setting, value);
            return this;
        }
    }
}

