/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.registry.screen;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import dev.architectury.event.CompoundEventResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.config.DisplayPanelLocation;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackProvider;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackVisitor;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponentProvider;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponentProviderWidget;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponentVisitor;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponentVisitorWidget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.overlay.ScreenOverlay;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.screen.ClickArea;
import me.shedaniel.rei.api.client.registry.screen.DisplayBoundsProvider;
import me.shedaniel.rei.api.client.registry.screen.ExclusionZones;
import me.shedaniel.rei.api.client.registry.screen.FocusedStackProvider;
import me.shedaniel.rei.api.client.registry.screen.OverlayDecider;
import me.shedaniel.rei.api.client.registry.screen.OverlayRendererProvider;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.client.registry.screen.SimpleClickArea;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.registry.ReloadStage;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.screen.AbstractDisplayViewingScreen;
import me.shedaniel.rei.impl.client.registry.screen.DefaultScreenOverlayRenderer;
import me.shedaniel.rei.impl.client.registry.screen.ExclusionZonesImpl;
import me.shedaniel.rei.impl.common.InternalLogger;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1041;
import net.minecraft.class_1269;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_465;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
@Environment(value=EnvType.CLIENT)
public class ScreenRegistryImpl
implements ScreenRegistry {
    private Multimap<Class<? extends class_437>, ClickArea<?>> clickAreas = HashMultimap.create();
    private List<DraggableComponentProvider<class_437, Object>> draggableProviders = new CopyOnWriteArrayList<DraggableComponentProvider<class_437, Object>>();
    private List<DraggableComponentVisitor<class_437>> draggableVisitors = new CopyOnWriteArrayList<DraggableComponentVisitor<class_437>>();
    private List<FocusedStackProvider> focusedStackProviders = new CopyOnWriteArrayList<FocusedStackProvider>();
    private List<OverlayDecider> deciders = new CopyOnWriteArrayList<OverlayDecider>();
    private Map<Class<?>, List<OverlayDecider>> cache = new HashMap();
    private ExclusionZones exclusionZones = new ExclusionZonesImpl();
    private OverlayRendererProvider lastRendererProvider = null;
    private final ThreadLocal<Class<? extends class_437>> tmpScreen = new ThreadLocal();

    public ReloadStage getStage() {
        return ReloadStage.START;
    }

    public void acceptPlugin(REIClientPlugin plugin) {
        plugin.registerScreens((ScreenRegistry)this);
        plugin.registerExclusionZones(this.exclusionZones());
    }

    public <R extends class_437> List<OverlayDecider> getDeciders(R screen) {
        if (screen == null) {
            return Collections.emptyList();
        }
        Class<?> screenClass = screen.getClass();
        List<OverlayDecider> possibleCached = this.cache.get(screenClass);
        if (possibleCached != null) {
            return possibleCached;
        }
        this.tmpScreen.set(screenClass);
        List deciders = CollectionUtils.filterToList(this.deciders, this::filterResponsible);
        this.cache.put(screenClass, deciders);
        this.tmpScreen.remove();
        return deciders;
    }

    private boolean filterResponsible(OverlayDecider handler) {
        return handler.isHandingScreen(this.tmpScreen.get());
    }

    public List<OverlayDecider> getDeciders() {
        return Collections.unmodifiableList(this.deciders);
    }

    public <T extends class_437> Rectangle getScreenBounds(T screen) {
        for (OverlayDecider decider : this.getDeciders(screen)) {
            Rectangle bounds;
            if (!(decider instanceof DisplayBoundsProvider) || (bounds = ((DisplayBoundsProvider)decider).getScreenBounds(screen)) == null) continue;
            return bounds;
        }
        return new Rectangle();
    }

    public <T extends class_437> Rectangle getOverlayBounds(DisplayPanelLocation location, T screen) {
        class_1041 window = class_310.method_1551().method_22683();
        int scaledWidth = window.method_4486();
        int scaledHeight = window.method_4502();
        Rectangle screenBounds = this.getScreenBounds(screen);
        if (screenBounds.isEmpty()) {
            return new Rectangle();
        }
        if (location == DisplayPanelLocation.LEFT) {
            if (screenBounds.x < 10) {
                return new Rectangle();
            }
            return new Rectangle(2, 0, screenBounds.x - 2, scaledHeight);
        }
        if (scaledWidth - screenBounds.getMaxX() < 10) {
            return new Rectangle();
        }
        return new Rectangle(screenBounds.getMaxX() + 2, 0, scaledWidth - screenBounds.getMaxX() - 4, scaledHeight);
    }

    @Nullable
    public <T extends class_437> EntryStack<?> getFocusedStack(T screen, Point mouse) {
        for (FocusedStackProvider provider : this.focusedStackProviders) {
            CompoundEventResult result = Objects.requireNonNull(provider.provide(screen, mouse));
            if (result.isTrue()) {
                if (result != null && !((EntryStack)result.object()).isEmpty()) {
                    return (EntryStack)result.object();
                }
                return null;
            }
            if (!result.isFalse()) continue;
            return null;
        }
        return null;
    }

    public void registerDecider(OverlayDecider decider) {
        this.deciders.add(decider);
        this.deciders.sort(Comparator.reverseOrder());
        this.cache.clear();
        this.tmpScreen.remove();
        InternalLogger.getInstance().debug("Added overlay decider: %s [%.2f priority]", new Object[]{decider, decider.getPriority()});
    }

    public void registerFocusedStack(FocusedStackProvider provider) {
        this.focusedStackProviders.add(provider);
        this.focusedStackProviders.sort(Comparator.reverseOrder());
        InternalLogger.getInstance().debug("Added focused stack provider: %s [%.2f priority]", new Object[]{provider, provider.getPriority()});
    }

    public <T extends class_437> void registerDraggableStackProvider(DraggableStackProvider<T> provider) {
        this.registerDraggableComponentProvider((DraggableComponentProvider)provider);
    }

    public <T extends class_437> void registerDraggableStackVisitor(DraggableStackVisitor<T> visitor) {
        this.registerDraggableComponentVisitor((DraggableComponentVisitor<T>)visitor);
    }

    public <T extends class_437, A> void registerDraggableComponentProvider(DraggableComponentProvider<T, A> provider) {
        this.draggableProviders.add(provider);
        this.draggableProviders.sort(Comparator.reverseOrder());
        InternalLogger.getInstance().debug("Added draggable component provider: %s [%.2f priority]", new Object[]{provider, provider.getPriority()});
    }

    public <T extends class_437> void registerDraggableComponentVisitor(DraggableComponentVisitor<T> visitor) {
        this.draggableVisitors.add(visitor);
        this.draggableVisitors.sort(Comparator.reverseOrder());
        InternalLogger.getInstance().debug("Added draggable component visitor: %s [%.2f priority]", new Object[]{visitor, visitor.getPriority()});
    }

    public Iterable<DraggableComponentProvider<class_437, Object>> getDraggableComponentProviders() {
        return Collections.unmodifiableList(this.draggableProviders);
    }

    public Iterable<DraggableComponentVisitor<class_437>> getDraggableComponentVisitors() {
        return Collections.unmodifiableList(this.draggableVisitors);
    }

    public ExclusionZones exclusionZones() {
        return this.exclusionZones;
    }

    public <C extends class_1703, T extends class_465<C>> void registerContainerClickArea(SimpleClickArea<T> area, Class<? extends T> screenClass, CategoryIdentifier<?> ... categories) {
        this.registerClickArea(screen -> {
            Rectangle rectangle = area.provide(screen).clone();
            rectangle.translate(screen.field_2776, screen.field_2800);
            return rectangle;
        }, screenClass, categories);
    }

    public <T extends class_437> void registerClickArea(Class<? extends T> screenClass, ClickArea<T> area) {
        this.clickAreas.put(screenClass, area);
        InternalLogger.getInstance().debug("Added click area provider for %s: %s", new Object[]{screenClass.getName(), area});
    }

    public <T extends class_437> List<ClickArea.Result> evaluateClickArea(Class<T> screenClass, ClickArea.ClickAreaContext<T> context) {
        ArrayList<ClickArea.Result> results = new ArrayList<ClickArea.Result>();
        for (ClickArea area : this.clickAreas.get(screenClass)) {
            ClickArea.Result result = area.handle(context);
            if (!result.isSuccessful()) continue;
            results.add(result);
        }
        return results;
    }

    public void startReload() {
        this.clickAreas.clear();
        this.deciders.clear();
        this.cache.clear();
        this.focusedStackProviders.clear();
        this.draggableProviders.clear();
        this.draggableVisitors.clear();
        this.tmpScreen.remove();
        if (this.lastRendererProvider != null) {
            this.lastRendererProvider.onRemoved();
        }
        this.lastRendererProvider = null;
        this.registerDefault();
    }

    public void endReload() {
        if (this.lastRendererProvider != null) {
            this.lastRendererProvider.onRemoved();
        }
        this.lastRendererProvider = null;
        InternalLogger.getInstance().debug("Registered %d overlay deciders and %d exclusion zones", new Object[]{this.deciders.size(), this.exclusionZones.getZonesCount()});
    }

    private void registerDefault() {
        this.exclusionZones = new ExclusionZonesImpl();
        this.registerDecider((OverlayDecider)this.exclusionZones);
        this.registerDecider((OverlayDecider)new DisplayBoundsProvider<class_465<?>>(this){

            public Rectangle getScreenBounds(class_465<?> screen) {
                return new Rectangle(screen.field_2776, screen.field_2800, screen.field_2792, screen.field_2779);
            }

            public <R extends class_437> boolean isHandingScreen(Class<R> screen) {
                return class_465.class.isAssignableFrom(screen);
            }

            public <R extends class_437> class_1269 shouldScreenBeOverlaid(R screen) {
                return screen instanceof class_465 ? class_1269.field_5812 : class_1269.field_5811;
            }

            public double getPriority() {
                return -10.0;
            }
        });
        this.registerDecider((OverlayDecider)new DisplayBoundsProvider<AbstractDisplayViewingScreen>(this){

            public Rectangle getScreenBounds(AbstractDisplayViewingScreen screen) {
                return screen.getBounds();
            }

            public <R extends class_437> boolean isHandingScreen(Class<R> screen) {
                return AbstractDisplayViewingScreen.class.isAssignableFrom(screen);
            }

            public <R extends class_437> class_1269 shouldScreenBeOverlaid(R screen) {
                return class_1269.field_5812;
            }

            public double getPriority() {
                return -10.0;
            }
        });
        this.registerDecider(new OverlayDecider(this){

            public <R extends class_437> boolean isHandingScreen(Class<R> screen) {
                return true;
            }

            public OverlayRendererProvider getRendererProvider() {
                return DefaultScreenOverlayRenderer.INSTANCE;
            }

            public double getPriority() {
                return -20.0;
            }
        });
        this.registerFocusedStack(new FocusedStackProvider(this){

            public CompoundEventResult<EntryStack<?>> provide(class_437 screen, Point mouse) {
                if (screen instanceof class_465) {
                    class_465 containerScreen = (class_465)screen;
                    if (containerScreen.field_2787 != null && !containerScreen.field_2787.method_7677().method_7960()) {
                        return CompoundEventResult.interruptTrue((Object)EntryStacks.of((class_1799)containerScreen.field_2787.method_7677()));
                    }
                }
                return CompoundEventResult.pass();
            }

            public double getPriority() {
                return -10.0;
            }
        });
        this.registerDraggableComponentProvider(DraggableComponentProviderWidget.from(context -> Widgets.walk((Iterable)context.getScreen().method_25396(), DraggableComponentProviderWidget.class::isInstance)));
        this.registerDraggableComponentVisitor(DraggableComponentVisitorWidget.from(context -> Widgets.walk((Iterable)context.getScreen().method_25396(), DraggableComponentVisitorWidget.class::isInstance)));
    }

    public OverlayRendererProvider getLastRendererProvider(class_437 screen) {
        for (OverlayDecider decider : this.getDeciders(screen)) {
            OverlayRendererProvider provider;
            if (!decider.isHandingScreen(screen.getClass()) || (provider = decider.getRendererProvider()) == null) continue;
            return this.applyRendererProvider(provider);
        }
        return this.applyRendererProvider(null);
    }

    private OverlayRendererProvider applyRendererProvider(final OverlayRendererProvider provider) {
        if (provider != this.lastRendererProvider) {
            if (this.lastRendererProvider != null) {
                this.lastRendererProvider.onRemoved();
            }
            this.lastRendererProvider = provider;
            if (this.lastRendererProvider != null) {
                this.lastRendererProvider.onApplied(new OverlayRendererProvider.Sink(){

                    public void render(class_332 graphics, int mouseX, int mouseY, float delta) {
                        if (ScreenRegistryImpl.this.lastRendererProvider == provider) {
                            ScreenOverlayImpl.getInstance().method_25394(graphics, mouseX, mouseY, delta);
                        } else {
                            InternalLogger.getInstance().warn("Renderer provider %s still tries to render after being removed!", new Object[]{provider});
                        }
                    }

                    public void lateRender(class_332 graphics, int mouseX, int mouseY, float delta) {
                        if (ScreenRegistryImpl.this.lastRendererProvider == provider) {
                            ScreenOverlayImpl.getInstance().lateRender(graphics, mouseX, mouseY, delta);
                        } else {
                            InternalLogger.getInstance().warn("Renderer provider %s still tries to render after being removed!", new Object[]{provider});
                        }
                    }

                    public ScreenOverlay getOverlay() {
                        return ScreenOverlayImpl.getInstance();
                    }
                });
            }
        }
        return provider;
    }
}

