/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.performance;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.shedaniel.clothconfig2.gui.widget.DynamicEntryListWidget;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.common.plugins.REIPlugin;
import me.shedaniel.rei.api.common.plugins.REIPluginProvider;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.gui.modules.Menu;
import me.shedaniel.rei.impl.client.gui.modules.entries.ToggleMenuEntry;
import me.shedaniel.rei.impl.client.gui.performance.entry.PerformanceEntryImpl;
import me.shedaniel.rei.impl.client.gui.performance.entry.SubCategoryListEntry;
import me.shedaniel.rei.impl.client.gui.screen.ScreenWithMenu;
import me.shedaniel.rei.impl.client.gui.widget.UpdatedListWidget;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

@Environment(value=EnvType.CLIENT)
public class PerformanceScreen
extends ScreenWithMenu {
    private Runnable onClose;
    private PerformanceEntryListWidget list;
    private SortType sortType = SortType.ORDER;

    public PerformanceScreen(Runnable onClose) {
        super((class_2561)class_2561.method_43471((String)"text.rei.performance"));
        this.onClose = onClose;
    }

    public static class_5481 formatTime(long time, boolean total) {
        TimeUnit unit = PerformanceScreen.chooseUnit(time);
        double value = (double)time / (double)TimeUnit.NANOSECONDS.convert(1L, unit);
        return class_2561.method_43470((String)(String.format(Locale.ROOT, "%.4g", value) + " " + PerformanceScreen.abbreviate(unit))).method_27694(style -> style.method_27703(class_5251.method_27717((int)PerformanceScreen.chooseColor(TimeUnit.MILLISECONDS.convert(time, TimeUnit.NANOSECONDS), total)))).method_30937();
    }

    private static int chooseColor(long time, boolean total) {
        if (time > (long)(total ? 2500 : 1000)) {
            return 0xFF5555;
        }
        if (time > (long)(total ? 700 : 300)) {
            return 16754176;
        }
        if (time > (long)(total ? 200 : 100)) {
            return 16773143;
        }
        return 0x12FF22;
    }

    private static TimeUnit chooseUnit(long nanos) {
        if (TimeUnit.DAYS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.DAYS;
        }
        if (TimeUnit.HOURS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.HOURS;
        }
        if (TimeUnit.MINUTES.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.MINUTES;
        }
        if (TimeUnit.SECONDS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.SECONDS;
        }
        if (TimeUnit.MILLISECONDS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.MILLISECONDS;
        }
        if (TimeUnit.MICROSECONDS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.MICROSECONDS;
        }
        return TimeUnit.NANOSECONDS;
    }

    private static String abbreviate(TimeUnit unit) {
        switch (unit) {
            case NANOSECONDS: {
                return "ns";
            }
            case MICROSECONDS: {
                return "\u03bcs";
            }
            case MILLISECONDS: {
                return "ms";
            }
            case SECONDS: {
                return "s";
            }
            case MINUTES: {
                return "min";
            }
            case HOURS: {
                return "h";
            }
            case DAYS: {
                return "d";
            }
        }
        throw new AssertionError();
    }

    public void method_25426() {
        class_5250 backText = class_2561.method_43470((String)"\u21a9 ").method_10852((class_2561)class_2561.method_43471((String)"gui.back"));
        this.method_37063((class_364)new class_4185(this, 4, 4, class_310.method_1551().field_1772.method_27525((class_5348)backText) + 10, 20, (class_2561)backText, button -> {
            this.onClose.run();
            this.onClose = null;
        }, Supplier::get){});
        class_5250 text = class_2561.method_43471((String)"text.rei.sort");
        Rectangle bounds = new Rectangle(this.field_22789 - 4 - class_310.method_1551().field_1772.method_27525((class_5348)text) - 10, 4, class_310.method_1551().field_1772.method_27525((class_5348)text) + 10, 20);
        this.method_37063((class_364)new class_4185(this, bounds.x, bounds.y, bounds.width, bounds.height, (class_2561)text, button -> this.setMenu(new Menu(bounds, CollectionUtils.map((Object[])SortType.values(), type -> ToggleMenuEntry.of((class_2561)class_2561.method_43469((String)"text.rei.sort.by", (Object[])new Object[]{type.name().toLowerCase(Locale.ROOT)}), () -> false, o -> {
            this.closeMenu();
            this.sortType = type;
            this.method_25423(this.field_22787, this.field_22789, this.field_22790);
        })), false)), Supplier::get){});
        this.list = new PerformanceEntryListWidget(this);
        long[] totalTime = new long[]{0L};
        ArrayList<SubCategoryListEntry> subCategories = new ArrayList<SubCategoryListEntry>();
        RoughlyEnoughItemsCore.PERFORMANCE_LOGGER.getStages().forEach((stage, inner) -> {
            long separateTime;
            ArrayList<PerformanceEntry> entries = new ArrayList<PerformanceEntry>();
            inner.times().forEach((obj, time) -> entries.add(new PerformanceEntryImpl((class_2561)class_2561.method_43470((String)(obj instanceof Pair ? this.getNameOfPlugin(obj) : Objects.toString(obj))), (long)time)));
            Collection<Long> values = inner.times().values();
            Map<Object, Long> map = inner.times();
            synchronized (map) {
                separateTime = values.stream().collect(Collectors.summarizingLong(value -> value)).getSum();
            }
            if (inner.totalNano() - separateTime > 1000000L) {
                entries.add(new PerformanceEntryImpl((class_2561)class_2561.method_43470((String)"Miscellaneous Operations"), inner.totalNano() - separateTime));
            }
            totalTime[0] = totalTime[0] + Math.max(inner.totalNano(), separateTime);
            if (this.sortType == SortType.DURATION) {
                entries.sort(Comparator.comparingLong(value -> value.time).reversed());
            }
            subCategories.add(new SubCategoryListEntry((class_2561)class_2561.method_43470((String)stage), entries, Math.max(inner.totalNano(), separateTime), false));
        });
        if (this.sortType == SortType.DURATION) {
            subCategories.sort(Comparator.comparingLong(SubCategoryListEntry::getTotalTime).reversed());
        }
        subCategories.forEach(this.list::addItem);
        this.list.method_25396().add(0, new PerformanceEntryImpl((class_2561)class_2561.method_43470((String)"Total Load Time"), totalTime[0]));
        this.method_25429((class_364)this.list);
    }

    private String getNameOfPlugin(Object obj) {
        String pluginName;
        Pair pair = (Pair)obj;
        REIPluginProvider provider = (REIPluginProvider)pair.getFirst();
        REIPlugin plugin = (REIPlugin)pair.getSecond();
        Object providerName = provider.getPluginProviderName();
        if (provider.provide().size() >= 1 && !((String)providerName).equals(pluginName = plugin.getPluginProviderName())) {
            providerName = pluginName + " of " + (String)providerName;
        }
        return providerName;
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        super.method_25394(graphics, mouseX, mouseY, delta);
        this.list.method_25394(graphics, mouseX, mouseY, delta);
        graphics.method_35720(this.field_22793, this.field_22785.method_30937(), (int)((float)this.field_22789 / 2.0f - (float)this.field_22793.method_27525((class_5348)this.field_22785) / 2.0f), 12, -1);
    }

    private static enum SortType {
        ORDER,
        DURATION;

    }

    private class PerformanceEntryListWidget
    extends UpdatedListWidget<PerformanceEntry> {
        public PerformanceEntryListWidget(PerformanceScreen performanceScreen) {
            super(performanceScreen.field_22787, performanceScreen.field_22789, performanceScreen.field_22790, 30, performanceScreen.field_22790);
        }

        public int getItemWidth() {
            return this.width;
        }

        public int addItem(PerformanceEntry item) {
            return super.addItem((DynamicEntryListWidget.Entry)item);
        }

        protected int getScrollbarPosition() {
            return this.width - 6;
        }
    }

    public static abstract class PerformanceEntry
    extends UpdatedListWidget.ElementEntry<PerformanceEntry> {
    }
}

