/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigManager;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.gui.config.DisplayPanelLocation;
import me.shedaniel.rei.api.client.gui.config.SearchFieldLocation;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponentProvider;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponentVisitor;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.overlay.OverlayListWidget;
import me.shedaniel.rei.api.client.overlay.ScreenOverlay;
import me.shedaniel.rei.api.client.registry.screen.ClickArea;
import me.shedaniel.rei.api.client.registry.screen.OverlayDecider;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.client.view.ViewSearchBuilder;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.impl.client.REIRuntimeImpl;
import me.shedaniel.rei.impl.client.gui.craftable.CraftableFilter;
import me.shedaniel.rei.impl.client.gui.dragging.CurrentDraggingStack;
import me.shedaniel.rei.impl.client.gui.hints.ImportantWarningsWidget;
import me.shedaniel.rei.impl.client.gui.modules.MenuAccess;
import me.shedaniel.rei.impl.client.gui.modules.MenuHolder;
import me.shedaniel.rei.impl.client.gui.widget.ConfigButtonWidget;
import me.shedaniel.rei.impl.client.gui.widget.CraftableFilterButtonWidget;
import me.shedaniel.rei.impl.client.gui.widget.DefaultDisplayChoosePageWidget;
import me.shedaniel.rei.impl.client.gui.widget.EntryHighlighter;
import me.shedaniel.rei.impl.client.gui.widget.InternalWidgets;
import me.shedaniel.rei.impl.client.gui.widget.LateRenderable;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.EntryListWidget;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.PaginatedEntryListWidget;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.ScrolledEntryListWidget;
import me.shedaniel.rei.impl.client.gui.widget.favorites.FavoritesListWidget;
import me.shedaniel.rei.impl.client.gui.widget.hint.HintsContainerWidget;
import me.shedaniel.rei.impl.client.gui.widget.search.OverlaySearchField;
import me.shedaniel.rei.impl.common.util.RectangleUtils;
import net.minecraft.class_1041;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_1269;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class ScreenOverlayImpl
extends ScreenOverlay {
    private static final List<Tooltip> TOOLTIPS = Lists.newArrayList();
    private static EntryListWidget entryListWidget = null;
    private static FavoritesListWidget favoritesListWidget = null;
    private final List<Widget> widgets = Lists.newLinkedList();
    public boolean shouldReload = false;
    public boolean shouldReloadSearch = false;
    private Rectangle bounds;
    private class_1041 window;
    private Widget configButton;
    private final CurrentDraggingStack draggingStack = new CurrentDraggingStack();
    @Nullable
    public DefaultDisplayChoosePageWidget choosePageWidget;
    private final MenuHolder menuHolder = new MenuHolder();
    private final HintsContainerWidget hintsWidget = new HintsContainerWidget();

    public static EntryListWidget getEntryListWidget() {
        boolean widgetScrolled = ConfigObject.getInstance().isEntryListWidgetScrolled();
        if (entryListWidget != null) {
            if (widgetScrolled && entryListWidget instanceof ScrolledEntryListWidget) {
                return entryListWidget;
            }
            if (!widgetScrolled && entryListWidget instanceof PaginatedEntryListWidget) {
                return entryListWidget;
            }
        }
        entryListWidget = widgetScrolled ? new ScrolledEntryListWidget() : new PaginatedEntryListWidget();
        ScreenOverlayImpl overlay = ScreenOverlayImpl.getInstance();
        Rectangle overlayBounds = overlay.bounds;
        entryListWidget.updateArea(Objects.requireNonNullElse(overlayBounds, new Rectangle()), REIRuntimeImpl.getSearchField() == null ? "" : REIRuntimeImpl.getSearchField().getText());
        entryListWidget.updateEntriesPosition();
        return entryListWidget;
    }

    @Nullable
    public static FavoritesListWidget getFavoritesListWidget() {
        return favoritesListWidget;
    }

    public static ScreenOverlayImpl getInstance() {
        return (ScreenOverlayImpl)((Object)REIRuntime.getInstance().getOverlay().orElseThrow());
    }

    public void tick() {
        if (REIRuntimeImpl.getSearchField() != null) {
            REIRuntimeImpl.getSearchField().tick();
            if (class_310.method_1551().field_1724 != null && !PluginManager.areAnyReloading() && class_310.method_1551().field_1724.field_6012 % 5 == 0) {
                CraftableFilter.INSTANCE.tick();
            }
        }
    }

    public void queueReloadOverlay() {
        this.shouldReload = true;
    }

    public void queueReloadSearch() {
        this.shouldReloadSearch = true;
    }

    public DraggingContext<?> getDraggingContext() {
        return this.draggingStack;
    }

    protected boolean hasSpace() {
        return !this.bounds.isEmpty();
    }

    public void init() {
        this.draggingStack.set(DraggableComponentProvider.from(() -> ((ScreenRegistry)ScreenRegistry.getInstance()).getDraggableComponentProviders()), (DraggableComponentVisitor<class_437>)DraggableComponentVisitor.from(() -> ((ScreenRegistry)ScreenRegistry.getInstance()).getDraggableComponentVisitors()));
        this.shouldReload = false;
        this.shouldReloadSearch = false;
        this.method_25396().clear();
        this.window = class_310.method_1551().method_22683();
        this.bounds = ScreenOverlayImpl.calculateOverlayBounds();
        if (ConfigObject.getInstance().isFavoritesEnabled()) {
            if (favoritesListWidget == null) {
                favoritesListWidget = new FavoritesListWidget();
            }
            ScreenOverlayImpl.favoritesListWidget.favoritePanel.resetRows();
            this.widgets.add((Widget)favoritesListWidget);
        }
        OverlaySearchField searchField = REIRuntimeImpl.getSearchField();
        searchField.getBounds().setBounds(this.getSearchFieldArea());
        this.widgets.add((Widget)searchField);
        EntryListWidget entryListWidget = ScreenOverlayImpl.getEntryListWidget();
        entryListWidget.updateArea(this.bounds, searchField.getText());
        this.widgets.add((Widget)entryListWidget);
        searchField.setResponder(s -> entryListWidget.updateSearch((String)s, false));
        entryListWidget.init(this);
        this.configButton = ConfigButtonWidget.create(this);
        this.widgets.add(this.configButton);
        if (ConfigObject.getInstance().isCraftableFilterEnabled()) {
            this.widgets.add(CraftableFilterButtonWidget.create(this));
        }
        this.widgets.add(this.draggingStack);
        this.widgets.add((Widget)InternalWidgets.wrapLateRenderable((Widget)this.hintsWidget));
        this.hintsWidget.init();
        this.widgets.add((Widget)InternalWidgets.wrapLateRenderable((Widget)new ImportantWarningsWidget()));
    }

    private Rectangle getSearchFieldArea() {
        int widthRemoved = 1;
        if (ConfigObject.getInstance().isCraftableFilterEnabled()) {
            widthRemoved += 22;
        }
        if (ConfigObject.getInstance().isLowerConfigButton()) {
            widthRemoved += 22;
        }
        SearchFieldLocation searchFieldLocation = REIRuntime.getInstance().getContextualSearchFieldLocation();
        return switch (searchFieldLocation) {
            default -> throw new MatchException(null, null);
            case SearchFieldLocation.TOP_SIDE -> this.getTopSideSearchFieldArea(widthRemoved);
            case SearchFieldLocation.BOTTOM_SIDE -> this.getBottomSideSearchFieldArea(widthRemoved);
            case SearchFieldLocation.CENTER -> this.getCenterSearchFieldArea(widthRemoved);
        };
    }

    private Rectangle getTopSideSearchFieldArea(int widthRemoved) {
        return new Rectangle(this.bounds.x + 2, 4, this.bounds.width - 6 - widthRemoved, 18);
    }

    private Rectangle getBottomSideSearchFieldArea(int widthRemoved) {
        return new Rectangle(this.bounds.x + 2, this.window.method_4502() - 22, this.bounds.width - 6 - widthRemoved, 18);
    }

    private Rectangle getCenterSearchFieldArea(int widthRemoved) {
        Rectangle screenBounds = ScreenRegistry.getInstance().getScreenBounds(this.minecraft.field_1755);
        return new Rectangle(screenBounds.x, this.window.method_4502() - 22, screenBounds.width - widthRemoved, 18);
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        if (this.shouldReload || !ScreenOverlayImpl.calculateOverlayBounds().equals((Object)this.bounds)) {
            this.init();
            ScreenOverlayImpl.getEntryListWidget().updateSearch(REIRuntimeImpl.getSearchField().getText(), true);
        } else {
            for (OverlayDecider decider : ScreenRegistry.getInstance().getDeciders(this.minecraft.field_1755)) {
                if (decider == null || !decider.shouldRecalculateArea(ConfigObject.getInstance().getDisplayPanelLocation(), this.bounds)) continue;
                this.init();
                break;
            }
        }
        if (this.shouldReloadSearch || ConfigManager.getInstance().isCraftableOnlyEnabled() && CraftableFilter.INSTANCE.wasDirty()) {
            this.shouldReloadSearch = false;
            ScreenOverlayImpl.getEntryListWidget().updateSearch(REIRuntimeImpl.getSearchField().getText(), true);
        }
        if (OverlaySearchField.isHighlighting) {
            EntryHighlighter.render(graphics);
        }
        if (!this.hasSpace()) {
            return;
        }
        this.renderWidgets(graphics, mouseX, mouseY, delta);
        if (ConfigObject.getInstance().areClickableRecipeArrowsEnabled()) {
            class_437 screen = class_310.method_1551().field_1755;
            ClickArea.ClickAreaContext<class_437> context = this.createClickAreaContext(mouseX, mouseY, screen);
            List clickAreaTooltips = ScreenRegistry.getInstance().getClickAreaTooltips(screen.getClass(), context);
            if (clickAreaTooltips != null && !clickAreaTooltips.isEmpty()) {
                Tooltip.create((Collection)clickAreaTooltips).queue();
            }
        }
    }

    private ClickArea.ClickAreaContext<class_437> createClickAreaContext(final double mouseX, final double mouseY, final class_437 screen) {
        return new ClickArea.ClickAreaContext<class_437>(this){

            public class_437 getScreen() {
                return screen;
            }

            public Point getMousePosition() {
                return new Point(mouseX, mouseY);
            }
        };
    }

    private static Rectangle calculateOverlayBounds() {
        Rectangle bounds = ScreenRegistry.getInstance().getOverlayBounds(ConfigObject.getInstance().getDisplayPanelLocation(), class_310.method_1551().field_1755);
        double hAlign = ConfigObject.getInstance().getDisplayPanelLocation() == DisplayPanelLocation.LEFT ? 1.0 - ConfigObject.getInstance().getHorizontalEntriesBoundariesAlignments() : ConfigObject.getInstance().getHorizontalEntriesBoundariesAlignments();
        int widthReduction = (int)Math.round((double)bounds.width * (1.0 - ConfigObject.getInstance().getHorizontalEntriesBoundariesPercentage()));
        bounds.x += (int)Math.round((double)widthReduction * hAlign);
        bounds.width -= widthReduction;
        int maxWidth = (int)Math.ceil((double)EntryListWidget.entrySize() * ConfigObject.getInstance().getHorizontalEntriesBoundariesColumns() + (double)EntryListWidget.entrySize() * 0.75);
        if (bounds.width > maxWidth) {
            bounds.x += (int)Math.round((double)(bounds.width - maxWidth) * hAlign);
            bounds.width = maxWidth;
        }
        return ScreenOverlayImpl.avoidButtons(bounds);
    }

    private static Rectangle avoidButtons(Rectangle bounds) {
        int buttonsHeight = 2;
        if (REIRuntime.getInstance().getContextualSearchFieldLocation() == SearchFieldLocation.TOP_SIDE) {
            buttonsHeight += 24;
        }
        if (!ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            buttonsHeight += 22;
        }
        Rectangle area = REIRuntime.getInstance().calculateEntryListArea(bounds).clone();
        area.height = buttonsHeight;
        return RectangleUtils.excludeZones(bounds, ScreenRegistry.getInstance().exclusionZones().getExclusionZones(class_310.method_1551().field_1755).stream().filter(zone -> zone.intersects(area)));
    }

    public void lateRender(class_332 graphics, int mouseX, int mouseY, float delta) {
        if (REIRuntime.getInstance().isOverlayVisible() && this.hasSpace()) {
            for (Widget widget : this.widgets) {
                if (widget instanceof LateRenderable && widget != this.menuHolder.widget()) {
                    widget.method_25394(graphics, mouseX, mouseY, delta);
                    continue;
                }
                if (!(widget instanceof OverlaySearchField)) continue;
                OverlaySearchField field = (OverlaySearchField)widget;
                field.laterRender(graphics, mouseX, mouseY, delta);
            }
            this.menuHolder.lateRender(graphics, mouseX, mouseY, delta);
            if (this.choosePageWidget != null) {
                graphics.method_25296(0, 0, this.window.method_4486(), this.window.method_4502(), -1072689136, -804253680);
                this.choosePageWidget.method_25394(graphics, mouseX, mouseY, delta);
            }
        }
        if (this.choosePageWidget == null) {
            TOOLTIPS.stream().filter(Objects::nonNull).reduce((tooltip, tooltip2) -> tooltip2).ifPresent(tooltip -> this.renderTooltip(graphics, (Tooltip)tooltip));
        }
        TOOLTIPS.clear();
        if (REIRuntime.getInstance().isOverlayVisible()) {
            this.menuHolder.afterRender();
        }
        graphics.method_73199();
    }

    public void renderTooltip(class_332 graphics, Tooltip tooltip) {
        this.renderTooltipInner(this.minecraft.field_1755, graphics, tooltip, tooltip.getX(), tooltip.getY());
    }

    protected abstract void renderTooltipInner(class_437 var1, class_332 var2, Tooltip var3, int var4, int var5);

    public void addTooltip(@Nullable Tooltip tooltip) {
        if (tooltip != null) {
            TOOLTIPS.add(tooltip);
        }
    }

    public void clearTooltips() {
        TOOLTIPS.clear();
    }

    public void renderWidgets(class_332 graphics, int mouseX, int mouseY, float delta) {
        if (!REIRuntime.getInstance().isOverlayVisible()) {
            return;
        }
        for (Widget widget : this.widgets) {
            if (widget instanceof LateRenderable) continue;
            widget.method_25394(graphics, mouseX, mouseY, delta);
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double amountX, double amountY) {
        if (!REIRuntime.getInstance().isOverlayVisible()) {
            return false;
        }
        if (this.menuHolder.mouseScrolled(mouseX, mouseY, amountX, amountY)) {
            return true;
        }
        if (this.hintsWidget.method_25401(mouseX, mouseY, amountX, amountY)) {
            return true;
        }
        if (this.isInside(mouseX, mouseY) && ScreenOverlayImpl.getEntryListWidget().method_25401(mouseX, mouseY, amountX, amountY)) {
            return true;
        }
        if (this.isNotInExclusionZones(PointHelper.getMouseX(), PointHelper.getMouseY()) && favoritesListWidget != null && favoritesListWidget.method_25401(mouseX, mouseY, amountX, amountY)) {
            return true;
        }
        for (Widget widget : this.widgets) {
            if (widget == ScreenOverlayImpl.getEntryListWidget() || favoritesListWidget != null && widget == favoritesListWidget || widget == this.menuHolder.widget() || widget == this.hintsWidget || !widget.method_25401(mouseX, mouseY, amountX, amountY)) continue;
            return true;
        }
        return false;
    }

    public boolean method_25404(class_11908 event) {
        if (!this.hasSpace()) {
            return false;
        }
        if (REIRuntime.getInstance().isOverlayVisible()) {
            if (event.method_74231() && this.choosePageWidget != null) {
                this.choosePageWidget = null;
                return true;
            }
            if (this.choosePageWidget != null) {
                return this.choosePageWidget.method_25404(event);
            }
            if (REIRuntimeImpl.getSearchField().method_25404(event)) {
                return true;
            }
            for (class_364 class_3642 : this.widgets) {
                if (class_3642 == REIRuntimeImpl.getSearchField() || !class_3642.method_25404(event)) continue;
                return true;
            }
        }
        if (ConfigObject.getInstance().getHideKeybind().matchesKey(event.comp_4795(), event.comp_4796())) {
            REIRuntime.getInstance().toggleOverlayVisible();
            return true;
        }
        EntryStack stack = ScreenRegistry.getInstance().getFocusedStack(class_310.method_1551().field_1755, PointHelper.ofMouse());
        if (stack != null && !stack.isEmpty()) {
            stack = stack.copy();
            if (ConfigObject.getInstance().getRecipeKeybind().matchesKey(event.comp_4795(), event.comp_4796())) {
                return ViewSearchBuilder.builder().addRecipesFor(stack).open();
            }
            if (ConfigObject.getInstance().getUsageKeybind().matchesKey(event.comp_4795(), event.comp_4796())) {
                return ViewSearchBuilder.builder().addUsagesFor(stack).open();
            }
            if (ConfigObject.getInstance().getFavoriteKeyCode().matchesKey(event.comp_4795(), event.comp_4796())) {
                FavoriteEntry favoriteEntry = FavoriteEntry.fromEntryStack((EntryStack)stack);
                ConfigObject.getInstance().getFavoriteEntries().add(favoriteEntry);
                return true;
            }
        }
        if (!REIRuntime.getInstance().isOverlayVisible()) {
            return false;
        }
        if (ConfigObject.getInstance().getFocusSearchFieldKeybind().matchesKey(event.comp_4795(), event.comp_4796())) {
            REIRuntimeImpl.getSearchField().method_25365(true);
            this.method_25395((class_364)REIRuntimeImpl.getSearchField());
            REIRuntimeImpl.getSearchField().keybindFocusTime = System.currentTimeMillis();
            REIRuntimeImpl.getSearchField().keybindFocusKey = event.comp_4795();
            return true;
        }
        return false;
    }

    public boolean method_16803(class_11908 event) {
        if (!this.hasSpace()) {
            return false;
        }
        if (REIRuntime.getInstance().isOverlayVisible() && this.choosePageWidget == null) {
            if (REIRuntimeImpl.getSearchField().method_16803(event)) {
                return true;
            }
            for (class_364 class_3642 : this.widgets) {
                if (class_3642 == REIRuntimeImpl.getSearchField() || class_3642 != this.method_25399() || !class_3642.method_16803(event)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean method_25400(class_11905 event) {
        if (!REIRuntime.getInstance().isOverlayVisible()) {
            return false;
        }
        if (!this.hasSpace()) {
            return false;
        }
        if (this.choosePageWidget != null) {
            return this.choosePageWidget.method_25400(event);
        }
        if (REIRuntimeImpl.getSearchField().method_25400(event)) {
            return true;
        }
        for (class_364 class_3642 : this.widgets) {
            if (class_3642 == REIRuntimeImpl.getSearchField() || !class_3642.method_25400(event)) continue;
            return true;
        }
        return false;
    }

    public List<Widget> method_25396() {
        return this.widgets;
    }

    public boolean method_25402(class_11909 event, boolean doubleClick) {
        boolean visible = REIRuntime.getInstance().isOverlayVisible();
        if (this.choosePageWidget != null) {
            if (this.choosePageWidget.containsMouse(event.comp_4798(), event.comp_4799())) {
                return this.choosePageWidget.method_25402(event, doubleClick);
            }
            this.choosePageWidget = null;
            this.init();
            return false;
        }
        if (!this.hasSpace()) {
            return false;
        }
        if (visible && this.configButton.method_25402(event, doubleClick)) {
            this.method_25395((class_364)this.configButton);
            if (event.method_74245() == 0) {
                this.method_25398(true);
            }
            return true;
        }
        if (ConfigObject.getInstance().getHideKeybind().matchesMouse(event.method_74245())) {
            REIRuntime.getInstance().toggleOverlayVisible();
            return REIRuntime.getInstance().isOverlayVisible();
        }
        EntryStack stack = ScreenRegistry.getInstance().getFocusedStack(class_310.method_1551().field_1755, PointHelper.ofMouse());
        if (stack != null && !stack.isEmpty()) {
            stack = stack.copy();
            if (ConfigObject.getInstance().getRecipeKeybind().matchesMouse(event.method_74245())) {
                return ViewSearchBuilder.builder().addRecipesFor(stack).open();
            }
            if (ConfigObject.getInstance().getUsageKeybind().matchesMouse(event.method_74245())) {
                return ViewSearchBuilder.builder().addUsagesFor(stack).open();
            }
            if (visible && ConfigObject.getInstance().getFavoriteKeyCode().matchesMouse(event.method_74245())) {
                FavoriteEntry favoriteEntry = FavoriteEntry.fromEntryStack((EntryStack)stack);
                ConfigObject.getInstance().getFavoriteEntries().add(favoriteEntry);
                return true;
            }
        }
        if (visible) {
            Widget menuWidget = this.menuHolder.widget();
            if (menuWidget != null && menuWidget.method_25402(event, doubleClick)) {
                this.method_25395((class_364)menuWidget);
                if (event.method_74245() == 0) {
                    this.method_25398(true);
                }
                REIRuntimeImpl.getSearchField().method_25365(false);
                return true;
            }
            if (this.hintsWidget.method_25402(event, doubleClick)) {
                this.method_25395((class_364)this.hintsWidget);
                if (event.method_74245() == 0) {
                    this.method_25398(true);
                }
                REIRuntimeImpl.getSearchField().method_25365(false);
                return true;
            }
        }
        if (ConfigObject.getInstance().areClickableRecipeArrowsEnabled()) {
            class_437 screen = class_310.method_1551().field_1755;
            ClickArea.ClickAreaContext<class_437> clickAreaContext = this.createClickAreaContext(event.comp_4798(), event.comp_4799(), screen);
            if (ScreenRegistry.getInstance().executeClickArea(screen.getClass(), clickAreaContext)) {
                return true;
            }
        }
        if (!visible) {
            return false;
        }
        for (class_364 class_3642 : this.widgets) {
            if (class_3642 == this.configButton || class_3642 == this.menuHolder.widget() || class_3642 == this.hintsWidget || class_3642 == this.draggingStack || !class_3642.method_25402(event, doubleClick)) continue;
            this.method_25395(class_3642);
            if (event.method_74245() == 0) {
                this.method_25398(true);
            }
            if (!(class_3642 instanceof OverlaySearchField)) {
                REIRuntimeImpl.getSearchField().method_25365(false);
            }
            return true;
        }
        if (this.draggingStack != null) {
            this.draggingStack.method_25402(event, doubleClick);
        }
        if (ConfigObject.getInstance().getFocusSearchFieldKeybind().matchesMouse(event.method_74245())) {
            REIRuntimeImpl.getSearchField().method_25365(true);
            this.method_25395((class_364)REIRuntimeImpl.getSearchField());
            REIRuntimeImpl.getSearchField().keybindFocusTime = -1L;
            REIRuntimeImpl.getSearchField().keybindFocusKey = -1;
            return true;
        }
        return false;
    }

    public boolean method_25403(class_11909 event, double deltaX, double deltaY) {
        if (!REIRuntime.getInstance().isOverlayVisible()) {
            return false;
        }
        if (!this.hasSpace()) {
            return false;
        }
        if (this.choosePageWidget != null) {
            return this.choosePageWidget.method_25403(event, deltaX, deltaY);
        }
        return this.method_25399() != null && this.method_25397() && event.method_74245() == 0 && this.method_25399().method_25403(event, deltaX, deltaY);
    }

    public boolean method_25406(class_11909 event) {
        if (this.draggingStack != null) {
            this.draggingStack.method_25406(event);
        }
        return super.method_25406(event);
    }

    public class_364 method_25399() {
        if (this.choosePageWidget != null) {
            return this.choosePageWidget;
        }
        return super.method_25399();
    }

    public boolean isInside(double mouseX, double mouseY) {
        return this.bounds.contains(mouseX, mouseY) && this.isNotInExclusionZones(mouseX, mouseY);
    }

    public boolean isNotInExclusionZones(double mouseX, double mouseY) {
        for (OverlayDecider decider : ScreenRegistry.getInstance().getDeciders(class_310.method_1551().field_1755)) {
            class_1269 in = decider.isInZone(mouseX, mouseY);
            if (in == class_1269.field_5811) continue;
            return in == class_1269.field_5812;
        }
        return true;
    }

    public boolean isInside(Point point) {
        return this.isInside(point.getX(), point.getY());
    }

    public OverlayListWidget getEntryList() {
        return ScreenOverlayImpl.getEntryListWidget();
    }

    public Optional<OverlayListWidget> getFavoritesList() {
        return Optional.ofNullable(ScreenOverlayImpl.getFavoritesListWidget());
    }

    public MenuAccess menuAccess() {
        return this.menuHolder;
    }

    public HintsContainerWidget getHintsContainer() {
        return this.hintsWidget;
    }
}

