/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.entry;

import com.google.common.base.Suppliers;
import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.client.fluid.ClientFluidStackHooks;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.entry.renderer.EntryRenderer;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntrySerializer;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.comparison.ComparisonContext;
import me.shedaniel.rei.api.common.entry.comparison.FluidComparatorRegistry;
import me.shedaniel.rei.api.common.entry.type.EntryDefinition;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3609;
import net.minecraft.class_3611;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9326;
import org.jetbrains.annotations.Nullable;

public class FluidEntryDefinition
implements EntryDefinition<FluidStack>,
EntrySerializer<FluidStack> {
    private static final String FLUID_AMOUNT = Platform.isForge() ? "tooltip.rei.fluid_amount.forge" : "tooltip.rei.fluid_amount";
    @Environment(value=EnvType.CLIENT)
    private EntryRenderer<FluidStack> renderer;

    public FluidEntryDefinition() {
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> () -> Client.init(this));
    }

    public Class<FluidStack> getValueType() {
        return FluidStack.class;
    }

    public EntryType<FluidStack> getType() {
        return VanillaEntryTypes.FLUID;
    }

    @Environment(value=EnvType.CLIENT)
    public EntryRenderer<FluidStack> getRenderer() {
        return this.renderer;
    }

    @Nullable
    public class_2960 getIdentifier(EntryStack<FluidStack> entry, FluidStack value) {
        return class_7923.field_41173.method_10221((Object)value.getFluid());
    }

    public boolean isEmpty(EntryStack<FluidStack> entry, FluidStack value) {
        return value.isEmpty();
    }

    public FluidStack copy(EntryStack<FluidStack> entry, FluidStack value) {
        return value.copy();
    }

    public FluidStack normalize(EntryStack<FluidStack> entry, FluidStack value) {
        class_3611 fluid = value.getFluid();
        if (fluid instanceof class_3609) {
            class_3609 flowingFluid = (class_3609)fluid;
            fluid = flowingFluid.method_15751();
        }
        return FluidStack.create((class_3611)fluid, (long)FluidStack.bucketAmount(), (class_9326)value.getPatch());
    }

    public FluidStack wildcard(EntryStack<FluidStack> entry, FluidStack value) {
        class_3611 fluid = value.getFluid();
        if (fluid instanceof class_3609) {
            fluid = ((class_3609)fluid).method_15751();
        }
        return FluidStack.create((class_3611)fluid, (long)FluidStack.bucketAmount());
    }

    @Nullable
    public class_1799 cheatsAs(EntryStack<FluidStack> entry, FluidStack value) {
        if (value.isEmpty()) {
            return class_1799.field_8037;
        }
        class_1792 bucket = value.getFluid().method_15774();
        if (bucket == null) {
            return class_1799.field_8037;
        }
        return new class_1799((class_1935)bucket);
    }

    @Nullable
    public FluidStack add(FluidStack o1, FluidStack o2) {
        return o1.copyWithAmount(o1.getAmount() + o2.getAmount());
    }

    public long hash(EntryStack<FluidStack> entry, FluidStack value, ComparisonContext context) {
        int code = 1;
        code = 31 * code + value.getFluid().hashCode();
        code = 31 * code + Long.hashCode(FluidComparatorRegistry.getInstance().hashOf(context, (Object)value));
        return code;
    }

    public boolean equals(FluidStack o1, FluidStack o2, ComparisonContext context) {
        if (o1.getFluid() != o2.getFluid()) {
            return false;
        }
        return FluidComparatorRegistry.getInstance().hashOf(context, (Object)o1) == FluidComparatorRegistry.getInstance().hashOf(context, (Object)o2);
    }

    @Nullable
    public EntrySerializer<FluidStack> getSerializer() {
        return this;
    }

    public boolean acceptsNull() {
        return false;
    }

    public Codec<FluidStack> codec() {
        return FluidStack.CODEC;
    }

    public class_9139<class_9129, FluidStack> streamCodec() {
        return FluidStack.STREAM_CODEC;
    }

    public class_2561 asFormattedText(EntryStack<FluidStack> entry, FluidStack value) {
        return value.getName();
    }

    public Stream<? extends class_6862<?>> getTagsFor(EntryStack<FluidStack> entry, FluidStack value) {
        return value.getFluid().method_40178().method_40228();
    }

    public void fillCrashReport(class_128 report, class_129 category, EntryStack<FluidStack> entry) {
        super.fillCrashReport(report, category, entry);
        FluidStack stack = (FluidStack)entry.getValue();
        category.method_577("Fluid Type", () -> String.valueOf(class_7923.field_41173.method_10221((Object)stack.getFluid())));
        category.method_577("Fluid Amount", () -> String.valueOf(stack.getAmount()));
        category.method_577("Fluid NBT", () -> class_9326.field_49589.encodeStart((DynamicOps)BasicDisplay.registryAccess().method_57093((DynamicOps)class_2509.field_11560), (Object)stack.getPatch()).result().map(class_2520::toString).orElse("Error"));
    }

    @Environment(value=EnvType.CLIENT)
    private static class Client {
        private Client() {
        }

        private static void init(FluidEntryDefinition definition) {
            definition.renderer = new FluidEntryRenderer();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class FluidEntryRenderer
    implements EntryRenderer<FluidStack> {
        private static final Supplier<class_1058> MISSING_SPRITE = Suppliers.memoize(() -> null);

        private class_1058 missingTexture() {
            return MISSING_SPRITE.get();
        }

        public void render(EntryStack<FluidStack> entry, class_332 graphics, Rectangle bounds, int mouseX, int mouseY, float delta) {
            FluidStack stack = (FluidStack)entry.getValue();
            if (stack.isEmpty()) {
                return;
            }
            class_1058 sprite = ClientFluidStackHooks.getStillTexture((FluidStack)stack);
            if (sprite == null) {
                return;
            }
            int color = ClientFluidStackHooks.getColor((FluidStack)stack);
        }

        @Nullable
        public Tooltip getTooltip(EntryStack<FluidStack> entry, TooltipContext context) {
            String amountTooltip;
            if (entry.isEmpty()) {
                return null;
            }
            ArrayList toolTip = Lists.newArrayList((Object[])new class_2561[]{entry.asFormattedText(context)});
            long amount = ((FluidStack)entry.getValue()).getAmount();
            if (amount >= 0L && ((Boolean)entry.get(EntryStack.Settings.FLUID_AMOUNT_VISIBLE)).booleanValue() && (amountTooltip = class_1074.method_4662((String)FLUID_AMOUNT, (Object[])new Object[]{((FluidStack)entry.getValue()).getAmount()})) != null) {
                toolTip.addAll(Stream.of(amountTooltip.split("\n")).map(class_2561::method_43470).collect(Collectors.toList()));
            }
            if (class_310.method_1551().field_1690.field_1827) {
                class_2960 fluidId = class_7923.field_41173.method_10221((Object)((FluidStack)entry.getValue()).getFluid());
                toolTip.add(class_2561.method_43470((String)fluidId.toString()).method_27692(class_124.field_1063));
            }
            return Tooltip.create((Collection)toolTip);
        }
    }
}

