/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.fluid;

import com.google.common.collect.ForwardingList;
import com.google.common.collect.Lists;
import dev.architectury.event.CompoundEventResult;
import dev.architectury.fluid.FluidStack;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.fluid.FluidSupportProvider;
import me.shedaniel.rei.api.common.plugins.REICommonPlugin;
import me.shedaniel.rei.api.common.registry.ReloadStage;
import net.minecraft.class_1799;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class FluidSupportProviderImpl
extends ForwardingList<FluidSupportProvider.Provider>
implements FluidSupportProvider {
    private final List<FluidSupportProvider.Provider> providers = Lists.newCopyOnWriteArrayList();
    private final List<FluidSupportProvider.Provider> immutable = Collections.unmodifiableList(this.providers);

    public ReloadStage getStage() {
        return ReloadStage.START;
    }

    public void acceptPlugin(REICommonPlugin plugin) {
        plugin.registerFluidSupport((FluidSupportProvider)this);
    }

    public void startReload() {
        this.providers.clear();
    }

    public void register(FluidSupportProvider.Provider provider) {
        this.providers.add(Objects.requireNonNull(provider, "Registered provider is null!"));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public Optional<Stream<EntryStack<FluidStack>>> itemToFluids(EntryStack<? extends class_1799> stack) {
        if (stack.isEmpty()) {
            return Optional.empty();
        }
        for (FluidSupportProvider.Provider provider : this.providers) {
            @Nullable CompoundEventResult resultHolder = Objects.requireNonNull(provider.itemToFluid(stack));
            if (!resultHolder.interruptsFurtherEvaluation()) continue;
            if (resultHolder.isTrue()) {
                return Optional.of((Stream)resultHolder.object());
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    protected List<FluidSupportProvider.Provider> delegate() {
        return this.immutable;
    }
}

