/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.entry;

import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMaps;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.Iterator;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.ClientHelper;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.settings.EntrySettingsAdapterRegistry;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.api.common.util.FormattingUtils;
import me.shedaniel.rei.impl.client.util.CrashReportUtils;
import me.shedaniel.rei.impl.common.entry.TypedEntryStack;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_6862;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class AbstractEntryStack<A>
implements EntryStack<A>,
Renderer {
    private static final Short2ObjectMap<Object> EMPTY_SETTINGS = Short2ObjectMaps.emptyMap();
    private Short2ObjectMap<Object> settings = null;

    public <T> EntryStack<A> setting(EntryStack.Settings<T> settings, T value) {
        short settingsId = settings.getId();
        if (this.settings == null) {
            this.settings = Short2ObjectMaps.singleton((short)settingsId, value);
        } else {
            if (this.settings.size() == 1) {
                if (this.settings.containsKey(settingsId)) {
                    this.settings = Short2ObjectMaps.singleton((short)settingsId, value);
                    return this;
                }
                Short2ObjectMap<Object> singletonSettings = this.settings;
                this.settings = new Short2ObjectOpenHashMap(2);
                this.settings.putAll(singletonSettings);
            }
            this.settings.put(settingsId, value);
        }
        return this;
    }

    public <T> EntryStack<A> removeSetting(EntryStack.Settings<T> settings) {
        if (this.settings != null) {
            short settingsId = settings.getId();
            if (this.settings.size() == 1) {
                if (this.settings.containsKey(settingsId)) {
                    this.settings = null;
                }
            } else if (this.settings.remove(settingsId) != null && this.settings.isEmpty()) {
                this.settings = null;
            }
        }
        return this;
    }

    public EntryStack<A> clearSettings() {
        this.settings = null;
        return this;
    }

    protected Short2ObjectMap<Object> getSettings() {
        return this.settings == null ? EMPTY_SETTINGS : this.settings;
    }

    @Nullable
    public class_2960 getIdentifier() {
        return this.getDefinition().getIdentifier((EntryStack)this, this.getValue());
    }

    @Nullable
    public String getContainingNamespace() {
        return (String)((BiFunction)this.get(EntryStack.Settings.CONTAINING_NS)).apply(this, this.getDefinition().getContainingNamespace((EntryStack)this, this.getValue()));
    }

    public boolean isEmpty() {
        return this.getDefinition().isEmpty((EntryStack)this, this.getValue());
    }

    public EntryStack<A> copy() {
        return this.wrap(this.getDefinition().copy((EntryStack)this, this.getValue()), true);
    }

    public EntryStack<A> rewrap() {
        return this.wrap(this.getValue(), true);
    }

    public EntryStack<A> normalize() {
        return this.wrap(this.getDefinition().normalize((EntryStack)this, this.getValue()), false);
    }

    public EntryStack<A> wildcard() {
        return this.wrap(this.getDefinition().wildcard((EntryStack)this, this.getValue()), false);
    }

    public EntryStack<class_1799> cheatsAs() {
        class_1799 stack = this.getDefinition().cheatsAs((EntryStack)this, this.getValue());
        if (stack == null) {
            return EntryStacks.of((class_1799)class_1799.field_8037);
        }
        return EntryStacks.of((class_1799)stack);
    }

    protected EntryStack<A> wrap(A value, boolean copySettings) {
        TypedEntryStack<A> stack = new TypedEntryStack<A>(this.getDefinition(), value);
        if (copySettings) {
            for (Short2ObjectMap.Entry entry : this.getSettings().short2ObjectEntrySet()) {
                stack.setting(EntryStack.Settings.getById((short)entry.getShortKey()), entry.getValue());
            }
        }
        return stack;
    }

    public <T> T get(EntryStack.Settings<T> settings) {
        Object o = this.getNullable(settings);
        if (o == null) {
            o = settings.getDefaultValue();
        }
        return o;
    }

    @Nullable
    public <T> T getNullable(EntryStack.Settings<T> settings) {
        Object o = this.settings == null ? null : this.settings.get(settings.getId());
        o = EntrySettingsAdapterRegistry.getInstance().adapt((EntryStack)this, settings, o);
        return (T)o;
    }

    public void render(class_332 graphics, Rectangle bounds, int mouseX, int mouseY, float delta) {
        try {
            this.getRenderer().render((EntryStack)this, graphics, bounds, mouseX, mouseY, delta);
        }
        catch (Throwable throwable) {
            class_128 report = CrashReportUtils.essential(throwable, "Rendering entry");
            CrashReportUtils.renderer(report, this);
            throw CrashReportUtils.throwReport(report);
        }
    }

    @Nullable
    public Tooltip getTooltip(TooltipContext context, boolean appendModName) {
        try {
            MutableObject tooltip = new MutableObject((Object)this.getRenderer().cast().getTooltip((EntryStack)this, context));
            if (tooltip.getValue() == null) {
                return null;
            }
            ((Tooltip)tooltip.getValue()).withContextStack((EntryStack)this);
            ((Tooltip)tooltip.getValue()).addAllTexts((Iterable)((Function)this.get(EntryStack.Settings.TOOLTIP_APPEND_EXTRA)).apply(this));
            tooltip.setValue((Object)((Tooltip)((BiFunction)this.get(EntryStack.Settings.TOOLTIP_PROCESSOR)).apply(this, (Tooltip)tooltip.getValue())));
            if (tooltip.getValue() == null) {
                return null;
            }
            String containingNs = this.getContainingNamespace();
            if (appendModName) {
                if (containingNs != null) {
                    ClientHelper.getInstance().appendModIdToTooltips((Tooltip)tooltip.getValue(), containingNs);
                }
            } else if (containingNs != null) {
                String modName = ClientHelper.getInstance().getModFromModId(containingNs);
                Iterator iterator = ((Tooltip)tooltip.getValue()).entries().iterator();
                while (iterator.hasNext()) {
                    Tooltip.Entry s = (Tooltip.Entry)iterator.next();
                    if (!s.isText() || !FormattingUtils.stripFormatting((String)s.getAsText().getString()).equalsIgnoreCase(modName)) continue;
                    iterator.remove();
                }
            }
            return (Tooltip)tooltip.getValue();
        }
        catch (Throwable throwable) {
            if (context.isSearch()) {
                throw throwable;
            }
            class_128 report = CrashReportUtils.essential(throwable, "Getting tooltips");
            CrashReportUtils.renderer(report, this);
            throw CrashReportUtils.throwReport(report);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractEntryStack)) {
            return false;
        }
        AbstractEntryStack that = (AbstractEntryStack)o;
        return EntryStacks.equalsExact((EntryStack)this, (EntryStack)that);
    }

    public int hashCode() {
        return Long.hashCode(EntryStacks.hashExact((EntryStack)this));
    }

    public Stream<class_6862<?>> getTagsFor() {
        return this.getDefinition().getTagsFor((EntryStack)this, this.getValue());
    }

    public class_2561 asFormattedText() {
        return this.getDefinition().asFormattedText((EntryStack)this, this.getValue(), TooltipContext.of((class_1792.class_9635)class_1792.class_9635.field_51353));
    }

    public class_2561 asFormattedText(TooltipContext context) {
        return this.getDefinition().asFormattedText((EntryStack)this, this.getValue(), context);
    }

    public void fillCrashReport(class_128 report, class_129 category) {
        super.fillCrashReport(report, category);
        category.method_577("Entry type", () -> String.valueOf(this.getType().getId()));
        category.method_577("Is empty", () -> String.valueOf(this.isEmpty()));
        category.method_577("Entry identifier", () -> String.valueOf(this.getIdentifier()));
        class_129 rendererCategory = report.method_562("Entry Renderer");
        try {
            this.getDefinition().fillCrashReport(report, rendererCategory, (EntryStack)this);
        }
        catch (Throwable throwable) {
            rendererCategory.method_585("Filling Report", throwable);
        }
    }
}

