/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.search.method;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.search.method.InputMethod;
import me.shedaniel.rei.api.client.search.method.InputMethodRegistry;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.config.ConfigManagerImpl;
import me.shedaniel.rei.impl.client.search.method.DefaultInputMethod;
import me.shedaniel.rei.impl.common.InternalLogger;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;

public class InputMethodRegistryImpl
implements InputMethodRegistry {
    private final Map<class_2960, InputMethod<?>> inputMethods = Maps.newHashMap();

    public void add(class_2960 id, InputMethod<?> inputMethod) {
        this.inputMethods.put(id, inputMethod);
        InternalLogger.getInstance().debug("Added input method [%s]: %s", new Object[]{id, inputMethod.getName().getString()});
    }

    @Nullable
    public InputMethod<?> get(@Nullable class_2960 id) {
        if (id == null) {
            return null;
        }
        return this.inputMethods.get(id);
    }

    public InputMethod<?> getOrDefault(@Nullable class_2960 id) {
        return Objects.requireNonNullElse(this.get(id), DefaultInputMethod.INSTANCE);
    }

    public Map<class_2960, InputMethod<?>> getAll() {
        return Collections.unmodifiableMap(this.inputMethods);
    }

    public void startReload() {
        this.inputMethods.clear();
    }

    public void endReload() {
        InputMethod active = InputMethod.active();
        String languageCode = class_310.method_1551().field_1690.field_1883;
        if (!CollectionUtils.anyMatch((Iterable)active.getMatchingLocales(), locale -> locale.code().equals(languageCode))) {
            InternalLogger.getInstance().error("Reset active input method because the language code {} is not supported by the active input method.", new Object[]{languageCode});
            ConfigManagerImpl.getInstance().getConfig().setInputMethodId(class_2960.method_60654((String)"rei:default"));
            return;
        }
        ExecutorService service = Executors.newSingleThreadExecutor();
        ((CompletableFuture)active.prepare((Executor)service).whenComplete((unused, throwable) -> {
            if (throwable != null) {
                InternalLogger.getInstance().error("Failed to prepare input method", throwable);
                ConfigManagerImpl.getInstance().getConfig().setInputMethodId(class_2960.method_60654((String)"rei:default"));
                ExecutorService service2 = Executors.newSingleThreadExecutor();
                ((CompletableFuture)active.dispose((Executor)service2).whenComplete((unused2, throwable2) -> {
                    if (throwable2 != null) {
                        InternalLogger.getInstance().error("Failed to dispose input method", throwable2);
                    }
                })).join();
                service2.shutdown();
            }
        })).join();
        service.shutdown();
        InternalLogger.getInstance().debug("Registered %d input methods: %s", new Object[]{this.inputMethods.size(), this.inputMethods.values().stream().map(inputMethod -> inputMethod.getName().getString()).collect(Collectors.joining(", "))});
    }

    public void acceptPlugin(REIClientPlugin plugin) {
        plugin.registerInputMethods((InputMethodRegistry)this);
    }
}

