/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.search.argument;

import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import me.shedaniel.rei.api.client.search.method.CharacterUnpackingInputMethod;
import me.shedaniel.rei.impl.client.search.argument.IndexSet;

public class InputMethodMatcher {
    public static boolean contains(CharacterUnpackingInputMethod inputMethod, IntList s1, IntList s2) {
        if (!s1.isEmpty()) {
            for (int i = 0; i < s1.size(); ++i) {
                if (!InputMethodMatcher.check(inputMethod, s1, i, s2, 0, true)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean matches(CharacterUnpackingInputMethod inputMethod, IntList s1, IntList s2) {
        if (s1.isEmpty()) {
            return s2.isEmpty();
        }
        return InputMethodMatcher.check(inputMethod, s1, 0, s2, 0, false);
    }

    private static IndexSet match(CharacterUnpackingInputMethod inputMethod, int self, IntList str, int start, boolean partial) {
        List expendedList = inputMethod.expendSourceChar(self);
        IndexSet ret = (str.getInt(start) == self ? IndexSet.ONE : IndexSet.NONE).copy();
        for (CharacterUnpackingInputMethod.ExpendedChar integers : expendedList) {
            ret.merge(InputMethodMatcher.match(integers, str, start, partial));
        }
        return ret;
    }

    private static IndexSet match(CharacterUnpackingInputMethod.ExpendedChar phonemes, IntList str, int start, boolean partial) {
        IndexSet active = IndexSet.ZERO;
        IndexSet ret = new IndexSet();
        for (IntList phoneme : phonemes.phonemes()) {
            active = InputMethodMatcher.matchPhoneme(List.of(phoneme), str, active, start, partial);
            if (active.isEmpty()) {
                return ret;
            }
            ret.merge(active);
        }
        return ret;
    }

    private static IndexSet matchPhoneme(List<IntList> strs, IntList source, IndexSet idx, int start, boolean partial) {
        if (strs.size() == 1 && strs.get(0).isEmpty()) {
            return new IndexSet(idx);
        }
        IndexSet ret = new IndexSet();
        idx.foreach(i -> {
            IndexSet is = InputMethodMatcher.matchM(strs, source, start + i, partial);
            is.offset(i);
            ret.merge(is);
        });
        return ret;
    }

    public static IndexSet matchM(List<IntList> strs, IntList source, int start, boolean partial) {
        IndexSet ret = new IndexSet();
        if (strs.size() == 1 && strs.get(0).isEmpty()) {
            return ret;
        }
        for (IntList str : strs) {
            int size = InputMethodMatcher.strCmp(source, str, start);
            if (partial && start + size == source.size()) {
                ret.set(size);
                continue;
            }
            if (size != str.size()) continue;
            ret.set(size);
        }
        return ret;
    }

    private static int strCmp(IntList a, IntList b, int aStart) {
        int len = Math.min(a.size() - aStart, b.size());
        for (int i = 0; i < len; ++i) {
            if (a.getInt(i + aStart) == b.getInt(i)) continue;
            return i;
        }
        return len;
    }

    private static boolean check(CharacterUnpackingInputMethod inputMethod, IntList s1, int start1, IntList s2, int start2, boolean partial) {
        if (start2 == s2.size()) {
            return partial || start1 == s1.size();
        }
        int ch = s1.getInt(start1);
        IndexSet s = InputMethodMatcher.match(inputMethod, ch, s2, start2, partial);
        if (start1 == s1.size() - 1) {
            int i2 = s2.size() - start2;
            return s.get(i2);
        }
        return !s.traverse(i -> !InputMethodMatcher.check(inputMethod, s1, start1 + 1, s2, start2 + i, partial));
    }
}

