/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget.favorites.panel.rows;

import java.util.List;
import java.util.function.Predicate;
import me.shedaniel.clothconfig2.api.animator.NumberAnimator;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.math.FloatingPoint;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponent;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.util.ClientEntryStacks;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.gui.widget.DisplayedEntryWidget;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.EntryListWidget;
import me.shedaniel.rei.impl.client.gui.widget.favorites.panel.FavoritesPanel;
import me.shedaniel.rei.impl.client.gui.widget.favorites.panel.rows.FavoritesPanelRow;
import me.shedaniel.rei.impl.client.gui.widget.region.EntryStacksRegionWidget;
import me.shedaniel.rei.impl.client.gui.widget.region.RealRegionEntry;
import me.shedaniel.rei.impl.client.gui.widget.region.RegionDraggableStack;
import net.minecraft.class_11909;
import net.minecraft.class_1792;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import org.jetbrains.annotations.Nullable;

public class FavoritesPanelEntriesRow
extends FavoritesPanelRow {
    private final FavoritesPanel panel;
    private final List<FavoriteEntry> entries;
    private final List<SectionFavoriteWidget> widgets;
    private int blockedCount;
    private int lastY;

    public FavoritesPanelEntriesRow(FavoritesPanel panel, List<FavoriteEntry> entries) {
        this.panel = panel;
        this.entries = entries;
        int entrySize = EntryListWidget.entrySize();
        this.widgets = CollectionUtils.map(this.entries, entry -> new SectionFavoriteWidget(new Point(0, 0), entrySize, (FavoriteEntry)entry));
        for (SectionFavoriteWidget widget2 : this.widgets) {
            widget2.size.setTo(entrySize * 100, ConfigObject.getInstance().isReducedMotion() ? 0L : 300L);
        }
        this.lastY = panel.getInnerBounds().y;
        this.updateEntriesPosition(widget -> false);
    }

    @Override
    public int getRowHeight() {
        return class_3532.method_15386((float)((float)(this.entries.size() + this.blockedCount) / ((float)this.panel.getInnerBounds().width / (float)EntryListWidget.entrySize()))) * EntryListWidget.entrySize();
    }

    @Override
    public void render(class_332 graphics, Rectangle innerBounds, int x, int y, int rowWidth, int rowHeight, int mouseX, int mouseY, float delta) {
        this.lastY = y;
        int entrySize = EntryListWidget.entrySize();
        this.updateEntriesPosition(entry -> !ConfigObject.getInstance().isReducedMotion());
        for (SectionFavoriteWidget widget : this.widgets) {
            widget.update(delta);
            if (widget.getBounds().getMaxY() <= this.lastY || widget.getBounds().getY() > this.lastY + rowHeight || widget.getCurrentEntry().isEmpty()) continue;
            widget.method_25394(graphics, mouseX, mouseY, delta);
        }
    }

    public List<? extends class_364> method_25396() {
        return this.widgets;
    }

    public boolean method_25402(class_11909 event, boolean doubleClick) {
        return super.method_25402(event, doubleClick);
    }

    public boolean method_25403(class_11909 event, double deltaX, double deltaY) {
        return super.method_25403(event, deltaX, deltaY);
    }

    public boolean method_25406(class_11909 event) {
        return super.method_25406(event);
    }

    @Nullable
    public DraggableComponent<?> getHoveredStack(double mouseX, double mouseY) {
        for (SectionFavoriteWidget widget : this.widgets) {
            if (!widget.containsMouse(mouseX, mouseY + this.panel.getScrolledAmount())) continue;
            RealRegionEntry<FavoriteEntry> entry = new RealRegionEntry<FavoriteEntry>(this.panel.getParent().getRegion(), widget.entry.copy(), EntryListWidget.entrySize());
            entry.size.setAs(EntryListWidget.entrySize() * 100);
            return EntryStacksRegionWidget.wrapDraggable(new RegionDraggableStack<FavoriteEntry>(entry, (WidgetWithBounds)widget), entry.region, entry);
        }
        return null;
    }

    @Nullable
    public EntryStack<?> getFocusedStack(Point mouse) {
        for (SectionFavoriteWidget widget : this.widgets) {
            if (!widget.containsMouse(mouse)) continue;
            return ClientEntryStacks.of((Renderer)widget.entry.getRenderer(false)).copy();
        }
        return null;
    }

    public void updateEntriesPosition(Predicate<SectionFavoriteWidget> animated) {
        int entrySize = EntryListWidget.entrySize();
        this.blockedCount = 0;
        int width = this.panel.getInnerBounds().width / entrySize;
        int currentX = 0;
        int currentY = 0;
        boolean slotIndex = false;
        block0: for (SectionFavoriteWidget widget : this.widgets) {
            while (true) {
                int xPos = currentX * entrySize + this.panel.getInnerBounds().x - 1;
                int yPos = currentY * entrySize;
                if (++currentX >= width) {
                    currentX = 0;
                    ++currentY;
                }
                if (EntryListWidget.notSteppingOnExclusionZones(xPos, yPos + this.lastY - this.panel.getScrolledAmountInt(), entrySize, entrySize)) {
                    widget.moveTo(animated.test(widget), xPos, yPos);
                    continue block0;
                }
                ++this.blockedCount;
            }
        }
    }

    private class SectionFavoriteWidget
    extends DisplayedEntryWidget {
        private ValueAnimator<FloatingPoint> pos;
        private NumberAnimator<Double> size;
        private FavoriteEntry entry;

        protected SectionFavoriteWidget(Point point, int entrySize, FavoriteEntry entry) {
            super(point, entrySize);
            this.pos = ValueAnimator.ofFloatingPoint();
            this.size = ValueAnimator.ofDouble();
            this.entry = entry;
            this.entry(ClientEntryStacks.of((Renderer)entry.getRenderer(true)));
            this.noBackground();
        }

        public void moveTo(boolean animated, int xPos, int yPos) {
            this.pos.setTo((Object)new FloatingPoint((double)xPos, (double)yPos), animated ? 200L : -1L);
        }

        public void update(float delta) {
            this.pos.update((double)delta);
            this.size.update((double)delta);
            this.getBounds().width = this.getBounds().height = (int)Math.round(this.size.doubleValue() / 100.0);
            double offsetSize = ((double)EntryListWidget.entrySize() - this.size.doubleValue() / 100.0) / 2.0;
            this.getBounds().x = (int)Math.round(((FloatingPoint)this.pos.value()).x + offsetSize);
            this.getBounds().y = (int)Math.round(((FloatingPoint)this.pos.value()).y + offsetSize) + FavoritesPanelEntriesRow.this.lastY;
        }

        @Override
        @Nullable
        public Tooltip getCurrentTooltip(TooltipContext context) {
            context = TooltipContext.ofMouse((class_1792.class_9635)context.vanillaContext());
            if (!FavoritesPanelEntriesRow.this.panel.getInnerBounds().contains(context.getPoint())) {
                return null;
            }
            Tooltip tooltip = super.getCurrentTooltip(context);
            if (tooltip != null) {
                tooltip.add((class_2561)class_2561.method_43473());
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.rei.drag_to_add_favorites"));
            }
            return tooltip;
        }
    }
}

