/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.runtime;

import com.google.common.base.Stopwatch;
import dev.architectury.event.EventResult;
import it.unimi.dsi.fastutil.objects.Reference2BooleanMap;
import it.unimi.dsi.fastutil.objects.Reference2BooleanMaps;
import it.unimi.dsi.fastutil.objects.Reference2BooleanOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.entry.filtering.FilteringContext;
import me.shedaniel.rei.api.client.entry.filtering.FilteringRule;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.display.visibility.DisplayVisibilityPredicate;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.impl.client.config.ConfigObjectImpl;
import me.shedaniel.rei.impl.client.entry.filtering.FilteringContextImpl;
import me.shedaniel.rei.impl.client.entry.filtering.FilteringContextType;
import me.shedaniel.rei.impl.client.entry.filtering.FilteringResultImpl;
import me.shedaniel.rei.impl.common.InternalLogger;

public class FilteredStacksVisibilityHandler
implements DisplayVisibilityPredicate {
    private boolean checkHiddenStacks;
    private Reference2BooleanMap<Display> visible = Reference2BooleanMaps.synchronize((Reference2BooleanMap)new Reference2BooleanOpenHashMap());
    private List<FilteringRule<?>> filteringRules;
    private Map<FilteringRule<?>, Object> cache = new HashMap();
    private final Predicate<Display> displayPredicate = this::checkHiddenStacks;

    public EventResult handleDisplay(DisplayCategory<?> category, Display display) {
        if (this.checkHiddenStacks) {
            return this.visible.computeIfAbsent((Object)display, this.displayPredicate) ? EventResult.pass() : EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    public void reset() {
        this.checkHiddenStacks = ConfigObject.getInstance().shouldFilterDisplays();
        this.visible = Reference2BooleanMaps.synchronize((Reference2BooleanMap)new Reference2BooleanOpenHashMap());
        if (this.checkHiddenStacks) {
            this.filteringRules = ((ConfigObjectImpl)ConfigObject.getInstance()).getFilteringRules();
            this.cache = new HashMap();
            for (int i = this.filteringRules.size() - 1; i >= 0; --i) {
                FilteringRule<?> rule = this.filteringRules.get(i);
                this.cache.put(rule, rule.prepareCache(false));
            }
            this.cacheExisting();
        } else {
            this.filteringRules = null;
            this.cache = null;
        }
    }

    public void cacheExisting() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        DisplayRegistry.getInstance().getAll().values().parallelStream().map(displays -> {
            Reference2BooleanOpenHashMap current = new Reference2BooleanOpenHashMap();
            for (Display display : displays) {
                current.put((Object)display, this.checkHiddenStacks(display));
            }
            return current;
        }).forEach(map -> this.visible.putAll((Map)map));
        InternalLogger.getInstance().debug("Computed existing filtered displays with %d rules in %s", new Object[]{this.filteringRules.size(), stopwatch.stop()});
    }

    private boolean checkHiddenStacks(Display display) {
        for (EntryIngredient ingredient : display.getInputEntries()) {
            if (ingredient.isEmpty() || !FilteredStacksVisibilityHandler.isEntryIngredientAllHidden(ingredient, this.cache, this.filteringRules)) continue;
            return false;
        }
        for (EntryIngredient ingredient : display.getOutputEntries()) {
            if (ingredient.isEmpty() || !FilteredStacksVisibilityHandler.isEntryIngredientAllHidden(ingredient, this.cache, this.filteringRules)) continue;
            return false;
        }
        return true;
    }

    private static boolean isEntryIngredientAllHidden(EntryIngredient ingredient, Map<FilteringRule<?>, Object> cache, List<FilteringRule<?>> rules) {
        FilteringContextImpl context = new FilteringContextImpl(false, (Collection<EntryStack<?>>)ingredient);
        for (int i = rules.size() - 1; i >= 0; --i) {
            FilteringRule<?> rule = rules.get(i);
            context.handleResult((FilteringResultImpl)rule.processFilteredStacks((FilteringContext)context, () -> new FilteringResultImpl(new ArrayList(), new ArrayList()), cache.get(rule), false));
        }
        return context.stacks.get((Object)FilteringContextType.SHOWN).isEmpty() && context.stacks.get((Object)FilteringContextType.DEFAULT).isEmpty();
    }
}

