/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.display;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.display.DisplaySerializerRegistry;
import me.shedaniel.rei.api.common.plugins.REICommonPlugin;
import me.shedaniel.rei.api.common.registry.ReloadStage;
import me.shedaniel.rei.impl.common.InternalLogger;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class DisplaySerializerRegistryImpl
implements DisplaySerializerRegistry {
    private final BiMap<class_2960, DisplaySerializer<?>> serializers = HashBiMap.create();

    public ReloadStage getStage() {
        return ReloadStage.START;
    }

    public void startReload() {
        this.serializers.clear();
    }

    public <D extends Display> void register(class_2960 id, DisplaySerializer<D> serializer) {
        InternalLogger.getInstance().debug("Added display serializer [%s] %s", new Object[]{id, serializer});
        this.serializers.put((Object)id, serializer);
    }

    @Nullable
    public DisplaySerializer<?> get(class_2960 id) {
        return (DisplaySerializer)this.serializers.get((Object)id);
    }

    @Nullable
    public class_2960 getId(DisplaySerializer<?> serializer) {
        return (class_2960)this.serializers.inverse().get(serializer);
    }

    public boolean isRegistered(DisplaySerializer<?> serializer) {
        return this.serializers.containsValue(serializer);
    }

    public Codec<Display> codec() {
        return this.serializerCodec().dispatch(Display::getSerializer, DisplaySerializer::codec);
    }

    public class_9139<class_9129, Display> streamCodec() {
        return this.serializerStreamCodec().method_56430().method_56440(Display::getSerializer, DisplaySerializer::streamCodec);
    }

    public void acceptPlugin(REICommonPlugin plugin) {
        plugin.registerDisplaySerializer((DisplaySerializerRegistry)this);
    }

    private Codec<DisplaySerializer<?>> serializerCodec() {
        return class_2960.field_25139.flatXmap(id -> Optional.ofNullable(this.get((class_2960)id)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown display serializer id: " + String.valueOf(id))), serializer -> {
            if (this.isRegistered((DisplaySerializer<?>)serializer)) {
                return DataResult.success((Object)this.getId((DisplaySerializer<?>)serializer));
            }
            return DataResult.error(() -> "Unregistered display serializer: " + String.valueOf(serializer));
        });
    }

    private class_9139<ByteBuf, DisplaySerializer<?>> serializerStreamCodec() {
        return new class_9139<ByteBuf, DisplaySerializer<?>>(){

            public DisplaySerializer<?> decode(ByteBuf object) {
                class_2960 id = new class_2540(object).method_10810();
                DisplaySerializer<?> serializer = DisplaySerializerRegistryImpl.this.get(id);
                if (serializer == null) {
                    throw new NullPointerException("Unknown display serializer id: " + String.valueOf(id));
                }
                return serializer;
            }

            public void encode(ByteBuf buf, DisplaySerializer<?> serializer) {
                if (!DisplaySerializerRegistryImpl.this.isRegistered(serializer)) {
                    throw new IllegalArgumentException("Unregistered display serializer: " + String.valueOf(serializer));
                }
                new class_2540(buf).method_10812(DisplaySerializerRegistryImpl.this.getId(serializer));
            }
        };
    }
}

