/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.registry.displays;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import me.shedaniel.rei.api.client.registry.display.reason.DisplayAdditionReason;
import me.shedaniel.rei.api.client.registry.display.reason.DisplayAdditionReasons;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.registry.display.DisplayConsumer;
import me.shedaniel.rei.impl.common.InternalLogger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public interface DisplayConsumerImpl
extends DisplayConsumer {
    public List<DisplayFiller<?>> fillers();

    default public <D extends Display> void registerFillerWithReason(BiPredicate<?, DisplayAdditionReasons> predicate, BiFunction<?, DisplayAdditionReasons, @Nullable D> filler) {
        this.fillers().add(DisplayFiller.of(predicate, filler));
        InternalLogger.getInstance().debug("Added display filter: %s", new Object[]{filler});
    }

    default public <D extends Display> void registerDisplaysFillerWithReason(BiPredicate<?, DisplayAdditionReasons> predicate, BiFunction<?, DisplayAdditionReasons, @Nullable Collection<? extends D>> filler) {
        this.fillers().add(new DisplayFiller(predicate, filler));
        InternalLogger.getInstance().debug("Added display filter: %s", new Object[]{filler});
    }

    default public <T> Collection<Display> tryFillDisplay(T value, DisplayAdditionReason ... reason) {
        if (value instanceof Display) {
            return Collections.singleton((Display)value);
        }
        ArrayList<Display> out = null;
        DisplayAdditionReasons.Impl reasons = reason.length == 0 ? DisplayAdditionReasons.Impl.EMPTY : new DisplayAdditionReasons.Impl(reason);
        for (DisplayFiller<?> filler : this.fillers()) {
            Collection<?> displays = this.tryFillDisplayGenerics(filler, value, (DisplayAdditionReasons)reasons);
            if (displays == null || displays.isEmpty()) continue;
            if (out == null) {
                out = new ArrayList<Display>();
            }
            for (Display display : displays) {
                if (display == null) continue;
                out.add(display);
            }
        }
        if (out != null) {
            return out;
        }
        return Collections.emptyList();
    }

    private <D extends Display> Collection<D> tryFillDisplayGenerics(DisplayFiller<? extends D> filler, Object value, DisplayAdditionReasons reasons) {
        try {
            if (filler.predicate().test(value, reasons)) {
                return filler.mappingFunction().apply(value, reasons);
            }
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to fill displays!", e);
        }
        return null;
    }

    public record DisplayFiller<D extends Display>(BiPredicate<Object, DisplayAdditionReasons> predicate, BiFunction<Object, DisplayAdditionReasons, Collection<? extends D>> mappingFunction) {
        public static <D extends Display> DisplayFiller<D> of(BiPredicate<Object, DisplayAdditionReasons> predicate, Function<Object, D> mappingFunction) {
            return new DisplayFiller<D>(predicate, (o, r) -> Collections.singleton((Display)mappingFunction.apply(o)));
        }

        public static <D extends Display> DisplayFiller<D> of(BiPredicate<Object, DisplayAdditionReasons> predicate, BiFunction<Object, DisplayAdditionReasons, D> mappingFunction) {
            return new DisplayFiller<D>(predicate, (o, r) -> Collections.singleton((Display)mappingFunction.apply(o, (DisplayAdditionReasons)r)));
        }

        public static <D extends Display> DisplayFiller<D> ofMultiple(BiPredicate<Object, DisplayAdditionReasons> predicate, Function<Object, Collection<? extends D>> mappingFunction) {
            return new DisplayFiller<D>(predicate, (o, r) -> (Collection)mappingFunction.apply(o));
        }
    }
}

