/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei;

import com.google.common.collect.ImmutableList;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.platform.Mod;
import dev.architectury.platform.Platform;
import dev.architectury.registry.ReloadListenerRegistry;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import dev.architectury.utils.GameInstance;
import java.util.Comparator;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import me.shedaniel.rei.RoughlyEnoughItemsCoreClient;
import me.shedaniel.rei.RoughlyEnoughItemsNetwork;
import me.shedaniel.rei.api.common.plugins.REICommonPlugin;
import me.shedaniel.rei.api.common.registry.Reloadable;
import me.shedaniel.rei.impl.Internals;
import me.shedaniel.rei.impl.common.InternalLogger;
import me.shedaniel.rei.impl.common.category.CategoryIdentifierImpl;
import me.shedaniel.rei.impl.common.display.DisplaySerializerRegistryImpl;
import me.shedaniel.rei.impl.common.entry.DeferringEntryTypeProviderImpl;
import me.shedaniel.rei.impl.common.entry.EntryIngredientImpl;
import me.shedaniel.rei.impl.common.entry.EntryStackProviderImpl;
import me.shedaniel.rei.impl.common.entry.comparison.FluidComparatorRegistryImpl;
import me.shedaniel.rei.impl.common.entry.comparison.ItemComparatorRegistryImpl;
import me.shedaniel.rei.impl.common.entry.comparison.NbtHasherProviderImpl;
import me.shedaniel.rei.impl.common.entry.settings.EntrySettingsAdapterRegistryImpl;
import me.shedaniel.rei.impl.common.entry.type.EntryTypeRegistryImpl;
import me.shedaniel.rei.impl.common.fluid.FluidSupportProviderImpl;
import me.shedaniel.rei.impl.common.logging.FileLogger;
import me.shedaniel.rei.impl.common.logging.FilteringLogger;
import me.shedaniel.rei.impl.common.logging.Log4JLogger;
import me.shedaniel.rei.impl.common.logging.MultiLogger;
import me.shedaniel.rei.impl.common.logging.TransformingLogger;
import me.shedaniel.rei.impl.common.logging.performance.PerformanceLogger;
import me.shedaniel.rei.impl.common.logging.performance.PerformanceLoggerImpl;
import me.shedaniel.rei.impl.common.plugins.PluginManagerImpl;
import me.shedaniel.rei.impl.common.plugins.ReloadInterruptionContext;
import me.shedaniel.rei.impl.common.plugins.ReloadManagerImpl;
import me.shedaniel.rei.impl.common.registry.displays.ServerDisplayRegistryImpl;
import me.shedaniel.rei.impl.common.transfer.SlotAccessorRegistryImpl;
import me.shedaniel.rei.impl.common.util.InstanceHelper;
import me.shedaniel.rei.impl.init.PlatformAdapter;
import me.shedaniel.rei.impl.init.PluginDetector;
import me.shedaniel.rei.impl.init.PrimitivePlatformAdapter;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3902;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class RoughlyEnoughItemsCore {
    @ApiStatus.Internal
    public static final InternalLogger LOGGER = new TransformingLogger(new MultiLogger((Iterable<InternalLogger>)ImmutableList.of((Object)RoughlyEnoughItemsCore.make(new FileLogger(Platform.getGameFolder().resolve("logs/rei.log")), logger -> {
        PrimitivePlatformAdapter adapter = PrimitivePlatformAdapter.get();
        boolean fabric = Platform.isFabric();
        logger.info("========================================");
        logger.info("Minecraft: " + adapter.getMinecraftVersion());
        logger.info("Side: " + (adapter.isClient() ? "client" : "server"));
        logger.info("Development: " + adapter.isDev());
        logger.info("Version: " + (String)Platform.getOptionalMod((String)"roughlyenoughitems").map(Mod::getVersion).orElse(null));
        logger.info("Loader:");
        logger.info("- " + (fabric ? "Fabric" : "Forge") + ": " + (String)Platform.getOptionalMod((String)(fabric ? "fabricloader" : "forge")).map(Mod::getVersion).orElse(null));
        if (fabric) {
            logger.info("- Fabric API: " + (String)Platform.getOptionalMod((String)"fabric").map(Mod::getVersion).orElse(null));
        }
        logger.info("Dependencies:");
        logger.info("- Cloth Config: " + (String)Platform.getOptionalMod((String)(fabric ? "cloth-config2" : "cloth_config")).map(Mod::getVersion).orElse(null));
        logger.info("- Architectury: " + (String)Platform.getOptionalMod((String)"architectury").map(Mod::getVersion).orElse(null));
        String mixin = "null";
        try {
            mixin = (String)Class.forName("org.spongepowered.asm.launch.MixinBootstrap").getDeclaredField("VERSION").get(null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        logger.info("Mixin: " + mixin);
        logger.info("OS: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " (" + System.getProperty("os.arch") + ")");
        logger.info("Java: " + System.getProperty("java.version") + " (" + System.getProperty("java.vendor") + ")");
        logger.info("========================================");
        logger.info("Mods:");
        for (Mod mod : Platform.getMods().stream().sorted(Comparator.comparing(Mod::getModId)).toList()) {
            logger.info("- " + mod.getModId() + ": " + mod.getVersion());
        }
        logger.info("========================================");
    }), (Object)new FilteringLogger(new FileLogger(Platform.getGameFolder().resolve("logs/rei-issues.log")), Level.WARN), (Object)new Log4JLogger(LogManager.getFormatterLogger((String)"REI")))), message -> "[REI] " + message);
    public static final PerformanceLogger PERFORMANCE_LOGGER = new PerformanceLoggerImpl();
    private static final ServiceLoader<PluginDetector> PLUGIN_DETECTOR_LOADER = ServiceLoader.load(PluginDetector.class);

    private static <T> T make(T object, Consumer<T> consumer) {
        consumer.accept(object);
        return object;
    }

    public static void attachCommonInternals() {
        Internals.attachInstanceSupplier((Object)LOGGER, (String)"logger");
        CategoryIdentifierImpl.attach();
        Internals.attachInstance(ingredient -> PlatformAdapter.get().fromIngredient((class_1856)ingredient), (String)"ingredientToEntryIngredient");
        Internals.attachInstance((Object)DeferringEntryTypeProviderImpl.INSTANCE, (String)"entryTypeDeferred");
        Internals.attachInstance(() -> InstanceHelper.getInstance().registryAccess(), (String)"registryAccess");
        Internals.attachInstance((Object)((Object)EntryStackProviderImpl.INSTANCE), Internals.EntryStackProvider.class);
        Internals.attachInstance((Object)((Object)NbtHasherProviderImpl.INSTANCE), Internals.NbtHasherProvider.class);
        Internals.attachInstance((Object)((Object)EntryIngredientImpl.INSTANCE), Internals.EntryIngredientProvider.class);
        Internals.attachInstanceSupplier(new PluginManagerImpl<REICommonPlugin>(REICommonPlugin.class, new Reloadable[]{new SlotAccessorRegistryImpl(), new EntryTypeRegistryImpl(), new EntrySettingsAdapterRegistryImpl(), new ItemComparatorRegistryImpl(), new FluidComparatorRegistryImpl(), new DisplaySerializerRegistryImpl(), new ServerDisplayRegistryImpl(), new FluidSupportProviderImpl()}), (String)"commonPluginManager");
    }

    public void onInitialize() {
        PluginDetector detector = RoughlyEnoughItemsCore.getPluginDetector();
        detector.detectCommonPlugins();
        RoughlyEnoughItemsNetwork.onInitialize();
        if (Platform.getEnvironment() == Env.SERVER) {
            LifecycleEvent.SERVER_STARTED.register(server -> ReloadManagerImpl.reloadPlugins(null, ReloadInterruptionContext.ofNever()));
            ReloadListenerRegistry.register((class_3264)class_3264.field_14190, (sharedState, executor, preparationBarrier, executor2) -> preparationBarrier.method_18352((Object)class_3902.field_17274).thenRunAsync(() -> {
                if (GameInstance.getServer() == null) {
                    return;
                }
                ReloadManagerImpl.reloadPlugins(null, ReloadInterruptionContext.ofNever());
            }, executor2), (class_2960)class_2960.method_60655((String)"roughlyenoughitems", (String)"reload_plugins"));
        }
    }

    public static PluginDetector getPluginDetector() {
        return PLUGIN_DETECTOR_LOADER.findFirst().orElseThrow();
    }

    static {
        RoughlyEnoughItemsCore.attachCommonInternals();
        if (Platform.getEnvironment() == Env.CLIENT) {
            EnvExecutor.runInEnv((Env)Env.CLIENT, () -> RoughlyEnoughItemsCoreClient::attachClientInternals);
        }
    }
}

