/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.impl.client.gui.config.options;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class OptionCategory {
    private final String key;
    private final class_2960 icon;
    private final class_2561 name;
    private final class_2561 description;
    private final List<OptionGroup> groups = new ArrayList<>();
    
    private OptionCategory(String key, class_2960 icon, class_2561 name, class_2561 description) {
        this.key = key;
        this.icon = icon;
        this.name = name;
        this.description = description;
    }
    
    public static OptionCategory of(String key, class_2960 icon, class_2561 name, class_2561 description) {
        return new OptionCategory(key, icon, name, description);
    }
    
    public OptionCategory add(OptionGroup group) {
        this.groups.add(group);
        return this;
    }
    
    public String getKey() {
        return key;
    }
    
    public class_2960 getIcon() {
        return icon;
    }
    
    public class_2561 getName() {
        return name;
    }
    
    public class_2561 getDescription() {
        return description;
    }
    
    public List<OptionGroup> getGroups() {
        return groups;
    }
    
    public OptionCategory copy() {
        OptionCategory category = new OptionCategory(key, icon, name, description);
        for (OptionGroup group : groups) {
            category.add(group.copy());
        }
        return category;
    }
}
