/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.registry.display;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientTickEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.display.DynamicDisplayGenerator;
import me.shedaniel.rei.api.client.registry.display.reason.DisplayAdditionReason;
import me.shedaniel.rei.api.client.registry.display.visibility.DisplayVisibilityPredicate;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.api.common.registry.ReloadStage;
import me.shedaniel.rei.impl.client.gui.widget.favorites.history.DisplayHistoryManager;
import me.shedaniel.rei.impl.client.registry.display.DisplayCache;
import me.shedaniel.rei.impl.client.registry.display.DisplayCacheImpl;
import me.shedaniel.rei.impl.client.registry.display.DisplayGeneratorsRegistryImpl;
import me.shedaniel.rei.impl.client.registry.display.DisplayValidator;
import me.shedaniel.rei.impl.common.InternalLogger;
import me.shedaniel.rei.impl.common.plugins.ReloadManagerImpl;
import me.shedaniel.rei.impl.common.registry.displays.AbstractDisplayRegistry;
import me.shedaniel.rei.impl.common.registry.displays.DisplayConsumerImpl;
import me.shedaniel.rei.impl.common.registry.displays.DisplaysHolderImpl;
import net.minecraft.class_10297;
import net.minecraft.class_10298;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;

public class DisplayRegistryImpl
extends AbstractDisplayRegistry<REIClientPlugin, ClientDisplaysHolder>
implements DisplayRegistry,
DisplayConsumerImpl,
DisplayGeneratorsRegistryImpl {
    public static final Object SYNCED = new Object();
    private final Map<CategoryIdentifier<?>, List<DynamicDisplayGenerator<?>>> displayGenerators = new ConcurrentHashMap();
    private final List<DynamicDisplayGenerator<?>> globalDisplayGenerators = new ArrayList();
    private final List<DisplayVisibilityPredicate> visibilityPredicates = new ArrayList<DisplayVisibilityPredicate>();
    private final List<Runnable> jobs = new ArrayList<Runnable>();
    private long lastAddWarning = -1L;

    public DisplayRegistryImpl() {
        super(ClientDisplaysHolder::new);
        int[] tick = new int[]{0};
        ClientTickEvent.CLIENT_POST.register(instance -> {
            int n = tick[0];
            tick[0] = n + 1;
            if (n % 20 == 0 && !PluginManager.areAnyReloading() && ReloadManagerImpl.countRunningReloadTasks() == 0 && class_310.method_1551().method_1562() != null) {
                for (Runnable job : this.jobs) {
                    try {
                        job.run();
                    }
                    catch (Throwable throwable) {
                        InternalLogger.getInstance().error("Failed to run job", throwable);
                    }
                }
                this.jobs.clear();
            }
        });
    }

    public void addJob(Runnable job) {
        this.jobs.add(job);
    }

    public void acceptPlugin(REIClientPlugin plugin) {
        plugin.registerDisplays((DisplayRegistry)this);
    }

    @Override
    public boolean add(Display display, @Nullable Object origin) {
        if (!PluginManager.areAnyReloading()) {
            if (this.lastAddWarning < 0L || System.currentTimeMillis() - this.lastAddWarning > 5000L) {
                InternalLogger.getInstance().warn("Detected runtime DisplayRegistry modification, this can be extremely dangerous!");
                InternalLogger.getInstance().debug("Detected runtime DisplayRegistry modification, this can be extremely dangerous!", new Throwable());
            }
            this.lastAddWarning = System.currentTimeMillis();
        }
        return DisplayValidator.validate(display) && super.add(display, origin);
    }

    @Override
    public List<DynamicDisplayGenerator<?>> globalDisplayGenerators() {
        return this.globalDisplayGenerators;
    }

    @Override
    public Map<CategoryIdentifier<?>, List<DynamicDisplayGenerator<?>>> categoryDisplayGenerators() {
        return this.displayGenerators;
    }

    public void registerVisibilityPredicate(DisplayVisibilityPredicate predicate) {
        this.visibilityPredicates.add(predicate);
        this.visibilityPredicates.sort(Comparator.reverseOrder());
        InternalLogger.getInstance().debug("Added display visibility predicate: %s [%.2f priority]", new Object[]{predicate, predicate.getPriority()});
    }

    public boolean isDisplayVisible(Display display) {
        DisplayCategory category = CategoryRegistry.getInstance().get(display.getCategoryIdentifier()).getCategory();
        return this.isDisplayVisible(category, display);
    }

    public boolean isDisplayVisible(DisplayCategory<?> category, Display display) {
        if (category == null) {
            throw new NullPointerException("Failed to resolve category: " + String.valueOf(display.getCategoryIdentifier()));
        }
        for (DisplayVisibilityPredicate predicate : this.visibilityPredicates) {
            try {
                EventResult result = predicate.handleDisplay(category, display);
                if (!result.interruptsFurtherEvaluation()) continue;
                return result.isEmpty() || result.isTrue();
            }
            catch (Throwable throwable) {
                InternalLogger.getInstance().error("Failed to check if the display is visible!", throwable);
            }
        }
        return true;
    }

    public List<DisplayVisibilityPredicate> getVisibilityPredicates() {
        return Collections.unmodifiableList(this.visibilityPredicates);
    }

    @Override
    public void startReload() {
        super.startReload();
        this.displayGenerators.clear();
        this.visibilityPredicates.clear();
    }

    public void endReload() {
        InternalLogger.getInstance().debug("Found %d displays", new Object[]{this.size()});
        for (CategoryIdentifier<?> identifier : this.getAll().keySet()) {
            if (!CategoryRegistry.getInstance().tryGet(identifier).isEmpty()) continue;
            InternalLogger.getInstance().error("Found displays registered for unknown registry", (Throwable)new IllegalStateException(identifier.toString()));
        }
        this.removeFailedDisplays();
        this.cache().endReload();
        InternalLogger.getInstance().debug("%d displays registration have completed", new Object[]{this.size()});
        for (Runnable job : this.jobs) {
            try {
                job.run();
            }
            catch (Throwable throwable) {
                InternalLogger.getInstance().error("Failed to run job", throwable);
            }
        }
        this.jobs.clear();
    }

    public void addRecipes(List<class_10297> entries) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        int lastSize = this.size();
        if (!this.fillers().isEmpty()) {
            for (class_10297 entry : entries) {
                try {
                    for (Display display : this.tryFillDisplay(entry.comp_3263(), new DisplayAdditionReason[]{DisplayAdditionReason.RECIPE_MANAGER, DisplayAdditionReason.withId((class_10298)entry.comp_3262())})) {
                        this.add(display, entry);
                    }
                }
                catch (Throwable e) {
                    InternalLogger.getInstance().error("Failed to fill display for recipe: %s [%s]", new Object[]{entry.comp_3263(), entry.comp_3262(), e});
                }
            }
        }
        InternalLogger.getInstance().debug("Filled %d displays from vanilla server in %s", new Object[]{this.size() - lastSize, stopwatch.stop()});
    }

    public void removeRecipes(Set<class_10298> ids) {
        LinkedList<Display> toRemove = new LinkedList<Display>();
        WeakHashMap<Display, Object> origins = ((ClientDisplaysHolder)this.holder()).origins();
        for (Map.Entry<Display, Object> entry : origins.entrySet()) {
            class_10297 displayEntry;
            Object object = entry.getValue();
            if (!(object instanceof class_10297) || !ids.contains((displayEntry = (class_10297)object).comp_3262())) continue;
            toRemove.add(entry.getKey());
        }
        for (Display display : toRemove) {
            ((ClientDisplaysHolder)this.holder()).remove(display);
        }
    }

    public void removeSyncedRecipes() {
        LinkedList<Display> toRemove = new LinkedList<Display>();
        WeakHashMap<Display, Object> origins = ((ClientDisplaysHolder)this.holder()).origins();
        for (Map.Entry<Display, Object> entry : origins.entrySet()) {
            if (entry.getValue() != SYNCED) continue;
            toRemove.add(entry.getKey());
        }
        for (Display display : toRemove) {
            ((ClientDisplaysHolder)this.holder()).remove(display);
        }
    }

    private void removeFailedDisplays() {
        ListMultimap failedDisplays = Multimaps.newListMultimap(new HashMap(), ArrayList::new);
        for (List<Display> displays : this.getAll().values()) {
            for (Display display : displays) {
                if (DisplayValidator.validate(display)) continue;
                failedDisplays.put((Object)display.getCategoryIdentifier(), (Object)display);
            }
        }
        InternalLogger.getInstance().debug("Removing %d failed displays" + (!failedDisplays.isEmpty() ? ":" : ""), new Object[]{failedDisplays.size()});
        failedDisplays.asMap().entrySet().stream().sorted(Comparator.comparing(entry -> ((CategoryIdentifier)entry.getKey()).toString())).forEach(entry -> {
            InternalLogger.getInstance().debug("- %s: %d failed display" + (((Collection)entry.getValue()).size() == 1 ? "" : "s"), new Object[]{entry.getKey(), ((Collection)entry.getValue()).size()});
            for (Display display : (Collection)entry.getValue()) {
                ((ClientDisplaysHolder)this.holder()).remove(display);
            }
        });
    }

    public void postStage(ReloadStage stage) {
        if (stage != ReloadStage.END) {
            return;
        }
        InternalLogger.getInstance().debug("Registered displays report (%d displays, %d cached / %d not cached)" + (this.size() > 0 ? ":" : ""), new Object[]{this.size(), this.cache().cachedSize(), this.cache().notCachedSize()});
        this.getAll().entrySet().stream().sorted(Comparator.comparing(entry -> ((CategoryIdentifier)entry.getKey()).toString())).forEach(entry -> InternalLogger.getInstance().debug("- %s: %d display" + (((List)entry.getValue()).size() == 1 ? "" : "s"), new Object[]{entry.getKey(), ((List)entry.getValue()).size()}));
    }

    public DisplayCache cache() {
        return ((ClientDisplaysHolder)this.holder()).cache;
    }

    public static class ClientDisplaysHolder
    extends DisplaysHolderImpl.ByKey {
        private final DisplayCache cache = new DisplayCacheImpl(false);

        @Override
        public void add(Display display, @Nullable Object origin) {
            super.add(display, origin);
            this.cache.add(display);
        }

        @Override
        public boolean remove(Display display) {
            if (super.remove(display)) {
                this.cache.remove(display);
                return true;
            }
            return false;
        }

        @Override
        @Nullable
        public Object getDisplayOrigin(Display display) {
            Object origin = super.getDisplayOrigin(display);
            if (origin != null) {
                return origin;
            }
            return DisplayHistoryManager.INSTANCE.getPossibleOrigin(this, display);
        }

        @Override
        protected boolean checkCategory(CategoryIdentifier<?> key) {
            return CategoryRegistry.getInstance().tryGet(key).isPresent();
        }

        private WeakHashMap<Display, Object> origins() {
            return this.originsMap;
        }
    }
}

