/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.entry.filtering.rules;

import com.mojang.datafixers.util.Pair;
import com.mojang.datafixers.util.Unit;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.shedaniel.clothconfig2.api.LazyResettable;
import me.shedaniel.rei.api.client.entry.filtering.FilteringContext;
import me.shedaniel.rei.api.client.entry.filtering.FilteringResult;
import me.shedaniel.rei.api.client.entry.filtering.FilteringResultFactory;
import me.shedaniel.rei.api.client.entry.filtering.FilteringRule;
import me.shedaniel.rei.api.client.entry.filtering.FilteringRuleType;
import me.shedaniel.rei.api.client.entry.filtering.base.BasicFilteringRule;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.registry.ReloadStage;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.entry.filtering.rules.BasicFilteringRuleType;
import me.shedaniel.rei.impl.client.util.ThreadCreator;

public enum BasicFilteringRuleImpl implements BasicFilteringRule<Unit>
{
    INSTANCE;

    private static final ExecutorService EXECUTOR_SERVICE;
    private final LongSet hiddenHashes = new LongOpenHashSet();
    private final LongSet shownHashes = new LongOpenHashSet();
    private final List<CachedProvider> hiddenProviders = new ArrayList<CachedProvider>();
    private final List<CachedProvider> shownProviders = new ArrayList<CachedProvider>();

    public FilteringRuleType<? extends FilteringRule<Unit>> getType() {
        return BasicFilteringRuleType.INSTANCE;
    }

    public Unit prepareCache(boolean async) {
        for (CachedProvider provider : this.hiddenProviders) {
            provider.get();
        }
        for (CachedProvider provider : this.shownProviders) {
            provider.get();
        }
        return Unit.INSTANCE;
    }

    public FilteringResult processFilteredStacks(FilteringContext context, FilteringResultFactory resultFactory, Unit cache, boolean async) {
        FilteringResult result = resultFactory.create();
        this.hideList(context.getShownStacks(), context.getShownExactHashes(), result, async, this.hiddenHashes);
        this.hideList(context.getUnsetStacks(), context.getUnsetExactHashes(), result, async, this.hiddenHashes);
        for (CachedProvider provider : this.hiddenProviders) {
            this.hideList(context.getShownStacks(), context.getShownExactHashes(), result, async, provider.getExactHashes());
            this.hideList(context.getUnsetStacks(), context.getUnsetExactHashes(), result, async, provider.getExactHashes());
        }
        this.showList(context.getHiddenStacks(), context.getHiddenExactHashes(), result, async, this.shownHashes);
        this.showList(context.getUnsetStacks(), context.getUnsetExactHashes(), result, async, this.shownHashes);
        for (CachedProvider provider : this.shownProviders) {
            this.showList(context.getHiddenStacks(), context.getHiddenExactHashes(), result, async, provider.getExactHashes());
            this.showList(context.getUnsetStacks(), context.getUnsetExactHashes(), result, async, provider.getExactHashes());
        }
        return result;
    }

    private void hideList(Collection<EntryStack<?>> stacks, LongCollection hashes, FilteringResult result, boolean async, LongSet filteredStacks) {
        LongIterator iterator = hashes.iterator();
        result.hide((Collection)stacks.stream().filter(stack -> filteredStacks.contains(iterator.nextLong())).collect(Collectors.toList()));
    }

    private void showList(Collection<EntryStack<?>> stacks, LongCollection hashes, FilteringResult result, boolean async, LongSet filteredStacks) {
        LongIterator iterator = hashes.iterator();
        result.show((Collection)stacks.stream().filter(stack -> filteredStacks.contains(iterator.nextLong())).collect(Collectors.toList()));
    }

    public FilteringResult hide(EntryStack<?> stack) {
        long hashExact = EntryStacks.hashExact(stack);
        this.hiddenHashes.add(hashExact);
        this.shownHashes.remove(hashExact);
        if (!this.isReloading()) {
            this.markDirty(List.of(stack), null);
        }
        return this;
    }

    public FilteringResult hide(Collection<? extends EntryStack<?>> stacks) {
        for (EntryStack<?> stack : stacks) {
            long hashExact = EntryStacks.hashExact(stack);
            this.hiddenHashes.add(hashExact);
            this.shownHashes.remove(hashExact);
        }
        if (!this.isReloading()) {
            this.markDirty(stacks, null);
        }
        return this;
    }

    public FilteringResult show(EntryStack<?> stack) {
        long hashExact = EntryStacks.hashExact(stack);
        this.shownHashes.add(hashExact);
        this.hiddenHashes.remove(hashExact);
        if (!this.isReloading()) {
            this.markDirty(List.of(stack), null);
        }
        return this;
    }

    public FilteringResult show(Collection<? extends EntryStack<?>> stacks) {
        for (EntryStack<?> stack : stacks) {
            long hashExact = EntryStacks.hashExact(stack);
            this.shownHashes.add(hashExact);
            this.hiddenHashes.remove(hashExact);
        }
        if (!this.isReloading()) {
            this.markDirty(stacks, null);
        }
        return this;
    }

    public BasicFilteringRule.MarkDirty hide(Supplier<Collection<EntryStack<?>>> provider) {
        CachedProvider cachedProvider = new CachedProvider(provider);
        this.shownProviders.remove(cachedProvider);
        this.hiddenProviders.add(cachedProvider);
        cachedProvider.markDirty();
        return cachedProvider;
    }

    public BasicFilteringRule.MarkDirty show(Supplier<Collection<EntryStack<?>>> provider) {
        CachedProvider cachedProvider = new CachedProvider(provider);
        this.hiddenProviders.remove(cachedProvider);
        this.shownProviders.add(cachedProvider);
        cachedProvider.markDirty();
        return cachedProvider;
    }

    public ReloadStage getStage() {
        return ReloadStage.START;
    }

    public void startReload() {
        this.hiddenHashes.clear();
        this.shownHashes.clear();
        this.hiddenProviders.clear();
        this.shownProviders.clear();
    }

    public void acceptPlugin(REIClientPlugin plugin) {
        plugin.registerBasicEntryFiltering((BasicFilteringRule)this);
    }

    static {
        EXECUTOR_SERVICE = new ThreadCreator("REI-BasicFiltering").asService();
    }

    private class CachedProvider
    implements BasicFilteringRule.MarkDirty {
        private final Supplier<Collection<EntryStack<?>>> provider;
        private final LazyResettable<Pair<Collection<EntryStack<?>>, LongSet>> cache = new LazyResettable(this::compose);

        private CachedProvider(Supplier<Collection<EntryStack<?>>> provider) {
            this.provider = provider;
        }

        public void markDirty() {
            Pair prev = (Pair)this.cache.get();
            this.cache.reset();
            Pair next = (Pair)this.cache.get();
            BasicFilteringRuleImpl.this.markDirty((Collection)prev.getFirst(), (LongCollection)prev.getSecond());
            BasicFilteringRuleImpl.this.markDirty((Collection)next.getFirst(), (LongCollection)next.getSecond());
        }

        public Collection<EntryStack<?>> get() {
            return (Collection)((Pair)this.cache.get()).getFirst();
        }

        public LongSet getExactHashes() {
            return (LongSet)((Pair)this.cache.get()).getSecond();
        }

        private Pair<Collection<EntryStack<?>>, LongSet> compose() {
            Collection<EntryStack<?>> stacks = this.provider.get();
            LongOpenHashSet hashes = new LongOpenHashSet(stacks.size());
            for (EntryStack<?> stack : stacks) {
                hashes.add(EntryStacks.hashExact(stack));
            }
            return Pair.of(stacks, (Object)hashes);
        }
    }
}

