/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.impl.client.gui.credits;

import com.google.common.collect.Lists;
import dev.architectury.platform.Platform;
import me.shedaniel.rei.impl.client.gui.credits.CreditsEntryListWidget.TextCreditsItem;
import me.shedaniel.rei.impl.client.gui.credits.CreditsEntryListWidget.TranslationCreditsItem;
import net.minecraft.class_1074;
import net.minecraft.class_11908;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3545;
import net.minecraft.class_4185;
import net.minecraft.class_4264;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.jetbrains.annotations.ApiStatus;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import java.util.stream.Collectors;

@ApiStatus.Internal
public class CreditsScreen extends class_437 {
    private class_437 parent;
    private class_4264 buttonDone;
    private CreditsEntryListWidget entryListWidget;
    
    public CreditsScreen(class_437 parent) {
        super(class_2561.method_43470(""));
        this.parent = parent;
    }
    
    @Override
    public boolean method_25404(class_11908 event) {
        if (event.comp_4795() == 256 && this.method_25422()) {
            openPrevious();
            return true;
        }
        return super.method_25404(event);
    }
    
    public static class TranslatorEntry {
        private final String name;
        private final boolean proofreader;
        
        public TranslatorEntry(String name) {
            this(name, false);
        }
        
        public TranslatorEntry(String name, boolean proofreader) {
            this.name = name;
            this.proofreader = proofreader;
        }
        
        public String getName() {
            return name;
        }
    }
    
    @Override
    public void method_25426() {
        method_25429(entryListWidget = new CreditsEntryListWidget(field_22787, field_22789, field_22790, 32, field_22790 - 32));
        entryListWidget.creditsClearEntries();
        List<class_3545<String, List<TranslatorEntry>>> translators = Lists.newArrayList();
        Exception[] exception = {null};
        fillTranslators(exception, translators);
        List<class_3545<String, List<TranslatorEntry>>> translatorsMapped = translators.stream().map(pair -> {
            return new class_3545<>(
                    "  " + (class_1074.method_4663("language.roughlyenoughitems." + pair.method_15442().toLowerCase(Locale.ROOT).replace(' ', '_')) ? class_1074.method_4662("language.roughlyenoughitems." + pair.method_15442().toLowerCase(Locale.ROOT).replace(' ', '_')) : pair.method_15442()),
                    pair.method_15441()
            );
        }).collect(Collectors.toList());
        int i = field_22789 - 80 - 6;
        for (String line : String.format("§lRoughly Enough Items (v%s)\n§7Originally a fork for Almost Enough Items.\n\n§lLanguage Translation\n%s\n\n§lLicense\n§7Roughly Enough Items is licensed under MIT.", Platform.getMod("roughlyenoughitems").getVersion(), "%translators%").split("\n"))
            if (line.equalsIgnoreCase("%translators%")) {
                if (exception[0] != null) {
                    entryListWidget.creditsAddEntry(new TextCreditsItem(class_2561.method_43470("Failed to get translators: " + exception[0].toString())));
                    for (StackTraceElement traceElement : exception[0].getStackTrace())
                        entryListWidget.creditsAddEntry(new TextCreditsItem(class_2561.method_43470("  at " + traceElement)));
                } else {
                    int maxWidth = translatorsMapped.stream().mapToInt(pair -> field_22793.method_1727(pair.method_15442())).max().orElse(0) + 5;
                    for (class_3545<String, List<TranslatorEntry>> pair : translatorsMapped) {
                        class_5250 text = class_2561.method_43470("");
                        boolean isFirst = true;
                        for (TranslatorEntry entry : pair.method_15441()) {
                            if (!isFirst) {
                                text = text.method_10852(class_2561.method_43470(", "));
                            }
                            isFirst = false;
                            class_5250 component = class_2561.method_43470(entry.getName());
                            if (entry.proofreader)
                                component = component.method_27692(class_124.field_1065);
                            text = text.method_10852(component);
                        }
                        entryListWidget.creditsAddEntry(new TranslationCreditsItem(class_2561.method_43471(pair.method_15442()), text, i - maxWidth - 10, maxWidth));
                    }
                }
            } else entryListWidget.creditsAddEntry(new TextCreditsItem(class_2561.method_43470(line)));
        entryListWidget.creditsAddEntry(new TextCreditsItem(class_2561.method_43473()));
        entryListWidget.creditsAddEntry(new CreditsEntryListWidget.LinkItem(class_2561.method_43470("Visit the project at GitHub."), "https://www.github.com/shedaniel/RoughlyEnoughItems", entryListWidget.getItemWidth(), false));
        entryListWidget.creditsAddEntry(new CreditsEntryListWidget.LinkItem(class_2561.method_43470("Visit the project page at CurseForge."), "https://www.curseforge.com/minecraft/mc-mods/roughly-enough-items", entryListWidget.getItemWidth(), false));
        entryListWidget.creditsAddEntry(new CreditsEntryListWidget.LinkItem(class_2561.method_43470("Support the project via Patreon!"), "https://patreon.com/shedaniel", entryListWidget.getItemWidth(), true));
        entryListWidget.creditsAddEntry(new TextCreditsItem(class_2561.method_43473()));
        method_37063(buttonDone = new class_4185(field_22789 / 2 - 100, field_22790 - 26, 200, 20, class_2561.method_43471("gui.done"), button -> openPrevious(), Supplier::get) {});
    }
    
    private static void fillTranslators(Exception[] exception, List<class_3545<String, List<TranslatorEntry>>> translators) {
        try {
            Class.forName("me.shedaniel.rei.impl.client.gui.credits.%s.CreditsScreenImpl".formatted(Platform.isForge() ? "forge" : "fabric"))
                    .getDeclaredMethod("fillTranslators", Exception[].class, List.class)
                    .invoke(null, exception, translators);
        } catch (IllegalAccessException | ClassNotFoundException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
    
    private void openPrevious() {
        class_310.method_1551().method_1507(parent);
    }
    
    @Override
    public boolean method_25401(double mouseX, double mouseY, double amountX, double amountY) {
        if (entryListWidget.method_25401(mouseX, mouseY, amountX, amountY))
            return true;
        return super.method_25401(mouseX, mouseY, amountX, amountY);
    }
    
    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        super.method_25394(graphics, mouseX, mouseY, delta);
        graphics.method_25300(this.field_22793, class_1074.method_4662("text.rei.credits"), this.field_22789 / 2, 16, 16777215);
    }
    
    @Override
    public void method_25420(class_332 graphics, int mouseX, int mouseY, float delta) {
        super.method_25420(graphics, mouseX, mouseY, delta);
        this.entryListWidget.method_25394(graphics, mouseX, mouseY, delta);
    }
}
