/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.impl.client.config.entries;

import me.shedaniel.rei.api.client.entry.filtering.FilteringRule;
import me.shedaniel.rei.api.client.entry.filtering.FilteringRuleType;
import me.shedaniel.rei.api.client.entry.filtering.FilteringRuleTypeRegistry;
import me.shedaniel.rei.impl.client.gui.widget.UpdatedListWidget;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_6379;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

public class FilteringAddRuleScreen extends class_437 {
    private final List<FilteringRule<?>> rules;
    private RulesList rulesList;
    class_437 parent;
    
    public FilteringAddRuleScreen(List<FilteringRule<?>> rules) {
        super(class_2561.method_43471("config.roughlyenoughitems.filteringRulesScreen.new"));
        this.rules = rules;
    }
    
    @Override
    public void method_25426() {
        super.method_25426();
        {
            class_2561 backText = class_2561.method_43470("↩ ").method_10852(class_2561.method_43471("gui.back"));
            method_37063(new class_4185(4, 4, class_310.method_1551().field_1772.method_27525(backText) + 10, 20, backText, button -> {
                field_22787.method_1507(parent);
                this.parent = null;
            }, Supplier::get) {
            });
        }
        rulesList = method_25429(new RulesList(field_22787, field_22789, field_22790, 30, field_22790));
        for (FilteringRuleType<?> rule : FilteringRuleTypeRegistry.getInstance()) {
            if (!rule.isSingular())
                rulesList.addItem(new DefaultRuleEntry(parent, rules, rule.createNew(), null));
        }
        rulesList.selectItem(rulesList.method_25396().get(0));
    }
    
    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        super.method_25394(graphics, mouseX, mouseY, delta);
        this.rulesList.method_25394(graphics, mouseX, mouseY, delta);
        graphics.method_35720(this.field_22793, this.field_22785.method_30937(), (int) (this.field_22789 / 2.0F - this.field_22793.method_27525(this.field_22785) / 2.0F), 12, -1);
    }
    
    @Override
    public void method_25419() {
        this.field_22787.method_1507(parent);
    }
    
    public static class RulesList extends UpdatedListWidget<RuleEntry> {
        private boolean inFocus;
        
        public RulesList(class_310 client, int width, int height, int top, int bottom) {
            super(client, width, height, top, bottom);
        }
        
        @Override
        protected boolean isSelected(int index) {
            return Objects.equals(this.getSelectedItem(), this.method_25396().get(index));
        }
        
        @Override
        protected int addItem(RuleEntry item) {
            return super.addItem(item);
        }
        
        @Override
        public int getItemWidth() {
            return width - 40;
        }
        
        @Override
        protected int getScrollbarPosition() {
            return width - 14;
        }
    }
    
    public static abstract class RuleEntry extends UpdatedListWidget.ElementEntry<RuleEntry> {
        private final FilteringRule<?> rule;
        
        public RuleEntry(FilteringRule<?> rule) {
            this.rule = rule;
        }
        
        public FilteringRule<?> getRule() {
            return rule;
        }
        
        @Override
        public int getItemHeight() {
            return 26;
        }
    }
    
    public static class DefaultRuleEntry extends RuleEntry {
        private final class_4185 addButton;
        private final Function<class_437, class_437> screenFunction;
        
        public DefaultRuleEntry(class_437 parent, List<FilteringRule<?>> rules, FilteringRule<?> rule, Function<class_437, class_437> screenFunction) {
            super(rule);
            this.screenFunction = (screenFunction == null ? ((FilteringRuleType<FilteringRule<?>>) rule.getType()).createEntryScreen(rule) : screenFunction);
            addButton = new class_4185(0, 0, 20, 20, class_2561.method_30163(" + "), button -> {
                class_310.method_1551().method_1507(this.screenFunction.apply(parent));
                rules.add(0, rule);
            }, Supplier::get) {
            };
            addButton.field_22763 = this.screenFunction != null;
        }
        
        @Override
        public void render(class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
            class_310 client = class_310.method_1551();
            {
                class_2561 title = ((FilteringRuleType<FilteringRule<?>>) getRule().getType()).getTitle(getRule());
                int i = client.field_1772.method_27525(title);
                if (i > entryWidth - 28) {
                    class_5348 titleTrimmed = class_5348.method_29433(client.field_1772.method_1714(title, entryWidth - 28 - client.field_1772.method_1727("...")), class_5348.method_29430("..."));
                    graphics.method_35720(client.field_1772, class_2477.method_10517().method_30934(titleTrimmed), x + 2, y + 1, 16777215);
                } else {
                    graphics.method_35720(client.field_1772, title.method_30937(), x + 2, y + 1, 16777215);
                }
            }
            {
                class_2561 subtitle = ((FilteringRuleType<FilteringRule<?>>) getRule().getType()).getSubtitle(getRule());
                int i = client.field_1772.method_27525(subtitle);
                if (i > entryWidth - 28) {
                    class_5348 subtitleTrimmed = class_5348.method_29433(client.field_1772.method_1714(subtitle, entryWidth - 28 - client.field_1772.method_1727("...")), class_5348.method_29430("..."));
                    graphics.method_35720(client.field_1772, class_2477.method_10517().method_30934(subtitleTrimmed), x + 2, y + 12, 8421504);
                } else {
                    graphics.method_35720(client.field_1772, subtitle.method_30937(), x + 2, y + 12, 8421504);
                }
            }
            addButton.method_46421(x + entryWidth - 25);
            addButton.method_46419(y + 1);
            addButton.method_25394(graphics, mouseX, mouseY, delta);
        }
        
        @Override
        public List<? extends class_364> method_25396() {
            return Collections.singletonList(addButton);
        }
        
        @Override
        public List<? extends class_6379> narratables() {
            return Collections.singletonList(addButton);
        }
    }
}
