/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.entry;

import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.common.entry.type.BuiltinEntryTypes;
import me.shedaniel.rei.api.common.entry.type.EntryDefinition;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.impl.client.entry.type.types.RenderingEntryDefinition;
import me.shedaniel.rei.impl.common.entry.type.EntryTypeDeferred;
import me.shedaniel.rei.impl.common.entry.type.types.EmptyEntryDefinition;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_3902;

public enum DeferringEntryTypeProviderImpl implements Function<class_2960, EntryType<?>>
{
    INSTANCE;

    class_2960 RENDERING_ID = class_2960.method_60656((String)"rendering");
    private Map<class_2960, EntryType<?>> typeCache = new ConcurrentHashMap();
    private EntryType<class_3902> empty;
    @Environment(value=EnvType.CLIENT)
    private EntryType<Renderer> render;

    @Override
    public EntryType<?> apply(class_2960 id) {
        if (id.equals((Object)BuiltinEntryTypes.EMPTY_ID)) {
            return this.typeCache.computeIfAbsent(id, this::emptyType);
        }
        if (id.equals((Object)this.RENDERING_ID) && Platform.getEnvironment() == Env.CLIENT) {
            return this.typeCache.computeIfAbsent(id, this::renderingType);
        }
        return this.typeCache.computeIfAbsent(id, EntryTypeDeferred::new);
    }

    public EntryType<class_3902> emptyType(final class_2960 id) {
        if (this.empty == null) {
            final int hashCode = id.hashCode();
            this.empty = new EntryType<class_3902>(this){

                public class_2960 getId() {
                    return id;
                }

                public EntryDefinition<class_3902> getDefinition() {
                    return EmptyEntryDefinition.EMPTY;
                }

                public int hashCode() {
                    return hashCode;
                }
            };
        }
        return this.empty;
    }

    @Environment(value=EnvType.CLIENT)
    public EntryType<Renderer> renderingType(final class_2960 id) {
        if (this.render == null) {
            @Environment(value=EnvType.CLIENT)
            class RenderType
            implements EntryType<Renderer> {
                private final int hashCode;

                RenderType() {
                    this.hashCode = id.hashCode();
                }

                public class_2960 getId() {
                    return id;
                }

                public EntryDefinition<Renderer> getDefinition() {
                    return RenderingEntryDefinition.RENDERING;
                }

                public int hashCode() {
                    return this.hashCode;
                }
            }
            this.render = new RenderType();
        }
        return this.render;
    }
}

