/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.performance;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import me.shedaniel.clothconfig2.gui.widget.DynamicEntryListWidget;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.gui.modules.Menu;
import me.shedaniel.rei.impl.client.gui.modules.entries.ToggleMenuEntry;
import me.shedaniel.rei.impl.client.gui.screen.ScreenWithMenu;
import me.shedaniel.rei.impl.client.gui.widget.UpdatedListWidget;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6379;

@Environment(value=EnvType.CLIENT)
public class DisplayRegistryInfoScreen
extends ScreenWithMenu {
    private Runnable onClose;
    private ListWidget list;
    private SortType sortType = SortType.ID;

    public DisplayRegistryInfoScreen(Runnable onClose) {
        super((class_2561)class_2561.method_43471((String)"text.rei.display_registry_analysis"));
        this.onClose = onClose;
    }

    public void method_25426() {
        class_5250 backText = class_2561.method_43470((String)"\u21a9 ").method_10852((class_2561)class_2561.method_43471((String)"gui.back"));
        this.method_37063((class_364)new class_4185.class_12231(this, 4, 4, class_310.method_1551().field_1772.method_27525((class_5348)backText) + 10, 20, (class_2561)backText, button -> {
            this.onClose.run();
            this.onClose = null;
        }, Supplier::get){});
        class_5250 text = class_2561.method_43471((String)"text.rei.sort");
        Rectangle bounds = new Rectangle(this.field_22789 - 4 - class_310.method_1551().field_1772.method_27525((class_5348)text) - 10, 4, class_310.method_1551().field_1772.method_27525((class_5348)text) + 10, 20);
        this.method_37063((class_364)new class_4185.class_12231(this, bounds.x, bounds.y, bounds.width, bounds.height, (class_2561)text, button -> this.setMenu(new Menu(bounds, CollectionUtils.map((Object[])SortType.values(), type -> ToggleMenuEntry.of((class_2561)class_2561.method_43469((String)"text.rei.sort.by", (Object[])new Object[]{type.name().toLowerCase(Locale.ROOT)}), () -> false, o -> {
            this.closeMenu();
            this.sortType = type;
            this.method_25423(this.field_22789, this.field_22790);
        })), false)), Supplier::get){});
        this.list = new ListWidget(this);
        this.list.addItem(new EntryImpl((class_2561)class_2561.method_43470((String)"Total Displays"), DisplayRegistry.getInstance().size()));
        this.sort(DisplayRegistry.getInstance().getAll().entrySet().stream()).forEach(entry -> this.list.addItem(new EntryImpl((CategoryIdentifier)entry.getKey(), ((List)entry.getValue()).size())));
        this.method_25429((class_364)this.list);
    }

    private Stream<Map.Entry<CategoryIdentifier<?>, List<Display>>> sort(Stream<Map.Entry<CategoryIdentifier<?>, List<Display>>> stream) {
        return switch (this.sortType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> stream.sorted(Comparator.comparingInt(value -> ((List)value.getValue()).size()).reversed());
            case 1 -> stream.sorted(Comparator.comparing(value -> ((CategoryIdentifier)value.getKey()).toString()));
        };
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        super.method_25394(graphics, mouseX, mouseY, delta);
        this.list.method_25394(graphics, mouseX, mouseY, delta);
        graphics.method_35720(this.field_22793, this.field_22785.method_30937(), (int)((float)this.field_22789 / 2.0f - (float)this.field_22793.method_27525((class_5348)this.field_22785) / 2.0f), 12, -1);
    }

    private static enum SortType {
        COUNT,
        ID;

    }

    private class ListWidget
    extends UpdatedListWidget<ListEntry> {
        public ListWidget(DisplayRegistryInfoScreen displayRegistryInfoScreen) {
            super(displayRegistryInfoScreen.field_22787, displayRegistryInfoScreen.field_22789, displayRegistryInfoScreen.field_22790, 30, displayRegistryInfoScreen.field_22790);
        }

        public int getItemWidth() {
            return this.width;
        }

        public int addItem(ListEntry item) {
            return super.addItem((DynamicEntryListWidget.Entry)item);
        }

        protected int getScrollbarPosition() {
            return this.width - 6;
        }
    }

    public static class EntryImpl
    extends ListEntry {
        private final class_2561 component;
        public final int count;

        public EntryImpl(CategoryIdentifier<?> identifier, int count) {
            this((class_2561)class_2561.method_43470((String)identifier.getIdentifier().toString()), count);
        }

        public EntryImpl(class_2561 component, int count) {
            this.component = component;
            this.count = count;
        }

        public void render(class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
            graphics.method_35720(class_310.method_1551().field_1772, this.component.method_30937(), x + 4, y + 6, -1);
            class_5481 rightText = class_2561.method_43469((String)"text.rei.display_registry_analysis.displays", (Object[])new Object[]{this.count}).method_30937();
            graphics.method_35720(class_310.method_1551().field_1772, rightText, x + entryWidth - 6 - 8 - class_310.method_1551().field_1772.method_30880(rightText), y + 6, -1);
        }

        public int getItemHeight() {
            return 24;
        }

        @Override
        public List<? extends class_364> method_25396() {
            return Collections.emptyList();
        }

        public List<? extends class_6379> narratables() {
            return Collections.emptyList();
        }
    }

    public static abstract class ListEntry
    extends UpdatedListWidget.ElementEntry<ListEntry> {
    }
}

