/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.impl.client.gui.widget;

import me.shedaniel.rei.api.client.gui.widgets.Widget;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4069;
import org.jetbrains.annotations.Nullable;

import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class VanillaWrappedWidget extends Widget {
    private class_364 element;
    
    public VanillaWrappedWidget(class_364 element) {
        this.element = Objects.requireNonNull(element);
        method_25395(element);
    }
    
    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        if (element instanceof Widget widget) {
            widget.method_25394(graphics, mouseX, mouseY, delta);
        } else {
            graphics.method_51448().pushMatrix();
            if (element instanceof class_4068 widget)
                widget.method_25394(graphics, mouseX, mouseY, delta);
            graphics.method_51448().popMatrix();
        }
    }
    
    @Override
    public List<? extends class_364> method_25396() {
        return Collections.singletonList(element);
    }
    
    @Nullable
    @Override
    public class_364 method_25399() {
        return element;
    }
    
    @Override
    public void method_25395(@Nullable class_364 guiEventListener) {
        if (guiEventListener == element) {
            super.method_25395(element);
        } else if (element instanceof class_4069 handler) {
            handler.method_25395(guiEventListener);
        }
    }
    
    @Override
    public boolean method_25397() {
        return true;
    }
    
    @Override
    public boolean containsMouse(double mouseX, double mouseY) {
        return element.method_25405(mouseX, mouseY);
    }
}