/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.impl.client.gui.text;

import me.shedaniel.math.Color;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5481;
import net.minecraft.util.*;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

import java.util.Locale;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;

import static me.shedaniel.rei.impl.client.gui.config.options.ConfigUtils.literal;

@ApiStatus.Internal
public class TextTransformations {
    public static class_5481 applyRainbow(class_5481 sequence, int x, int y) {
        int[] combinedX = {x};
        return sink -> sequence.accept((charIndex, style, codePoint) -> {
            if (charIndex == 0) combinedX[0] = x;
            int rgb = Color.HSBtoRGB(((class_156.method_658() - combinedX[0] * 10 - y * 10) % 2000) / 2000F, 0.8F, 0.95F);
            combinedX[0] += class_310.method_1551().field_1772.method_27527().field_24216.getWidth(codePoint, style);
            return sink.accept(charIndex, style.method_27703(class_5251.method_27717(rgb)), codePoint);
        });
    }
    
    public static class_5481 forwardWithTransformation(String text, CharSequenceTransformer transformer) {
        if (text.isEmpty()) {
            return class_5481.field_26385;
        }
        return sink -> {
            int length = text.length();
            
            for (int charIndex = 0; charIndex < length; ++charIndex) {
                char c = text.charAt(charIndex);
                
                if (Character.isHighSurrogate(c)) {
                    if (charIndex + 1 >= length) {
                        // Broken?
                        if (!sink.accept(charIndex, class_2583.field_24360, 65533)) {
                            return false;
                        }
                        break;
                    }
                    
                    char forward = text.charAt(charIndex + 1);
                    if (Character.isLowSurrogate(forward)) {
                        // Combine them together
                        if (!sink.accept(charIndex, class_2583.field_24360, Character.toCodePoint(c, forward))) {
                            return false;
                        }
                        
                        charIndex++;
                    } else {
                        // Broken?
                        if (!sink.accept(charIndex, class_2583.field_24360, 65533)) {
                            return false;
                        }
                    }
                } else if (Character.isSurrogate(c)) {
                    // This is weird, broken?
                    if (!sink.accept(charIndex, class_2583.field_24360, 65533)) {
                        return false;
                    }
                } else {
                    if (!sink.accept(charIndex, transformer.apply(text, charIndex, c), c)) {
                        return false;
                    }
                }
            }
            
            return true;
        };
    }
    
    public static class_5250 highlightText(class_5250 component, @Nullable String highlight, UnaryOperator<class_2583> styleOperator) {
        if (highlight == null) return component.method_27694(styleOperator);
        String string = component.getString();
        if (string.toLowerCase(Locale.ROOT).equals(highlight.toLowerCase(Locale.ROOT))) {
            return component.method_27694(styleOperator).method_27692(class_124.field_1054);
        }
        String[] parts = string.toLowerCase(Locale.ROOT).split(Pattern.quote(highlight.toLowerCase(Locale.ROOT)));
        if (string.toLowerCase(Locale.ROOT).endsWith(highlight.toLowerCase(Locale.ROOT))) {
            // Append an empty string to the end
            String[] newParts = new String[parts.length + 1];
            System.arraycopy(parts, 0, newParts, 0, parts.length);
            newParts[parts.length] = "";
            parts = newParts;
        }
        if (parts.length <= 1) return component.method_27694(styleOperator);
        class_5250 output = literal("");
        int curr = 0;
        for (int i = 0; i < parts.length; i++) {
            output.method_10852(literal(string.substring(curr, curr + parts[i].length())).method_27694(styleOperator));
            curr += parts[i].length();
            if (i != parts.length - 1) {
                output.method_10852(literal(string.substring(curr, curr + highlight.length())).method_27694(styleOperator)
                        .method_27692(class_124.field_1054));
                curr += highlight.length();
            }
        }
        return output;
    }
    
    @FunctionalInterface
    public interface CharSequenceTransformer {
        class_2583 apply(String text, int charIndex, char c);
    }
}
