/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.impl.client.config.entries;

import com.google.common.collect.ImmutableList;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.impl.client.config.addon.ConfigAddonsScreen;
import net.minecraft.class_1041;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_3902;
import net.minecraft.class_4185;
import net.minecraft.class_6379;
import org.jetbrains.annotations.ApiStatus;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;

@ApiStatus.Internal
public class ConfigAddonsEntry extends AbstractConfigListEntry<class_3902> {
    private int width;
    private class_339 buttonWidget = new class_4185.class_12231(0, 0, 0, 20, class_2561.method_43473(), button -> {
        class_310.method_1551().method_1507(new ConfigAddonsScreen(class_310.method_1551().field_1755));
    }, Supplier::get) {};
    private List<class_339> children = ImmutableList.of(buttonWidget);
    
    public ConfigAddonsEntry(int width) {
        super(class_2561.method_43473(), false);
        this.width = width;
        this.buttonWidget.method_25355(REIRuntime.getInstance().getPreviousContainerScreen() != null && class_310.method_1551().method_1562() != null
                && class_310.method_1551().method_1562().method_29091() != null ? class_2561.method_43471("text.rei.addons")
                : class_2561.method_43471("config.roughlyenoughitems.filteredEntries.loadWorldFirst"));
    }
    
    @Override
    public class_3902 getValue() {
        return class_3902.field_17274;
    }
    
    @Override
    public Optional<class_3902> getDefaultValue() {
        return Optional.of(class_3902.field_17274);
    }
    
    @Override
    public void save() {
    }
    
    @Override
    public void render(class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
        super.render(graphics, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isSelected, delta);
        class_1041 window = class_310.method_1551().method_22683();
        this.buttonWidget.field_22763 = REIRuntime.getInstance().getPreviousContainerScreen() != null && class_310.method_1551().method_1562() != null
                                   && class_310.method_1551().method_1562().method_29091() != null && this.isEditable();
        this.buttonWidget.method_46419(y);
        this.buttonWidget.method_46421(x + entryWidth / 2 - width / 2);
        this.buttonWidget.method_25358(width);
        this.buttonWidget.method_25394(graphics, mouseX, mouseY, delta);
    }
    
    @Override
    public List<? extends class_364> method_25396() {
        return children;
    }
    
    @Override
    public List<? extends class_6379> narratables() {
        return children;
    }
}
