/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.impl.client.gui.widget;

import me.shedaniel.math.Color;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.config.ConfigManagerImpl;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.EntryListSearchManager;
import net.minecraft.class_1735;
import net.minecraft.class_1921;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_465;

public class EntryHighlighter {
    public static void render(class_332 graphics) {
        float dimOpacity = (float) ConfigManagerImpl.getInstance().getConfig().functionality.inventoryHighlightingDarkenOpacity;
        float opacity = (float) ConfigManagerImpl.getInstance().getConfig().functionality.inventoryHighlightingOpacity;
        int dimColor = Color.ofRGBA(20 / 255F, 20 / 255F, 20 / 255F, dimOpacity).getColor();
        int borderColor = Color.ofRGBA(0x5f / 255F, 0xff / 255F, 0x3b / 255F, opacity).getColor();
        int color = Color.ofRGBA(0x5f / 255F, 0xff / 255F, 0x3b / 255F, opacity * 0x34 / 255F).getColor();
        if (class_310.method_1551().field_1755 instanceof class_465<?> containerScreen) {
            int x = containerScreen.field_2776, y = containerScreen.field_2800;
            for (class_1735 slot : containerScreen.method_17577().field_7761) {
                if (!slot.method_7681() || !EntryListSearchManager.INSTANCE.matches(EntryStacks.of(slot.method_7677()))) {
                    graphics.method_51740(class_1921.method_51785(), x + slot.field_7873, y + slot.field_7872, x + slot.field_7873 + 16, y + slot.field_7872 + 16, dimColor, dimColor, 0);
                } else {
                    graphics.method_51448().method_22903();
                    graphics.method_51448().method_46416(0, 0, 200f);
                    graphics.method_25296(x + slot.field_7873, y + slot.field_7872, x + slot.field_7873 + 16, y + slot.field_7872 + 16, color, color);
                    
                    graphics.method_25296(x + slot.field_7873 - 1, y + slot.field_7872 - 1, x + slot.field_7873, y + slot.field_7872 + 16 + 1, borderColor, borderColor);
                    graphics.method_25296(x + slot.field_7873 + 16, y + slot.field_7872 - 1, x + slot.field_7873 + 16 + 1, y + slot.field_7872 + 16 + 1, borderColor, borderColor);
                    graphics.method_25296(x + slot.field_7873 - 1, y + slot.field_7872 - 1, x + slot.field_7873 + 16, y + slot.field_7872, borderColor, borderColor);
                    graphics.method_25296(x + slot.field_7873 - 1, y + slot.field_7872 + 16, x + slot.field_7873 + 16, y + slot.field_7872 + 16 + 1, borderColor, borderColor);
                    
                    graphics.method_51448().method_22909();
                }
            }
        }
    }
}
