/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.impl.client.gui.toast;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_368;
import net.minecraft.class_374;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ExportRecipeIdentifierToast implements class_368 {
    protected static final class_2960 TEXTURE = class_2960.method_60655("roughlyenoughitems", "textures/gui/toasts.png");
    private String title;
    private String subtitle;
    private long startTime;
    private boolean changed;
    private class_368.class_369 wantedVisibility = class_369.field_2209;
    
    public ExportRecipeIdentifierToast(String title, @Nullable String subtitleNullable) {
        this.title = title;
        this.subtitle = subtitleNullable;
    }
    
    public static void addToast(String title, @Nullable String subtitleNullable) {
        class_310.method_1551().method_1566().method_1999(new ExportRecipeIdentifierToast(title, subtitleNullable));
    }
    
    @Override
    public class_369 method_61988() {
        return wantedVisibility;
    }
    
    @Override
    public void method_61989(class_374 toastManager, long l) {
        if (this.changed) {
            this.startTime = l;
            this.changed = false;
        }
        
        double d = (double) 5000L * toastManager.method_48221();
        long m = l - this.startTime;
        this.wantedVisibility = (double) m < d ? class_369.field_2210 : class_369.field_2209;
    }
    
    @Override
    public void method_1986(class_332 graphics, class_327 font, long var2) {
        RenderSystem.setShaderColor(1.0F, 1.0F, 1.0F, 1.0F);
        graphics.method_25290(class_1921::method_62277, TEXTURE, 0, 0, 0, 0, 160, 32, 256, 256);
        if (this.subtitle == null) {
            graphics.method_51433(font, this.title, 18, 12, 11141120, false);
        } else {
            graphics.method_51433(font, this.title, 18, 7, 11141120, false);
            graphics.method_51433(font, this.subtitle, 18, 18, -16777216, false);
        }
    }
    
    @Override
    public Object method_1987() {
        return Type.THIS_IS_SURE_A_TYPE;
    }
    
    public enum Type {
        THIS_IS_SURE_A_TYPE
    }
    
}
