/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.impl.client.gui.performance.entry;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import me.shedaniel.clothconfig2.api.Expandable;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.impl.client.gui.performance.PerformanceScreen;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1109;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_5481;
import net.minecraft.class_6379;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@Environment(EnvType.CLIENT)
public class SubCategoryListEntry extends PerformanceScreen.PerformanceEntry implements Expandable {
    private static final class_2960 CONFIG_TEX = class_2960.method_60655("cloth-config2", "textures/gui/cloth_config.png");
    private final List<PerformanceScreen.PerformanceEntry> entries;
    private final CategoryLabelWidget widget;
    private final List<class_364> children;
    private final class_2561 name;
    private final long totalTime;
    private boolean expanded;
    
    public SubCategoryListEntry(class_2561 name, List<PerformanceScreen.PerformanceEntry> entries, long totalTime, boolean defaultExpanded) {
        this.name = name;
        this.entries = entries;
        this.totalTime = totalTime;
        this.expanded = defaultExpanded;
        this.widget = new CategoryLabelWidget();
        this.children = Lists.newArrayList(new class_364[]{this.widget});
        this.children.addAll(entries);
    }
    
    @Override
    public boolean isExpanded() {
        return this.expanded;
    }
    
    @Override
    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }
    
    @Override
    public void render(class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        RenderSystem.setShaderColor(1.0F, 1.0F, 1.0F, 1.0F);
        this.widget.rectangle.x = x + 3;
        this.widget.rectangle.y = y;
        this.widget.rectangle.width = entryWidth - 6;
        this.widget.rectangle.height = 24;
        graphics.method_25290(class_1921::method_62277, CONFIG_TEX, x + 3, y + 5, 24, (this.widget.rectangle.contains(mouseX, mouseY) ? 18 : 0) + (this.expanded ? 9 : 0), 9, 9, 256, 256);
        graphics.method_35720(class_310.method_1551().field_1772, this.name.method_30937(), x + 3 + 15, y + 6, this.widget.rectangle.contains(mouseX, mouseY) ? -1638890 : -1);
        
        for (PerformanceScreen.PerformanceEntry performanceEntry : this.entries) {
            performanceEntry.setParent(this.getParent());
        }
        
        if (this.expanded) {
            int yy = y + 24;
            
            PerformanceScreen.PerformanceEntry entry;
            for (Iterator<PerformanceScreen.PerformanceEntry> iterator = this.entries.iterator(); iterator.hasNext(); yy += entry.getItemHeight()) {
                entry = iterator.next();
                entry.render(graphics, -1, yy, x + 3 + 15, entryWidth - 15 - 3, entry.getItemHeight(), mouseX, mouseY, isHovered && this.method_25399() == entry, delta);
            }
        }
        class_5481 timeText = PerformanceScreen.formatTime(totalTime, true);
        graphics.method_35720(class_310.method_1551().field_1772, timeText, x + entryWidth - 6 - 4 - class_310.method_1551().field_1772.method_30880(timeText), y + 6, -1);
    }
    
    @Override
    public int getMorePossibleHeight() {
        if (!this.expanded) {
            return -1;
        } else {
            List<Integer> list = new ArrayList();
            int i = 24;
            
            for (PerformanceScreen.PerformanceEntry entry : this.entries) {
                i += entry.getItemHeight();
                if (entry.getMorePossibleHeight() >= 0) {
                    list.add(i + entry.getMorePossibleHeight());
                }
            }
            
            list.add(i);
            return list.stream().max(Integer::compare).orElse(0) - this.getItemHeight();
        }
    }
    
    public Rectangle getEntryArea(int x, int y, int entryWidth, int entryHeight) {
        this.widget.rectangle.x = x;
        this.widget.rectangle.y = y;
        this.widget.rectangle.width = entryWidth;
        this.widget.rectangle.height = 24;
        return new Rectangle(this.getParent().left, y, this.getParent().right - this.getParent().left, 20);
    }
    
    @Override
    public int getItemHeight() {
        if (!this.expanded) {
            return 24;
        } else {
            int i = 24;
            
            PerformanceScreen.PerformanceEntry entry;
            for (Iterator<PerformanceScreen.PerformanceEntry> iterator = this.entries.iterator(); iterator.hasNext(); i += entry.getItemHeight()) {
                entry = iterator.next();
            }
            
            return i;
        }
    }
    
    @Override
    public List<? extends class_364> method_25396() {
        return this.expanded ? this.children : Collections.singletonList(this.widget);
    }
    
    @Override
    public List<? extends class_6379> narratables() {
        return Collections.emptyList();
    }
    
    public long getTotalTime() {
        return totalTime;
    }
    
    public class CategoryLabelWidget implements class_364 {
        private final Rectangle rectangle = new Rectangle();
        
        public CategoryLabelWidget() {
        }
        
        @Override
        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (this.rectangle.contains(mouseX, mouseY)) {
                SubCategoryListEntry.this.expanded = !SubCategoryListEntry.this.expanded;
                class_310.method_1551().method_1483().method_4873(class_1109.method_47978(class_3417.field_15015, 1.0F));
                return true;
            } else {
                return false;
            }
        }
        
        @Override
        public void method_25365(boolean bl) {
        }
        
        @Override
        public boolean method_25370() {
            return false;
        }
    }
}
