/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.impl.client.gui.hints;

import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.RoughlyEnoughItemsCoreClient;
import me.shedaniel.rei.api.client.ClientHelper;
import me.shedaniel.rei.api.client.gui.config.DisplayPanelLocation;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.impl.common.entry.type.EntryRegistryImpl;
import me.shedaniel.rei.impl.common.entry.type.EntryRegistryListener;
import me.shedaniel.rei.impl.common.util.InstanceHelper;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_5250;
import java.util.List;

public class ImportantWarningsWidget extends WidgetWithBounds {
    private static final EntryRegistryListener LISTENER = new EntryRegistryListener() {
    };
    private static String prevId = "";
    private static boolean dirty = false;
    private boolean visible;
    private final Rectangle bounds;
    private final Rectangle buttonBounds = new Rectangle();
    private List<class_2561> texts;
    
    public ImportantWarningsWidget() {
        if (((EntryRegistryImpl) EntryRegistry.getInstance()).listeners.add(LISTENER)) {
            String newId = class_310.method_1551().method_1496() ?
                    "integrated:" + class_310.method_1551().method_1576().method_27728().method_150()
                    : InstanceHelper.connectionFromClient() != null ? "server:" + InstanceHelper.connectionFromClient().method_16690()
                    : "null";
            if (!newId.equals(prevId)) {
                prevId = newId;
                dirty = true;
            }
            dirty = dirty && !ClientHelper.getInstance().canUseMovePackets();
        }
        
        this.visible = dirty;
        this.texts = List.of(
                class_2561.method_43471("text.rei.recipes.not.full.title").method_27692(class_124.field_1061),
                class_2561.method_43469("text.rei.recipes.not.full.desc", class_2561.method_43471("text.rei.recipes.not.full.desc.command").method_27695(class_124.field_1075, class_124.field_1073)).method_27692(class_124.field_1080)
        );
        this.bounds = ScreenRegistry.getInstance().getOverlayBounds(DisplayPanelLocation.LEFT, class_310.method_1551().field_1755);
        this.bounds.setBounds(this.bounds.x + 10, this.bounds.y + 10, this.bounds.width - 20, this.bounds.height - 20);
        int heightRequired = -5;
        for (class_2561 text : texts) {
            heightRequired += class_310.method_1551().field_1772.method_44378(text, this.bounds.width * 2) / 2;
            heightRequired += 5;
        }
        this.bounds.height = Math.min(heightRequired + 20, this.bounds.height);
    }
    
    @Override
    public Rectangle getBounds() {
        return bounds;
    }
    
    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        if (!visible)
            return;
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416(0, 0, 900);
        graphics.method_25294(bounds.x - 5, bounds.y - 5, bounds.getMaxX() + 5, bounds.getMaxY() + 5, 0x90111111);
        int y = bounds.y;
        for (class_2561 text : texts) {
            graphics.method_51448().method_22903();
            graphics.method_51448().method_46416(bounds.x, y, 0);
            graphics.method_51448().method_22905(0.5f, 0.5f, 1);
            graphics.method_65179(class_310.method_1551().field_1772, text, 0, 0, bounds.width * 2, -1);
            y += class_310.method_1551().field_1772.method_44378(text, bounds.width * 2) / 2 + 5;
            graphics.method_51448().method_22909();
        }
        
        class_5250 okayText = class_2561.method_43471("text.rei.recipes.not.full.button.okay");
        graphics.method_51448().method_22903();
        graphics.method_51448().method_22904(bounds.x + bounds.width / 2 - class_310.method_1551().field_1772.method_27525(okayText) * 0.75 / 2, bounds.getMaxY() - 9, 0);
        graphics.method_51448().method_22905(0.75f, 0.75f, 1);
        this.buttonBounds.setBounds(bounds.x, bounds.getMaxY() - 20, bounds.width, 20);
        graphics.method_27535(class_310.method_1551().field_1772, okayText, 0, 0,
                buttonBounds.contains(mouseX, mouseY) ? 0xfffff8de : 0xAAFFFFFF);
        graphics.method_51448().method_22909();
        graphics.method_51448().method_22909();
    }
    
    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.visible && button == 0 && buttonBounds.contains(mouseX, mouseY)) {
            dirty = false;
            this.visible = false;
            Widgets.produceClickSound();
            return true;
        }
        return false;
    }
    
    @Override
    public List<? extends class_364> method_25396() {
        return List.of();
    }
}
