/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.common.displays.brewing;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import me.shedaniel.rei.plugin.common.displays.brewing.BrewingRecipe;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class DefaultBrewingDisplay
implements Display {
    public static final DisplaySerializer<DefaultBrewingDisplay> SERIALIZER = DisplaySerializer.of(RecordCodecBuilder.mapCodec(instance -> instance.group((App)EntryIngredient.codec().fieldOf("input").forGetter(d -> d.input), (App)EntryIngredient.codec().fieldOf("reactant").forGetter(d -> d.reactant), (App)EntryIngredient.codec().fieldOf("output").forGetter(d -> d.output)).apply((Applicative)instance, DefaultBrewingDisplay::new)), StreamCodec.composite(EntryIngredient.streamCodec(), d -> d.input, EntryIngredient.streamCodec(), d -> d.reactant, EntryIngredient.streamCodec(), d -> d.output, DefaultBrewingDisplay::new));
    private final EntryIngredient reactant;
    private final EntryIngredient input;
    private final EntryIngredient output;

    public DefaultBrewingDisplay(BrewingRecipe recipe) {
        this(recipe.input(), recipe.ingredient(), recipe.output());
    }

    public DefaultBrewingDisplay(Ingredient input, Ingredient reactant, ItemStack output) {
        this(EntryIngredients.ofIngredient(input), EntryIngredients.ofIngredient(reactant), EntryIngredients.of(output));
    }

    public DefaultBrewingDisplay(EntryIngredient input, EntryIngredient reactant, EntryIngredient output) {
        this.input = input.map(stack -> stack.copy().tooltip(new Component[]{Component.translatable((String)"category.rei.brewing.input").withStyle(ChatFormatting.YELLOW)}));
        this.reactant = reactant.map(stack -> stack.copy().tooltip(new Component[]{Component.translatable((String)"category.rei.brewing.reactant").withStyle(ChatFormatting.YELLOW)}));
        this.output = output.map(stack -> stack.copy().tooltip(new Component[]{Component.translatable((String)"category.rei.brewing.result").withStyle(ChatFormatting.YELLOW)}));
    }

    @Override
    public List<EntryIngredient> getInputEntries() {
        return Lists.newArrayList((Object[])new EntryIngredient[]{this.input, this.reactant});
    }

    @Override
    public List<EntryIngredient> getOutputEntries() {
        return Collections.singletonList(this.output);
    }

    @Override
    public CategoryIdentifier<?> getCategoryIdentifier() {
        return BuiltinPlugin.BREWING;
    }

    @Override
    public Optional<ResourceLocation> getDisplayLocation() {
        return Optional.empty();
    }

    @Override
    public DisplaySerializer<? extends Display> getSerializer() {
        return SERIALIZER;
    }

    public List<EntryStack<?>> getOutput(int slot) {
        int i;
        ArrayList stack = new ArrayList();
        for (i = 0; i < slot * 2; ++i) {
            stack.add(EntryStack.empty());
        }
        for (i = 0; i < 6 - slot * 2; ++i) {
            stack.add((EntryStack)this.output.get(0));
        }
        return stack;
    }
}

