/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.exclusionzones;

import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.registry.screen.ExclusionZonesProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.effect.MobEffectInstance;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DefaultPotionEffectExclusionZones<T extends AbstractContainerScreen<?>>
implements ExclusionZonesProvider<T> {
    @Override
    public Collection<Rectangle> provide(T screen) {
        boolean fullWidth;
        int x;
        if (!screen.showsActiveEffects()) {
            return Collections.emptyList();
        }
        boolean leftSideMobEffects = ConfigObject.getInstance().isLeftSideMobEffects();
        Collection activePotionEffects = Minecraft.getInstance().player.getActiveEffects();
        if (!leftSideMobEffects) {
            x = ((AbstractContainerScreen)screen).leftPos + ((AbstractContainerScreen)screen).imageWidth + 2;
            int availableWidth = ((AbstractContainerScreen)screen).width - x;
            boolean bl = fullWidth = availableWidth >= 120;
            if (availableWidth < 32) {
                return Collections.emptyList();
            }
        } else {
            fullWidth = ((AbstractContainerScreen)screen).leftPos >= 120;
            x = ((AbstractContainerScreen)screen).leftPos - (fullWidth ? 124 : 36);
        }
        if (activePotionEffects.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Rectangle> zones = new ArrayList<Rectangle>();
        int y = ((AbstractContainerScreen)screen).topPos;
        int height = 33;
        if (activePotionEffects.size() > 5) {
            height = 132 / (activePotionEffects.size() - 1);
        }
        for (MobEffectInstance instance : Ordering.natural().sortedCopy((Iterable)activePotionEffects)) {
            zones.add(new Rectangle(x, y, fullWidth ? 120 : 32, 32));
            y += height;
        }
        return zones;
    }
}

