/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import dev.architectury.platform.Platform;
import dev.architectury.utils.value.BooleanValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigManager;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.favorites.FavoriteMenuEntry;
import me.shedaniel.rei.api.client.gui.config.SearchFieldLocation;
import me.shedaniel.rei.api.client.gui.widgets.Button;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.search.method.InputMethod;
import me.shedaniel.rei.api.client.search.method.InputMethodRegistry;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.REIRuntimeImpl;
import me.shedaniel.rei.impl.client.config.ConfigManagerImpl;
import me.shedaniel.rei.impl.client.config.ConfigObjectImpl;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.modules.MenuAccess;
import me.shedaniel.rei.impl.client.gui.modules.entries.SeparatorMenuEntry;
import me.shedaniel.rei.impl.client.gui.modules.entries.SubMenuEntry;
import me.shedaniel.rei.impl.client.gui.modules.entries.ToggleMenuEntry;
import me.shedaniel.rei.impl.client.gui.screen.ConfigReloadingScreen;
import me.shedaniel.rei.impl.client.search.method.DefaultInputMethod;
import me.shedaniel.rei.impl.common.InternalLogger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class CraftableFilterButtonWidget {
    public static final UUID FILTER_MENU_UUID = UUID.fromString("2839e998-1679-4f9e-a257-37411d16f1e6");

    public static Widget create(ScreenOverlayImpl overlay) {
        Rectangle bounds = CraftableFilterButtonWidget.getCraftableFilterBounds();
        MenuAccess access = overlay.menuAccess();
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        ItemStack icon = new ItemStack((ItemLike)Blocks.CRAFTING_TABLE);
        Button filterButton = Widgets.createButton(bounds, (Component)Component.empty()).focusable(false).onClick(button -> {
            ConfigManager.getInstance().toggleCraftableOnly();
            ScreenOverlayImpl.getEntryListWidget().updateSearch(REIRuntimeImpl.getSearchField().getText(), true);
        }).onRender((matrices, button) -> {
            button.setTint(ConfigManager.getInstance().isCraftableOnlyEnabled() ? 939579655 : 956235776);
            access.openOrClose(FILTER_MENU_UUID, button.getBounds(), () -> CraftableFilterButtonWidget.menuEntries(access));
        }).containsMousePredicate((button, point) -> button.getBounds().contains(point) && overlay.isNotInExclusionZones(point.x, point.y)).tooltipLineSupplier(button -> Component.translatable((String)(ConfigManager.getInstance().isCraftableOnlyEnabled() ? "text.rei.showing_craftable" : "text.rei.showing_all")));
        Widget overlayWidget = Widgets.createDrawableWidget((graphics, mouseX, mouseY, delta) -> {
            graphics.pose().pushMatrix();
            graphics.pose().translate((float)(bounds.x + 2), (float)(bounds.y + 2));
            graphics.renderItem(icon, 0, 0);
            graphics.pose().popMatrix();
        });
        return Widgets.concat(filterButton, overlayWidget);
    }

    private static Collection<FavoriteMenuEntry> menuEntries(MenuAccess access) {
        ConfigObjectImpl config = ConfigManagerImpl.getInstance().getConfig();
        ArrayList<FavoriteMenuEntry> entries = new ArrayList<FavoriteMenuEntry>(List.of(new SubMenuEntry((Component)Component.translatable((String)"text.rei.config.menu.search_field.position"), Arrays.stream(SearchFieldLocation.values()).map(location -> ToggleMenuEntry.of((Component)Component.literal((String)location.toString()), () -> config.getSearchFieldLocation() == location, bool -> config.setSearchFieldLocation((SearchFieldLocation)((Object)location))).withActive(() -> config.getSearchFieldLocation() != location)).toList())));
        List<Map.Entry<ResourceLocation, InputMethod<?>>> applicableInputMethods = CraftableFilterButtonWidget.getApplicableInputMethods();
        if (applicableInputMethods.size() > 1) {
            entries.add(new SubMenuEntry((Component)Component.translatable((String)"text.rei.config.menu.search_field.input_method"), CraftableFilterButtonWidget.createInputMethodEntries(access, applicableInputMethods)));
        }
        entries.add((SubMenuEntry)((Object)ToggleMenuEntry.of((Component)Component.translatable((String)"text.rei.config.menu.search_field.hide_entry_panel_idle"), config::isHidingEntryPanelIfIdle, hideEntryPanelIfIdle -> {
            config.setHidingEntryPanelIfIdle(hideEntryPanelIfIdle);
            REIRuntime.getInstance().getOverlay().orElseThrow().queueReloadSearch();
        })));
        return entries;
    }

    public static List<Map.Entry<ResourceLocation, InputMethod<?>>> getApplicableInputMethods() {
        String languageCode = Minecraft.getInstance().options.languageCode;
        return InputMethodRegistry.getInstance().getAll().entrySet().stream().filter(entry -> CollectionUtils.anyMatch(((InputMethod)entry.getValue()).getMatchingLocales(), locale -> locale.code().equals(languageCode))).toList();
    }

    public static List<FavoriteMenuEntry> createInputMethodEntries(MenuAccess access, List<Map.Entry<ResourceLocation, InputMethod<?>>> applicableInputMethods) {
        List<FavoriteMenuEntry> optionsMenuEntries;
        ConfigObjectImpl config = ConfigManagerImpl.getInstance().getConfig();
        List<FavoriteMenuEntry> entries = applicableInputMethods.stream().map(pair -> ToggleMenuEntry.of(((InputMethod)pair.getValue()).getName(), () -> Objects.equals(config.getInputMethodId(), pair.getKey()), bool -> {
            ExecutorService service = Executors.newSingleThreadExecutor();
            InputMethod<?> active = InputMethod.active();
            ((CompletableFuture)active.dispose(service).whenComplete((unused, throwable) -> {
                if (throwable != null) {
                    InternalLogger.getInstance().error("Failed to dispose input method", (Throwable)throwable);
                }
                ConfigManagerImpl.getInstance().getConfig().setInputMethodId(ResourceLocation.parse((String)"rei:default"));
            })).join();
            double[] progress = new double[]{0.0};
            CompletionStage future = ((InputMethod)pair.getValue()).prepare(service, p -> {
                progress[0] = Mth.clamp((double)p, (double)0.0, (double)1.0);
            }).whenComplete((unused, throwable) -> {
                if (throwable != null) {
                    InternalLogger.getInstance().error("Failed to prepare input method", (Throwable)throwable);
                    ConfigManagerImpl.getInstance().getConfig().setInputMethodId(ResourceLocation.parse((String)"rei:default"));
                } else {
                    ConfigManagerImpl.getInstance().getConfig().setInputMethodId((ResourceLocation)pair.getKey());
                }
            });
            Screen screen = Minecraft.getInstance().screen;
            ConfigReloadingScreen reloadingScreen = new ConfigReloadingScreen((Component)Component.translatable((String)"text.rei.input.methods.initializing"), () -> CraftableFilterButtonWidget.lambda$createInputMethodEntries$17((CompletableFuture)future), () -> Minecraft.getInstance().setScreen(screen), () -> CraftableFilterButtonWidget.lambda$createInputMethodEntries$19(screen, (CompletableFuture)future, service));
            reloadingScreen.setSubtitle(() -> Component.translatable((String)"text.rei.input.methods.reload.progress", (Object[])new Object[]{String.format("%.2f", progress[0] * 100.0)}));
            Minecraft.getInstance().setScreen((Screen)reloadingScreen);
            access.close();
            ((CompletableFuture)future).whenComplete((unused, throwable) -> {
                service.shutdown();
                if (throwable != null) {
                    return;
                }
                ScreenOverlayImpl.getInstance().getHintsContainer().addHint(12, () -> new Point(CraftableFilterButtonWidget.getCraftableFilterBounds().getCenterX(), CraftableFilterButtonWidget.getCraftableFilterBounds().getCenterY()), "text.rei.hint.input.methods", List.of(Component.translatable((String)"text.rei.hint.input.methods")));
            });
        }).withActive(() -> !Objects.equals(config.getInputMethodId(), pair.getKey())).withTooltip(() -> Tooltip.create(Widget.mouse(), ((InputMethod)pair.getValue()).getDescription()))).collect(Collectors.toList());
        InputMethod<?> active = InputMethod.active();
        if (!(active instanceof DefaultInputMethod)) {
            entries.add(0, new SeparatorMenuEntry());
            entries.add(0, FavoriteMenuEntry.createToggle((Component)Component.translatable((String)"text.rei.input.methods.tooltip.hints"), new BooleanValue(){

                public void accept(boolean t) {
                    ConfigManagerImpl.getInstance().getConfig().setDoDisplayIMEHints(!this.getAsBoolean());
                }

                public boolean getAsBoolean() {
                    return ConfigObject.getInstance().doDisplayIMEHints();
                }
            }));
        }
        if (!(optionsMenuEntries = active.getOptionsMenuEntries()).isEmpty()) {
            entries.add(new SeparatorMenuEntry());
            entries.addAll(optionsMenuEntries);
        }
        return entries;
    }

    private static Rectangle getCraftableFilterBounds() {
        Rectangle area = REIRuntimeImpl.getSearchField().getBounds().clone();
        area.setLocation(area.x + area.width + 4, area.y - 1);
        area.setSize(20, 20);
        return area;
    }

    private static /* synthetic */ void lambda$createInputMethodEntries$19(Screen screen, CompletableFuture future, ExecutorService service) {
        Minecraft.getInstance().setScreen(screen);
        InternalLogger.getInstance().error("Failed to prepare input method: cancelled");
        ConfigManagerImpl.getInstance().getConfig().setInputMethodId(ResourceLocation.parse((String)"rei:default"));
        future.cancel(Platform.isFabric());
        service.shutdown();
    }

    private static /* synthetic */ boolean lambda$createInputMethodEntries$17(CompletableFuture future) {
        return !future.isDone();
    }
}

