/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.config.options;

import java.util.ArrayList;
import java.util.List;
import me.shedaniel.rei.impl.client.gui.config.options.OptionGroup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class OptionCategory {
    private final String key;
    private final ResourceLocation icon;
    private final Component name;
    private final Component description;
    private final List<OptionGroup> groups = new ArrayList<OptionGroup>();

    private OptionCategory(String key, ResourceLocation icon, Component name, Component description) {
        this.key = key;
        this.icon = icon;
        this.name = name;
        this.description = description;
    }

    public static OptionCategory of(String key, ResourceLocation icon, Component name, Component description) {
        return new OptionCategory(key, icon, name, description);
    }

    public OptionCategory add(OptionGroup group) {
        this.groups.add(group);
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public ResourceLocation getIcon() {
        return this.icon;
    }

    public Component getName() {
        return this.name;
    }

    public Component getDescription() {
        return this.description;
    }

    public List<OptionGroup> getGroups() {
        return this.groups;
    }

    public OptionCategory copy() {
        OptionCategory category = new OptionCategory(this.key, this.icon, this.name, this.description);
        for (OptionGroup group : this.groups) {
            category.add(group.copy());
        }
        return category;
    }
}

