/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.config.components;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.shedaniel.clothconfig2.api.animator.NumberAnimator;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.Label;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.impl.client.gui.config.ConfigAccess;
import me.shedaniel.rei.impl.client.gui.config.components.ConfigOptionValueWidget;
import me.shedaniel.rei.impl.client.gui.config.options.AllREIConfigOptions;
import me.shedaniel.rei.impl.client.gui.config.options.CompositeOption;
import me.shedaniel.rei.impl.client.gui.config.options.ConfigUtils;
import me.shedaniel.rei.impl.client.gui.text.TextTransformations;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;

public class ConfigOptionWidget {
    public static <T> WidgetWithBounds create(final ConfigAccess access, final CompositeOption<T> option, final int width) {
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        final int[] stableHeight = new int[]{12};
        final int[] height = new int[]{12};
        Label fieldNameLabel = Widgets.createLabel(new Point(0, 0), (Component)TextTransformations.highlightText(option.getName().copy(), option.getOptionNameHighlight(), style -> style.withColor(-4144960))).leftAligned().rainbow(Objects.equals(option.getId(), AllREIConfigOptions.RAINBOW.getId()));
        widgets.add(fieldNameLabel);
        WidgetWithBounds optionValue = ConfigOptionValueWidget.create(access, option, width - 10 - fieldNameLabel.getBounds().width);
        widgets.add(Widgets.withTranslate((Widget)optionValue, () -> new Matrix3x2f().translate((float)(width - optionValue.getBounds().width - optionValue.getBounds().x), 0.0f)));
        widgets.add(new WidgetWithBounds(){
            final MutableComponent description = (MutableComponent)Util.make(() -> {
                MutableComponent description = option.getDescription().copy();
                if (description.getString().endsWith(".desc")) {
                    return ConfigUtils.literal("");
                }
                return TextTransformations.highlightText(description, option.getOptionDescriptionHighlight(), style -> style.withColor(-9079435));
            });
            final List<FormattedCharSequence> split;
            final boolean hasPreview;
            final Label previewLabel;
            @Nullable
            WidgetWithBounds preview;
            boolean previewVisible;
            Matrix3x2f previewTranslation;
            final NumberAnimator<Float> previewHeight;
            boolean nextLinePreview;
            {
                int lastWidth;
                this.split = Minecraft.getInstance().font.split((FormattedText)this.description, width);
                this.hasPreview = option.hasPreview();
                this.previewLabel = Widgets.createLabel(new Point(), (Component)ConfigUtils.translatable("config.rei.texts.preview")).color(-5901057).hoveredColor(-3015937).noShadow().clickable().onClick($ -> this.clickPreview()).rightAligned();
                this.preview = null;
                this.previewVisible = false;
                this.previewTranslation = new Matrix3x2f();
                this.previewHeight = ValueAnimator.ofFloat().withConvention(() -> Float.valueOf(this.previewVisible ? (float)this.preview.getBounds().getHeight() : 0.0f), ValueAnimator.typicalTransitionTime());
                this.nextLinePreview = false;
                stableHeight[0] = stableHeight[0] + 12 * this.split.size();
                if (this.hasPreview && (lastWidth = Minecraft.getInstance().font.width(this.split.get(this.split.size() - 1))) + this.previewLabel.getBounds().width + 10 > width) {
                    this.nextLinePreview = true;
                    stableHeight[0] = stableHeight[0] + 12;
                }
            }

            @Override
            public Rectangle getBounds() {
                return new Rectangle(0, 12, width, 12 + 12 * this.split.size());
            }

            public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
                this.previewHeight.update((double)delta);
                if (ConfigUtils.isReducedMotion()) {
                    this.previewHeight.completeImmediately();
                }
                height[0] = stableHeight[0] + Math.round(((Float)this.previewHeight.value()).floatValue());
                for (int i = 0; i < this.split.size(); ++i) {
                    graphics.drawString(Minecraft.getInstance().font, this.split.get(i), 0, 12 + 12 * i, -1, false);
                }
                if (this.hasPreview) {
                    if (this.nextLinePreview) {
                        this.previewLabel.setPoint(new Point(width, 12 + 12 * this.split.size()));
                    } else {
                        this.previewLabel.setPoint(new Point(width, 12 + 12 * this.split.size() - 12));
                    }
                    this.previewLabel.render(graphics, mouseX, mouseY, delta);
                    if (this.preview != null && ((Float)this.previewHeight.value()).floatValue() > 0.1f) {
                        Rectangle rectangle = new Rectangle(0.0, (double)(24 + 12 * this.split.size() - (this.nextLinePreview ? 0 : 12)), (double)width, (double)((Float)this.previewHeight.value()).floatValue());
                        graphics.enableScissor(rectangle.x, rectangle.y, rectangle.getMaxX(), rectangle.getMaxY());
                        this.previewTranslation = new Matrix3x2f().translate(0.0f, (float)(12 + 12 * this.split.size()));
                        this.preview.render(graphics, mouseX, mouseY, delta);
                        graphics.disableScissor();
                    }
                }
            }

            private void clickPreview() {
                if (this.preview == null) {
                    this.preview = option.getPreviewer().preview(width, () -> access.get(option));
                    this.preview = Widgets.withTranslate((Widget)this.preview, () -> this.previewTranslation);
                }
                this.previewVisible = !this.previewVisible;
            }

            public List<? extends GuiEventListener> children() {
                if (this.preview != null && ((Float)this.previewHeight.value()).floatValue() > 0.1f) {
                    return List.of(this.previewLabel, this.preview);
                }
                return List.of(this.previewLabel);
            }
        });
        height[0] = stableHeight[0];
        return Widgets.concatWithBounds(() -> new Rectangle(0, 0, width, height[0]), widgets);
    }
}

