/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client.util;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix3f;
import org.joml.Matrix3x2fStack;
import org.joml.Matrix4f;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class SpriteRenderer {
    public static RenderPass beginPass() {
        return new RenderPass();
    }

    public static class RenderPass {
        private float x1 = 0.0f;
        private float x2 = 1.0f;
        private float y1 = 0.0f;
        private float y2 = 0.0f;
        private float z1 = 0.0f;
        private float uStart = 0.0f;
        private float uEnd = 1.0f;
        private float vStart = 0.0f;
        private float vEnd = 1.0f;
        private int u = 0;
        private int v = 1;
        private int r = 255;
        private int g = 255;
        private int b = 255;
        private int a = 255;
        private int l = 0;
        private float nX = 0.0f;
        private float nY = 0.0f;
        private float nZ = 0.0f;
        private TextureAtlasSprite sprite;
        private VertexConsumer consumer;
        private MultiBufferSource consumers;
        private Matrix3x2fStack matrices;
        private Matrix4f model;
        private Matrix3f normal;
        private RenderType layer;

        private RenderPass() {
        }

        public RenderPass setup(MultiBufferSource consumers, RenderType type) {
            this.consumers = consumers;
            this.setup(consumers.getBuffer(type), type);
            return this;
        }

        public RenderPass setup(VertexConsumer consumer, RenderType type) {
            this.consumer = consumer;
            this.matrices = new Matrix3x2fStack();
            this.layer = type;
            return this;
        }

        public RenderPass setup(MultiBufferSource consumers, GuiGraphics graphics, RenderType type) {
            this.consumers = consumers;
            this.consumer = consumers.getBuffer(type);
            this.matrices = graphics.pose();
            this.layer = type;
            return this;
        }

        public RenderPass position(Matrix4f model, float x1, float y1, float x2, float y2, float z1) {
            this.position(x1, y1, x2, y2, z1);
            this.model = model;
            return this;
        }

        public RenderPass position(float x1, float y1, float x2, float y2, float z1) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
            this.z1 = z1;
            return this;
        }

        public RenderPass sprite(TextureAtlasSprite sprite) {
            this.uStart = sprite.getU0();
            this.uEnd = sprite.getU1();
            this.vStart = sprite.getV0();
            this.vEnd = sprite.getV1();
            this.sprite = sprite;
            return this;
        }

        public RenderPass sprite(float uStart, float uEnd, float vStart, float vEnd) {
            this.uStart = uStart;
            this.uEnd = uEnd;
            this.vStart = vStart;
            this.vEnd = vEnd;
            return this;
        }

        public RenderPass overlay(int uv) {
            return this.overlay(uv & 0xFFFF, uv >> 16 & 0xFFFF);
        }

        public RenderPass overlay(int u, int v) {
            this.u = u;
            this.v = v;
            return this;
        }

        public RenderPass color(int color) {
            this.r = color >> 16 & 0xFF;
            this.g = color >> 8 & 0xFF;
            this.b = color & 0xFF;
            return this;
        }

        public RenderPass color(int r, int g, int b) {
            this.r = r;
            this.g = g;
            this.b = b;
            return this;
        }

        public RenderPass alpha(int a) {
            this.a = a;
            return this;
        }

        public RenderPass light(int l) {
            this.l = l;
            return this;
        }

        public RenderPass normal(Matrix3f normal, float nX, float nY, float nZ) {
            this.normal(nX, nY, nZ);
            this.normal = normal;
            return this;
        }

        public RenderPass normal(float nX, float nY, float nZ) {
            this.nX = nX;
            this.nY = nY;
            this.nZ = nZ;
            return this;
        }

        public void next() {
            if (this.sprite == null) {
                throw new RuntimeException("Invalid Sprite!");
            }
            this.next(this.sprite.contents().name());
        }

        private static VertexConsumer normal(VertexConsumer consumer, Matrix3f var1, float var2, float var3, float var4) {
            Vector3f var5 = var1.transform(new Vector3f(var2, var3, var4));
            return consumer.setNormal(var5.x(), var5.y(), var5.z());
        }

        public void next(ResourceLocation texture) {
        }
    }
}

