/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.runtime;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.doubles.DoubleIntMutablePair;
import it.unimi.dsi.fastutil.doubles.DoubleIntPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import me.shedaniel.math.Color;
import me.shedaniel.math.Point;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.api.common.plugins.REIPlugin;
import me.shedaniel.rei.api.common.registry.ReloadStage;
import me.shedaniel.rei.api.common.registry.Reloadable;
import me.shedaniel.rei.impl.client.gui.hints.HintProvider;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.Nullable;

public class PluginStageExecutionWatcher
implements HintProvider {
    private final Map<PluginManager<?>, PluginManagerData> allStages = new HashMap();
    private int lastStep;
    private Double lastProgress;

    public <T extends REIPlugin<?>> Reloadable<? extends T> reloadable(final PluginManager<?> manager) {
        return new Reloadable<T>(){

            private PluginManagerData data() {
                return PluginStageExecutionWatcher.this.allStages.computeIfAbsent(manager, PluginManagerData::new);
            }

            @Override
            public void startReload() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void preStage(ReloadStage stage) {
                Map<PluginManager<?>, PluginManagerData> map = PluginStageExecutionWatcher.this.allStages;
                synchronized (map) {
                    if (manager == PluginManager.getInstance() && stage.ordinal() == 0) {
                        PluginStageExecutionWatcher.this.allStages.clear();
                    }
                    this.data().beganStages.put(stage, new ArrayList());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void postStage(ReloadStage stage) {
                Map<PluginManager<?>, PluginManagerData> map = PluginStageExecutionWatcher.this.allStages;
                synchronized (map) {
                    this.data().finishedStages.add(stage);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void beforeReloadable(ReloadStage stage, Reloadable<T> other) {
                Map<PluginManager<?>, PluginManagerData> map = PluginStageExecutionWatcher.this.allStages;
                synchronized (map) {
                    this.data().beganStages.get((Object)stage).add(other);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ReloadStage> notVisited() {
        Map<PluginManager<?>, PluginManagerData> map = this.allStages;
        synchronized (map) {
            HashSet<ReloadStage> notVisited = new HashSet<ReloadStage>(Arrays.asList(ReloadStage.values()));
            notVisited.removeIf(stage -> this.allStages.values().stream().allMatch(data -> data.finishedStages.contains(stage)));
            return notVisited;
        }
    }

    @Override
    public List<Component> provide() {
        List<ReloadStage> stages = Arrays.asList(ReloadStage.values());
        Set<ReloadStage> notVisited = this.notVisited();
        int allManagers = PluginManager.getActiveInstances().size();
        DoubleIntPair[] progresses = new DoubleIntPair[allManagers];
        Triple current = null;
        int i = 0;
        for (PluginManager<REIPlugin<?>> manager : PluginManager.getActiveInstances()) {
            boolean allDone;
            PluginManagerData data = this.allStages.get(manager);
            int index = i++;
            if (data == null) {
                progresses[index] = DoubleIntPair.of((double)0.0, (int)0);
                continue;
            }
            boolean bl = allDone = data.finishedStages.size() == stages.size();
            if (allDone) {
                progresses[index] = DoubleIntPair.of((double)stages.size(), (int)stages.size());
                continue;
            }
            DoubleIntMutablePair pair = new DoubleIntMutablePair(0.0, 0);
            for (ReloadStage reloadStage : stages) {
                List<Reloadable<?>> reloadables = data.beganStages.get((Object)reloadStage);
                pair.right(pair.rightInt() + 1);
                if (reloadables == null) continue;
                boolean finished = data.finishedStages.contains((Object)reloadStage);
                if (finished) {
                    pair.left(pair.leftDouble() + 1.0);
                    continue;
                }
                pair.left(pair.leftDouble() + (double)reloadables.size() / (double)manager.getReloadables().size());
                if (reloadables.isEmpty()) continue;
                Reloadable currentReloadable = (Reloadable)Iterables.getLast(reloadables);
                current = Triple.of(manager, (Object)((Object)reloadStage), (Object)currentReloadable);
            }
            for (Map.Entry entry : data.beganStages.entrySet()) {
                ReloadStage reloadStage = (ReloadStage)((Object)entry.getKey());
            }
            progresses[index] = pair;
        }
        if (notVisited.isEmpty()) {
            this.lastProgress = null;
            return Collections.emptyList();
        }
        double total = 0.0;
        boolean j = false;
        for (DoubleIntPair pair : progresses) {
            total += pair == null || pair.rightInt() == 0 ? 0.0 : pair.leftDouble() / (double)pair.rightInt();
        }
        double average = total / (double)progresses.length;
        this.lastProgress = average;
        if (current != null) {
            int n = PluginManager.getActiveInstances().indexOf(current.getLeft());
            this.lastStep = n + 1 + ((ReloadStage)((Object)current.getMiddle())).ordinal() * allManagers;
        }
        String progress = String.format("Step %d/%d (%s%%):", this.lastStep, allManagers * stages.size(), Math.round(average * 100.0));
        String currentTask = current == null ? "Waiting" : PluginStageExecutionWatcher.getSimpleName(((Reloadable)current.getRight()).getClass());
        return ImmutableList.of((Object)Component.translatable((String)"text.rei.not.fully.initialized"), (Object)Component.literal((String)progress), (Object)Component.literal((String)currentTask));
    }

    private static <P> String getSimpleName(Class<? extends P> clazz) {
        String name = clazz.getName();
        name = name.contains(".") ? StringUtils.substringAfterLast((String)name, (String)".") : name;
        name = name.replace("Impl", "");
        name = name.replace("$", ".");
        return name;
    }

    @Override
    @Nullable
    public Tooltip provideTooltip(Point mouse) {
        return Tooltip.create(mouse, new Component[]{Component.translatable((String)"text.rei.not.fully.initialized.tooltip", (Object[])new Object[]{this.notVisited().stream().map(Enum::name).collect(Collectors.joining(", "))})});
    }

    @Override
    @Nullable
    public Double getProgress() {
        return this.lastProgress;
    }

    @Override
    public Color getColor() {
        return Color.ofTransparent((int)-60160);
    }

    @Override
    public List<HintProvider.HintButton> getButtons() {
        return Collections.emptyList();
    }

    private static class PluginManagerData {
        private final PluginManager<?> manager;
        private final Map<ReloadStage, List<Reloadable<?>>> beganStages = new HashMap();
        private final Set<ReloadStage> finishedStages = new HashSet<ReloadStage>();

        public PluginManagerData(PluginManager<?> manager) {
            this.manager = manager;
        }

        private void clear() {
            this.beganStages.clear();
            this.finishedStages.clear();
        }
    }
}

