/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.entry;

import com.google.common.base.Suppliers;
import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.client.fluid.ClientFluidStackHooks;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import java.util.ArrayList;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.entry.renderer.EntryRenderer;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntrySerializer;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.comparison.ComparisonContext;
import me.shedaniel.rei.api.common.entry.comparison.FluidComparatorRegistry;
import me.shedaniel.rei.api.common.entry.type.EntryDefinition;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import net.minecraft.ChatFormatting;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class FluidEntryDefinition
implements EntryDefinition<FluidStack>,
EntrySerializer<FluidStack> {
    private static final String FLUID_AMOUNT = Platform.isForge() ? "tooltip.rei.fluid_amount.forge" : "tooltip.rei.fluid_amount";
    @OnlyIn(value=Dist.CLIENT)
    private EntryRenderer<FluidStack> renderer;

    public FluidEntryDefinition() {
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> () -> Client.init(this));
    }

    @Override
    public Class<FluidStack> getValueType() {
        return FluidStack.class;
    }

    @Override
    public EntryType<FluidStack> getType() {
        return VanillaEntryTypes.FLUID;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public EntryRenderer<FluidStack> getRenderer() {
        return this.renderer;
    }

    @Override
    @Nullable
    public ResourceLocation getIdentifier(EntryStack<FluidStack> entry, FluidStack value) {
        return BuiltInRegistries.FLUID.getKey((Object)value.getFluid());
    }

    @Override
    public boolean isEmpty(EntryStack<FluidStack> entry, FluidStack value) {
        return value.isEmpty();
    }

    @Override
    public FluidStack copy(EntryStack<FluidStack> entry, FluidStack value) {
        return value.copy();
    }

    @Override
    public FluidStack normalize(EntryStack<FluidStack> entry, FluidStack value) {
        Fluid fluid = value.getFluid();
        if (fluid instanceof FlowingFluid) {
            FlowingFluid flowingFluid = (FlowingFluid)fluid;
            fluid = flowingFluid.getSource();
        }
        return FluidStack.create((Fluid)fluid, (long)FluidStack.bucketAmount(), (DataComponentPatch)value.getPatch());
    }

    @Override
    public FluidStack wildcard(EntryStack<FluidStack> entry, FluidStack value) {
        Fluid fluid = value.getFluid();
        if (fluid instanceof FlowingFluid) {
            fluid = ((FlowingFluid)fluid).getSource();
        }
        return FluidStack.create((Fluid)fluid, (long)FluidStack.bucketAmount());
    }

    @Override
    @Nullable
    public ItemStack cheatsAs(EntryStack<FluidStack> entry, FluidStack value) {
        if (value.isEmpty()) {
            return ItemStack.EMPTY;
        }
        Item bucket = value.getFluid().getBucket();
        if (bucket == null) {
            return ItemStack.EMPTY;
        }
        return new ItemStack((ItemLike)bucket);
    }

    @Override
    @Nullable
    public FluidStack add(FluidStack o1, FluidStack o2) {
        return o1.copyWithAmount(o1.getAmount() + o2.getAmount());
    }

    @Override
    public long hash(EntryStack<FluidStack> entry, FluidStack value, ComparisonContext context) {
        int code = 1;
        code = 31 * code + value.getFluid().hashCode();
        code = 31 * code + Long.hashCode(FluidComparatorRegistry.getInstance().hashOf(context, value));
        return code;
    }

    @Override
    public boolean equals(FluidStack o1, FluidStack o2, ComparisonContext context) {
        if (o1.getFluid() != o2.getFluid()) {
            return false;
        }
        return FluidComparatorRegistry.getInstance().hashOf(context, o1) == FluidComparatorRegistry.getInstance().hashOf(context, o2);
    }

    @Override
    @Nullable
    public EntrySerializer<FluidStack> getSerializer() {
        return this;
    }

    @Override
    public boolean acceptsNull() {
        return false;
    }

    @Override
    public Codec<FluidStack> codec() {
        return FluidStack.CODEC;
    }

    @Override
    public StreamCodec<RegistryFriendlyByteBuf, FluidStack> streamCodec() {
        return FluidStack.STREAM_CODEC;
    }

    @Override
    public Component asFormattedText(EntryStack<FluidStack> entry, FluidStack value) {
        return value.getName();
    }

    @Override
    public Stream<? extends TagKey<?>> getTagsFor(EntryStack<FluidStack> entry, FluidStack value) {
        return value.getFluid().builtInRegistryHolder().tags();
    }

    @Override
    public void fillCrashReport(CrashReport report, CrashReportCategory category, EntryStack<FluidStack> entry) {
        EntryDefinition.super.fillCrashReport(report, category, entry);
        FluidStack stack = entry.getValue();
        category.setDetail("Fluid Type", () -> String.valueOf(BuiltInRegistries.FLUID.getKey((Object)stack.getFluid())));
        category.setDetail("Fluid Amount", () -> String.valueOf(stack.getAmount()));
        category.setDetail("Fluid NBT", () -> DataComponentPatch.CODEC.encodeStart((DynamicOps)BasicDisplay.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)stack.getPatch()).result().map(Tag::toString).orElse("Error"));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class Client {
        private Client() {
        }

        private static void init(FluidEntryDefinition definition) {
            definition.renderer = new FluidEntryRenderer();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class FluidEntryRenderer
    implements EntryRenderer<FluidStack> {
        private static final Supplier<TextureAtlasSprite> MISSING_SPRITE = Suppliers.memoize(() -> null);

        private TextureAtlasSprite missingTexture() {
            return MISSING_SPRITE.get();
        }

        @Override
        public void render(EntryStack<FluidStack> entry, GuiGraphics graphics, Rectangle bounds, int mouseX, int mouseY, float delta) {
            FluidStack stack = entry.getValue();
            if (stack.isEmpty()) {
                return;
            }
            TextureAtlasSprite sprite = ClientFluidStackHooks.getStillTexture((FluidStack)stack);
            if (sprite == null) {
                return;
            }
            int color = ClientFluidStackHooks.getColor((FluidStack)stack);
        }

        @Override
        @Nullable
        public Tooltip getTooltip(EntryStack<FluidStack> entry, TooltipContext context) {
            String amountTooltip;
            if (entry.isEmpty()) {
                return null;
            }
            ArrayList toolTip = Lists.newArrayList((Object[])new Component[]{entry.asFormattedText(context)});
            long amount = entry.getValue().getAmount();
            if (amount >= 0L && entry.get(EntryStack.Settings.FLUID_AMOUNT_VISIBLE).booleanValue() && (amountTooltip = I18n.get((String)FLUID_AMOUNT, (Object[])new Object[]{entry.getValue().getAmount()})) != null) {
                toolTip.addAll(Stream.of(amountTooltip.split("\n")).map(Component::literal).collect(Collectors.toList()));
            }
            if (Minecraft.getInstance().options.advancedItemTooltips) {
                ResourceLocation fluidId = BuiltInRegistries.FLUID.getKey((Object)entry.getValue().getFluid());
                toolTip.add(Component.literal((String)fluidId.toString()).withStyle(ChatFormatting.DARK_GRAY));
            }
            return Tooltip.create(toolTip);
        }
    }
}

