/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.categories;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.scroll.ScrollingContainer;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.DisplayRenderer;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.CloseableScissors;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import me.shedaniel.rei.plugin.common.displays.DefaultInformationDisplay;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DefaultInformationCategory
implements DisplayCategory<DefaultInformationDisplay> {
    @Override
    public CategoryIdentifier<? extends DefaultInformationDisplay> getCategoryIdentifier() {
        return BuiltinPlugin.INFO;
    }

    @Override
    public Component getTitle() {
        return Component.translatable((String)"category.rei.information");
    }

    @Override
    public DisplayRenderer getDisplayRenderer(DefaultInformationDisplay display) {
        final FormattedCharSequence name = display.getName().getVisualOrderText();
        return new DisplayRenderer(this){

            @Override
            public int getHeight() {
                Objects.requireNonNull(Minecraft.getInstance().font);
                return 10 + 9;
            }

            @Override
            public void render(GuiGraphics graphics, Rectangle rectangle, int mouseX, int mouseY, float delta) {
                graphics.drawString(Minecraft.getInstance().font, name, rectangle.x + 5, rectangle.y + 6, -1, false);
            }
        };
    }

    @Override
    public Renderer getIcon() {
        return new Renderer(this){

            @Override
            public void render(GuiGraphics graphics, Rectangle bounds, int mouseX, int mouseY, float delta) {
                graphics.pose().pushMatrix();
                graphics.pose().translate(-1.2f, -1.0f);
                graphics.innerBlit(RenderPipelines.GUI_TEXTURED, REIRuntime.getInstance().getDefaultDisplayTexture(), bounds.getCenterX() - 8, bounds.getCenterX() + 8, bounds.getCenterY() - 8, bounds.getCenterY() + 8, 0.453125f, 0.515625f, 0.0f, 0.0625f, -1);
                graphics.pose().popMatrix();
            }
        };
    }

    @Override
    public List<Widget> setupDisplay(DefaultInformationDisplay display, Rectangle bounds) {
        ArrayList widgets = Lists.newArrayList();
        widgets.add(Widgets.createRecipeBase(bounds));
        widgets.add(Widgets.createSlot(new Point(bounds.getCenterX() - 8, bounds.y + 15 - 9)).entries(display.getEntryStacks()));
        Rectangle rectangle = new Rectangle((double)bounds.getCenterX() - (double)bounds.width * 0.95 / 2.0, (double)(bounds.y + 35 - 9), (double)bounds.width * 0.95, (double)(bounds.height - 40 + 9));
        widgets.add(new ScrollableTextWidget(rectangle, display.getTexts()));
        return widgets;
    }

    @Override
    public int getDisplayHeight() {
        return 140;
    }

    @Override
    public int getFixedDisplaysPerPage() {
        return 1;
    }

    private static class ScrollableTextWidget
    extends WidgetWithBounds {
        private Rectangle bounds;
        private List<FormattedCharSequence> texts;
        private final ScrollingContainer scrolling = new ScrollingContainer(){

            public Rectangle getBounds() {
                Rectangle bounds = this.getBounds();
                return new Rectangle(bounds.x + 1, bounds.y + 1, bounds.width - 2, bounds.height - 2);
            }

            public int getMaxScrollHeight() {
                int i = 2;
                for (FormattedCharSequence entry : texts) {
                    int n;
                    if (entry == null) {
                        n = 4;
                    } else {
                        Objects.requireNonNull(font);
                        n = 9;
                    }
                    i += n;
                }
                return i;
            }
        };

        public ScrollableTextWidget(Rectangle bounds, List<Component> texts) {
            this.bounds = Objects.requireNonNull(bounds);
            this.texts = Lists.newArrayList();
            for (FormattedText formattedText : texts) {
                if (!this.texts.isEmpty()) {
                    this.texts.add(null);
                }
                this.texts.addAll(Minecraft.getInstance().font.split(formattedText, bounds.width - 11));
            }
        }

        public boolean mouseScrolled(double mouseX, double mouseY, double amountX, double amountY) {
            if (this.containsMouse(mouseX, mouseY) && amountY != 0.0) {
                this.scrolling.offset(ClothConfigInitializer.getScrollStep() * -amountY, true);
                return true;
            }
            return false;
        }

        public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
            if (this.scrolling.updateDraggingState(event.x(), event.y(), event.button())) {
                return true;
            }
            return super.mouseClicked(event, doubleClick);
        }

        public boolean mouseDragged(MouseButtonEvent event, double deltaX, double deltaY) {
            if (this.scrolling.mouseDragged(event.x(), event.y(), event.button(), deltaX, deltaY)) {
                return true;
            }
            return super.mouseDragged(event, deltaX, deltaY);
        }

        @Override
        public Rectangle getBounds() {
            return this.bounds;
        }

        public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
            this.scrolling.updatePosition(delta);
            Rectangle innerBounds = this.scrolling.getScissorBounds();
            try (CloseableScissors scissors = ScrollableTextWidget.scissor(graphics, innerBounds);){
                int currentY = -this.scrolling.scrollAmountInt() + innerBounds.y;
                for (FormattedCharSequence text : this.texts) {
                    int n;
                    if (text != null) {
                        Objects.requireNonNull(this.font);
                        if (currentY + 9 >= innerBounds.y && currentY <= innerBounds.getMaxY()) {
                            graphics.drawString(this.font, text, innerBounds.x + 2, currentY + 2, REIRuntime.getInstance().isDarkThemeEnabled() ? -4473925 : -16185079, false);
                        }
                    }
                    if (text == null) {
                        n = 4;
                    } else {
                        Objects.requireNonNull(this.font);
                        n = 9;
                    }
                    currentY += n;
                }
            }
            if (this.scrolling.hasScrollBar()) {
                if (this.scrolling.scrollAmount() > 8.0) {
                    graphics.fillGradient(innerBounds.x, innerBounds.y, innerBounds.getMaxX(), innerBounds.y + 16, -3750202, 0xC6C6C6);
                }
                if ((double)this.scrolling.getMaxScroll() - this.scrolling.scrollAmount() > 8.0) {
                    graphics.fillGradient(innerBounds.x, innerBounds.getMaxY() - 16, innerBounds.getMaxX(), innerBounds.getMaxY(), 0xC6C6C6, -3750202);
                }
            }
            scissors = ScrollableTextWidget.scissor(graphics, this.scrolling.getBounds());
            try {
                this.scrolling.renderScrollBar(graphics, 0, 1.0f);
            }
            finally {
                if (scissors != null) {
                    scissors.close();
                }
            }
        }

        public List<? extends GuiEventListener> children() {
            return Collections.emptyList();
        }
    }
}

