/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.transfer;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import me.shedaniel.rei.api.common.plugins.REICommonPlugin;
import me.shedaniel.rei.api.common.transfer.info.stack.SlotAccessor;
import me.shedaniel.rei.api.common.transfer.info.stack.SlotAccessorRegistry;
import me.shedaniel.rei.impl.common.InternalLogger;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.Nullable;

public class SlotAccessorRegistryImpl
implements SlotAccessorRegistry {
    private final Map<ResourceLocation, SlotAccessorRegistry.Serializer> map = new HashMap<ResourceLocation, SlotAccessorRegistry.Serializer>();

    @Override
    public void startReload() {
        this.map.clear();
    }

    @Override
    public void endReload() {
        InternalLogger.getInstance().debug("Registered %d slot accessor serializers", this.map.size());
    }

    @Override
    public void acceptPlugin(REICommonPlugin plugin) {
        plugin.registerSlotAccessors(this);
    }

    @Override
    public void register(ResourceLocation id, final Predicate<SlotAccessor> accessorPredicate, final SlotAccessorRegistry.Serializer serializer) {
        this.map.put(id, new SlotAccessorRegistry.Serializer(){

            @Override
            public SlotAccessor read(AbstractContainerMenu menu, Player player, CompoundTag tag) {
                return serializer.read(menu, player, tag);
            }

            @Override
            @Nullable
            public CompoundTag save(AbstractContainerMenu menu, Player player, SlotAccessor accessor) {
                if (!accessorPredicate.test(accessor)) {
                    return null;
                }
                return serializer.save(menu, player, accessor);
            }
        });
        InternalLogger.getInstance().debug("Added slot accessor serializer: %s [%s]", serializer, id);
    }

    @Override
    @Nullable
    public SlotAccessorRegistry.Serializer get(ResourceLocation id) {
        return this.map.get(id);
    }

    @Override
    public CompoundTag save(AbstractContainerMenu menu, Player player, SlotAccessor accessor) {
        for (Map.Entry<ResourceLocation, SlotAccessorRegistry.Serializer> entry : this.map.entrySet()) {
            CompoundTag tag = entry.getValue().save(menu, player, accessor);
            if (tag == null) continue;
            tag.putString("id", entry.getKey().toString());
            return tag;
        }
        return null;
    }

    @Override
    public SlotAccessor read(AbstractContainerMenu menu, Player player, CompoundTag tag) {
        String id = (String)tag.getString("id").orElseThrow();
        SlotAccessorRegistry.Serializer serializer = this.map.get(ResourceLocation.parse((String)id));
        if (serializer == null) {
            throw new NullPointerException("No serializer found for " + id);
        }
        return serializer.read(menu, player, tag);
    }
}

