/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.registry.displays;

import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.utils.GameInstance;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import me.shedaniel.rei.api.client.registry.display.reason.DisplayAdditionReason;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializerRegistry;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.api.common.plugins.REICommonPlugin;
import me.shedaniel.rei.api.common.registry.display.ServerDisplayRegistry;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.common.InternalLogger;
import me.shedaniel.rei.impl.common.networking.DisplaySyncPacket;
import me.shedaniel.rei.impl.common.plugins.ReloadManagerImpl;
import me.shedaniel.rei.impl.common.registry.displays.AbstractDisplayRegistry;
import me.shedaniel.rei.impl.common.registry.displays.DisplayConsumerImpl;
import me.shedaniel.rei.impl.common.registry.displays.DisplaysHolderImpl;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.Nullable;

public class ServerDisplayRegistryImpl
extends AbstractDisplayRegistry<REICommonPlugin, ServerDisplaysHolder>
implements ServerDisplayRegistry,
DisplayConsumerImpl {
    private static final Comparator<RecipeHolder<?>> RECIPE_COMPARATOR = Comparator.comparing(o -> o.id().location().getNamespace()).thenComparing(o -> o.id().location().getPath());
    private final Object2LongMap<UUID> playerVersionMap = new Object2LongOpenHashMap();
    private int reloadVersionHash = UUID.randomUUID().hashCode();

    public ServerDisplayRegistryImpl() {
        super(ServerDisplaysHolder::new);
        int[] tick = new int[]{0};
        TickEvent.SERVER_POST.register(instance -> {
            int n = tick[0];
            tick[0] = n + 1;
            if (n % 2 == 0 && !PluginManager.areAnyReloading() && ReloadManagerImpl.countRunningReloadTasks() == 0) {
                long version = this.currentVersion();
                ((ServerDisplaysHolder)this.holder()).everySecond();
                long currentVersion = this.currentVersion();
                if (version != currentVersion) {
                    InternalLogger.getInstance().debug("Updating players with new displays version %X [from %X]", currentVersion, version);
                    this.updatePlayers((RegistryAccess)instance.registryAccess(), CollectionUtils.filterToList(instance.getPlayerList().getPlayers(), player -> NetworkManager.canPlayerReceive((ServerPlayer)player, DisplaySyncPacket.TYPE)));
                    return;
                }
                ArrayList<ServerPlayer> toUpdate = new ArrayList<ServerPlayer>();
                for (ServerPlayer player2 : instance.getPlayerList().getPlayers()) {
                    long versionHash;
                    if (!NetworkManager.canPlayerReceive((ServerPlayer)player2, DisplaySyncPacket.TYPE) || (versionHash = this.playerVersionMap.getLong((Object)player2.getUUID())) == currentVersion) continue;
                    InternalLogger.getInstance().debug("Player %s has outdated displays version %X [latest version: %X]", player2.getGameProfile().name(), versionHash, currentVersion);
                    toUpdate.add(player2);
                }
                if (!toUpdate.isEmpty()) {
                    this.updatePlayers((RegistryAccess)instance.registryAccess(), toUpdate);
                }
            }
        });
        PlayerEvent.PLAYER_JOIN.register(player -> this.playerVersionMap.put((Object)player.getUUID(), 0L));
        PlayerEvent.PLAYER_QUIT.register(player -> this.playerVersionMap.removeLong((Object)player.getUUID()));
    }

    private void updatePlayers(RegistryAccess registryAccess, List<ServerPlayer> players) {
        Supplier resetPacket = Suppliers.memoize(() -> this.getResetPackets(registryAccess));
        HashMap updatesMap = new HashMap();
        Function<IntIntPair, List> updatePackets = pair -> updatesMap.computeIfAbsent(pair, $ -> this.getUpdatePackets(registryAccess, pair.leftInt(), pair.rightInt()));
        long version = this.currentVersion();
        for (ServerPlayer player : players) {
            long playerVersion = this.playerVersionMap.getLong((Object)player.getUUID());
            long playerReloadHash = playerVersion >>> 32;
            this.playerVersionMap.put((Object)player.getUUID(), version);
            if (playerReloadHash != (long)this.reloadVersionHash) {
                InternalLogger.getInstance().debug("Player %s has outdated displays version %X [latest version: %X], sending reset packet request.", player.getGameProfile().name(), playerVersion, version);
                for (Packet packet : (List)resetPacket.get()) {
                    player.connection.send(packet);
                }
                continue;
            }
            if (playerVersion == version) continue;
            int playerMinorVersion = (int)playerVersion;
            int currentMinorVersion = (int)version;
            if (playerMinorVersion > currentMinorVersion) {
                InternalLogger.getInstance().debug("Player %s has too new displays version %X [latest version: %X], sending reset packet request.", player.getGameProfile().name(), playerVersion, version);
                for (Packet packet : (List)resetPacket.get()) {
                    player.connection.send(packet);
                }
                continue;
            }
            InternalLogger.getInstance().debug("Player %s has outdated displays version %X [latest version: %X], sending update packets.", player.getGameProfile().name(), playerVersion, version);
            for (Packet packet : updatePackets.apply(IntIntPair.of((int)playerMinorVersion, (int)currentMinorVersion))) {
                player.connection.send(packet);
            }
        }
    }

    private List<Packet<?>> getResetPackets(RegistryAccess registryAccess) {
        final List<Set<Display>> displays = ((ServerDisplaysHolder)this.holder()).displaysByVersion;
        if (displays.isEmpty() || displays.size() == 1 && displays.get(0).isEmpty()) {
            return List.of();
        }
        ArrayList packets = new ArrayList();
        NetworkManager.collectPackets(packets::add, (NetworkManager.Side)NetworkManager.s2c(), (CustomPacketPayload)new DisplaySyncPacket(DisplaySyncPacket.SyncType.SET, (Collection<Display>)new AbstractCollection<Display>(this){

            @Override
            public Iterator<Display> iterator() {
                return displays.stream().flatMap(Collection::stream).iterator();
            }

            @Override
            public int size() {
                return displays.stream().mapToInt(Set::size).sum();
            }
        }, this.currentVersion()), (RegistryAccess)registryAccess);
        return packets;
    }

    private List<Packet<?>> getUpdatePackets(RegistryAccess registryAccess, int from, int to) {
        final List<Set<Display>> displays = ((ServerDisplaysHolder)this.holder()).displaysByVersion.subList(from, to);
        if (displays.isEmpty() || displays.size() == 1 && displays.get(0).isEmpty()) {
            return List.of();
        }
        ArrayList packets = new ArrayList();
        NetworkManager.collectPackets(packets::add, (NetworkManager.Side)NetworkManager.s2c(), (CustomPacketPayload)new DisplaySyncPacket(DisplaySyncPacket.SyncType.APPEND, (Collection<Display>)new AbstractCollection<Display>(this){

            @Override
            public Iterator<Display> iterator() {
                return displays.stream().flatMap(Collection::stream).iterator();
            }

            @Override
            public int size() {
                return displays.stream().mapToInt(Set::size).sum();
            }
        }, this.currentVersion()), (RegistryAccess)registryAccess);
        return packets;
    }

    @Override
    public void startReload() {
        this.reloadVersionHash = UUID.randomUUID().hashCode();
        super.startReload();
    }

    private long currentVersion() {
        return (long)this.reloadVersionHash << 32 | (long)((ServerDisplaysHolder)this.holder()).displaysByVersion.size();
    }

    @Override
    public void acceptPlugin(REICommonPlugin plugin) {
        plugin.registerDisplays(this);
    }

    @Override
    public boolean add(Display display, @Nullable Object origin) {
        if (DisplaySerializerRegistry.getInstance().isRegistered(display.getSerializer())) {
            return super.add(display, origin);
        }
        InternalLogger.getInstance().throwException(new IllegalStateException("Tried to add display [%s] with unregistered serializer: %s".formatted(display, display.getSerializer())));
        return false;
    }

    @Override
    public void endReload() {
        InternalLogger.getInstance().debug("Found preliminary %d displays", this.size());
        this.fillRecipes();
    }

    private void fillRecipes() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        int lastSize = this.size();
        if (!this.fillers().isEmpty()) {
            List<RecipeHolder<?>> allSortedRecipes = this.getAllSortedRecipes();
            for (int i = allSortedRecipes.size() - 1; i >= 0; --i) {
                RecipeHolder<?> recipe = allSortedRecipes.get(i);
                try {
                    this.addWithReason(recipe, DisplayAdditionReason.RECIPE_MANAGER);
                    continue;
                }
                catch (Throwable e) {
                    InternalLogger.getInstance().error("Failed to fill display for recipe: %s [%s]", recipe.value(), recipe.id(), e);
                }
            }
        }
        InternalLogger.getInstance().debug("Filled %d displays from recipe manager in %s", this.size() - lastSize, stopwatch.stop());
    }

    private List<RecipeHolder<?>> getAllSortedRecipes() {
        return GameInstance.getServer().getRecipeManager().getRecipes().parallelStream().sorted(RECIPE_COMPARATOR).toList();
    }

    public static class ServerDisplaysHolder
    extends DisplaysHolderImpl {
        private final List<Set<Display>> displaysByVersion = new ArrayList<Set<Display>>();
        private final Set<Display> pendingDisplays = new ReferenceOpenHashSet();
        private int timeUntilCollection = 0;

        @Override
        public void add(Display display, @Nullable Object origin) {
            super.add(display, origin);
            this.pendingDisplays.add(display);
            this.timeUntilCollection = 10;
        }

        @Override
        protected void removeFallout(Display display) {
            this.pendingDisplays.remove(display);
            this.displaysByVersion.forEach(set -> set.remove(display));
        }

        private void everySecond() {
            if (this.timeUntilCollection > 0 && --this.timeUntilCollection <= 0) {
                this.displaysByVersion.add((Set<Display>)new ReferenceOpenHashSet(this.pendingDisplays));
                this.pendingDisplays.clear();
            }
        }
    }
}

