/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.networking;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.function.IntFunction;
import java.util.function.UnaryOperator;
import me.shedaniel.rei.RoughlyEnoughItemsNetwork;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.impl.client.registry.display.DisplayRegistryImpl;
import me.shedaniel.rei.impl.common.InternalLogger;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.ByIdMap;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public record DisplaySyncPacket(SyncType syncType, Collection<Display> displays, long version) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<DisplaySyncPacket> TYPE = new CustomPacketPayload.Type(RoughlyEnoughItemsNetwork.SYNC_DISPLAYS_PACKET);
    public static final StreamCodec<? super RegistryFriendlyByteBuf, DisplaySyncPacket> STREAM_CODEC = StreamCodec.composite(SyncType.STREAM_CODEC, DisplaySyncPacket::syncType, (StreamCodec)Display.streamCodec().apply(codec -> new StreamCodec<RegistryFriendlyByteBuf, Display>(){

        public void encode(RegistryFriendlyByteBuf buf, Display display) {
            RegistryFriendlyByteBuf tmpBuf = new RegistryFriendlyByteBuf(Unpooled.buffer(), buf.registryAccess());
            try {
                codec.encode((Object)tmpBuf, (Object)display);
            }
            catch (Throwable throwable) {
                tmpBuf.release();
                buf.writeBoolean(false);
                InternalLogger.getInstance().debug("Failed to encode display: %s".formatted(display), throwable);
                return;
            }
            buf.writeBoolean(true);
            RegistryFriendlyByteBuf.writeByteArray((ByteBuf)buf, (byte[])ByteBufUtil.getBytes((ByteBuf)tmpBuf));
            tmpBuf.release();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Display decode(RegistryFriendlyByteBuf buf) {
            boolean success = buf.readBoolean();
            if (!success) {
                return null;
            }
            RegistryFriendlyByteBuf tmpBuf = new RegistryFriendlyByteBuf(Unpooled.wrappedBuffer((byte[])RegistryFriendlyByteBuf.readByteArray((ByteBuf)buf)), buf.registryAccess());
            try {
                Display display = (Display)codec.decode((Object)tmpBuf);
                return display;
            }
            catch (Throwable throwable) {
                Display display = null;
                return display;
            }
            finally {
                tmpBuf.release();
            }
        }
    }).apply(ByteBufCodecs.collection(ArrayList::new)).map(list -> list.stream().filter(Objects::nonNull).toList(), UnaryOperator.identity()), DisplaySyncPacket::displays, (StreamCodec)ByteBufCodecs.LONG, DisplaySyncPacket::version, DisplaySyncPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handle(NetworkManager.PacketContext context) {
        DisplayRegistryImpl registry = (DisplayRegistryImpl)DisplayRegistry.getInstance();
        if (this.syncType() == SyncType.SET) {
            InternalLogger.getInstance().info("[REI Server Display Sync] Received server's request to set %d recipes.", this.displays().size());
            registry.addJob(() -> {
                registry.removeSyncedRecipes();
                for (Display display : this.displays()) {
                    registry.add(display, DisplayRegistryImpl.SYNCED);
                }
            });
        } else if (this.syncType() == SyncType.APPEND) {
            InternalLogger.getInstance().info("[REI Server Display Sync] Received server's request to append %d recipes.", this.displays().size());
            registry.addJob(() -> {
                for (Display display : this.displays()) {
                    registry.add(display, DisplayRegistryImpl.SYNCED);
                }
            });
        }
    }

    public static enum SyncType {
        APPEND,
        SET;

        public static final IntFunction<SyncType> BY_ID;
        public static final StreamCodec<ByteBuf, SyncType> STREAM_CODEC;

        static {
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])SyncType.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }
}

