/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.transfer;

import java.util.List;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.SimpleDisplayRenderer;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.EntryListWidget;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.tooltip.TooltipComponent;

public class MissingStacksTooltip
implements ClientTooltipComponent,
TooltipComponent {
    private static final int MAX_WIDTH = 200;
    private final List<EntryIngredient> stacks;

    public MissingStacksTooltip(List<EntryIngredient> stacks) {
        this.stacks = SimpleDisplayRenderer.simplify(stacks);
    }

    public int getHeight(Font font) {
        int entrySize = EntryListWidget.entrySize();
        int w = Math.max(1, 200 / entrySize);
        int height = Math.min(6, Mth.ceil((float)((float)this.stacks.size() / (float)w))) * entrySize + 2;
        return height += 12;
    }

    public int getWidth(Font font) {
        int entrySize = EntryListWidget.entrySize();
        int w = Math.max(1, 200 / entrySize);
        int size = this.stacks.size();
        int width = Math.min(size, w) * entrySize;
        width = Math.max(width, font.width((FormattedText)Component.translatable((String)"text.rei.missing")));
        return width;
    }

    public void renderImage(Font font, int x, int y, int width, int height, GuiGraphics graphics) {
        int entrySize = EntryListWidget.entrySize();
        int w = Math.max(1, 200 / entrySize);
        int i = 0;
        for (EntryIngredient entry : this.stacks) {
            int x1 = x + i % w * entrySize;
            int y1 = y + 13 + i / w * entrySize;
            if (++i / w > 5) {
                MutableComponent text = Component.literal((String)("+" + (this.stacks.size() - w * 6 + 1))).withStyle(ChatFormatting.GRAY);
                graphics.drawString(font, (Component)text, x1 + entrySize / 2 - font.width((FormattedText)text) / 2, y1 + entrySize / 2 - 1, -1);
                break;
            }
            EntryStack stack = entry.isEmpty() ? EntryStack.empty() : (entry.size() == 1 ? (EntryStack)entry.get(0) : (EntryStack)entry.get(Mth.floor((double)((double)(System.currentTimeMillis() / 1000L) % (double)entry.size()))));
            stack.render(graphics, new Rectangle(x1, y1, entrySize, entrySize), -1000, -1000, 0.0f);
        }
    }

    public void renderText(GuiGraphics graphics, Font font, int x, int y) {
        graphics.drawString(font, (Component)Component.translatable((String)"text.rei.missing").withStyle(ChatFormatting.GRAY), x, y + 2, -1);
    }
}

